       subroutine domin
c************************************************************
c    initialization program for bfgs-minimization
c************************************************************
c copyright = spellucci 
      include './domincom.inc'
      double precision term,tol1
      integer i,j,k
c  we compute the machine precision first
      epsmac = 2.d0**(-20)
      term=1.d0+epsmac
      do while ( term .ne. 1.d0 )
        epsmac=epsmac/2.d0
        term=1.d0+epsmac
      enddo
      epsmac=epsmac+epsmac
      tolmac=epsmac
      do while ( tolmac .ne. 0.d0 )
      tol1=tolmac
      tolmac=tolmac/16.d0
      enddo
      tolmac=tol1
c  accinf contains information to be printed in the short protocol
      do i=1,maxit
        do j=1,14
          accinf(i,j)=0.d0
        enddo
      enddo
      test1=.false.
      test2=.false.
      test3=.false.
      test4=.false.
      epsx=epsmac**(2.d0/3.d0)
      epsg=epsx
      epsf=epsmac*1.d3
      eta=epsmac**.5d0
      sigsm=epsx
      sigla=2048.d0
      beta=2.d0
      alpha=.1d0
      delta=.01d0
      theta=.99d0
      deldif=dexp(dlog(epsmac)/7.d0)*.25d0
      iterma=maxit
c      call setup
c      call setup  /* modif allais 30/11/2005 11:09 */
c      open(10,file='domin'//ident(1:4)//'.res',status='unknown')
c      write(10,*) ' bfgsminimizer v030392 copyright p. spellucci'
c     epsx = required precision  in x (relative)
c     iterma = 30 * n sufficient as a rule of thumb
c     test1 : if true, a short condensed protocol is printed
c             with intermediate information 
c     accinf, storage for this information
c     test2 = .true. prints the essential intermediate information
c     
c     test3 = .true. prints the quasi-newton -update
c              gives excessive output
c     test4 = .true. prints one-line output in the active window
c             for every step,
c     
      icf=0
      icgf=0
      iup=0
      inoup=0
      ires=0
      imod=0
c***********************
      if ( test4 ) then
         write(*,*) ' bfgs-minimizer v030392 copyright p. spellucci'
         write(*,*) ' ',ident
      endif
      call bfgs(cold)
c start may change control parameters
c param cold for bfgs means fresh start
      if ( .not. analyt )      icf=icf-n*icgf*6
c      write(10,fmt='(/1x,a40,
c     1       /1x,''termination reason '',d8.1,/1x,''fxopt = '',d21.14)')
c     2       ident,bfgste,fx
c      do i=1,n
c          write(10,fmt='(1x,''x('',i3,'')='',d21.14,
c     1                '' grad('',i3,'')='',d21.14)') i,x(i),i,gradx(i)
c      enddo


c     number of function values (reduced by those required for 
c     numerical gradient) and number of gradients used
c     
c      write(10,3000) icf,icgf
c      write(10,fmt='(1x,''last estimate of condition number of'',
c     f         '' updated hessian is '',d15.7)') accinf(niter,8)
c      write(10, fmt='(1x,''steps='',i5,'' updates='',i5,
c     f                  '' noupdates='',i5,
c     f                 '' restarts='',i5,'' modsteps='',i5)') 
c     f                 niter,iup,inoup,ires,imod
      if ( bfgste .lt. 0.d0 ) test1=.true.
      if ( test1 ) then
c        write(10,fmt='('' bfgs short protocol '')')
        do j=1,niter
c          write(10,2000) (accinf(j,k),k=1,14)
        enddo
      endif
c     output of short information:
c     it = stepnumber , f = function value, delx = change in x
c     ngrad = norm of gradient, (behaves nonmonotonic) ,
c     n(a)= norm of quasi-newton-matrix, approximately  norm of hessian
c     thet2 Powells parameter, << 1 means that f behaves strongly
c     nonconvex , this reduces the efficiency
c     sig = stepsize  x(new)=x(old)-sig*direction(d),
c     sig << 1 means, that we are far from the asymtotic (fast) phase
c     of the iteration. 
c     dskal (scaling of d) . dskal notequal 1 means that correction d is 
c     too large. may be due to bad update
c     using the internal scaling of d reduces the possibility of
c     failures due to overflow 
c     n(d)=norm of  d, icf+ = number of f-evaluations for stepsize-
c     determination for the current step
c     should be 1 or 2 normally. a large icf+ means that
c     d is "bad" , that is the update is bad or x is far from the solution.
c     restart = 1 means a reinitialization of the quasi-newton-update
c     update = -1 means a suppression of the quasi-newton-update
c     that is f behaves strongly nonconvex
c     
c     termination: bfgste = 0 , 1 normal termination 
c               =2 derictional derivative exremely small
c               as a rule this occurs with badly conditioned cases
c               where the desired accuracy in x and grad f cannot be
c               obtained
c               -2 iterma steps taken without satisfying termination 
c               criteria
c               -1 extremely small stepsize after a restart 
c               (condition number of hessian > 1/sigsm
c               -3 irrecoverable error in calling f or gradf
c               that is in an extremely small neighborhood of the current
c               x the user supplied function returns with an error
      close(10)
      return
2000  format(
     1        (/1x,'it=',d10.4,'     f=',d10.4,'  delx=',d10.4,
     2            ' ngrad=',d10.4,'  n(a)=',d10.4,' thet2=',d10.4
     3            /14x,'dirder=',d10.4,'  cond=',d10.4
     4            /14x,'   sig=',d10.4,' dskal=',d10.4,'  n(d)=',
     5            d10.4,'  icf+=',d10.4,
     6            /13x,'restart=',d8.1,'  update=',d8.1))
3000  format(/,' function calls',i11,' gradient calls  ',
     1       i10)
      end
c****************************************************************
c     determination of stepsize by an armijo-like test for 
c     descent
c****************************************************************
c copyright = spellucci 
      subroutine step
      include './domincom.inc'
c********************************************************************
c   n = actual dimension
c   x = current point
c   d = current direction
c   gradx = gradient of f at x
c   x,d,gradx = input ( in common )
c   x0,d0,gradx0 etc. information from previous step
c   
c   xnorm,dnorm = euclidean length of x and d
c   stepte = 1 in case of success , =-1 otherwise 
c   sig = computed stepsize
c   the routine assumes that sig=1 is asymptotically optimal
c   (otherwise one has to change initialization of sig) 
c   sigsm = minimal stepsize allowed
c   sigla = maximal stepsize allowed
c   alpha = maximal reduction of stepsize per reduction-step
c   delta = the armijo-parameter
c   beta = max. growth of  xnorm allowed for  sig=1 
c   theta = bound for cos(angle(d,d0))
c           we try stepsizes larger than one, if this is exceeded.
c           in that case d0 and d point (almost) in the same direction 
c            
c*********************************************************************
        integer i
        double precision x1(nx),vecnor,t,sigmin,fmin,cosphi,f1,skal1
c***
c       sigmin is the current best point, fmin the corrsponding fuction
c       value (if we increase sig)
c*** 
        logical err
        xnorm=vecnor(n,x)
        dnorm=vecnor(n,d)
        dskal=1.d0
        cosphi=skal1(1,n,d,d0)
        t=1.d0
        do i=1,n
          if ( dabs(d(i)) .gt. (dabs(x(i))+1.d0)*(beta-1.d0) )
     f    t=dmin1(t,(beta-1.d0)*(dabs(x(i))+1.d0)/dabs(d(i)))
        enddo
        if ( t .lt. 1.d0  ) then
c*****  rescale d      
          dnorm=t*dnorm
          dirder=t*dirder
          cosphi=cosphi*t
          dskal=t
          do i= 1,n
          d(i)=d(i)*t
          enddo
        endif
        cosphi=dabs(cosphi)/(dnorm*d0norm)
c**** if the user function f reports err=.true.  
c     then the stepsize is reduced and we try again
c     
        sig=1.d0
100     continue
c*****  new x. check for descent
        do i =1,n
          x1(i)=x(i)-sig*d(i)
        enddo
        err=.false.
        call f(x1,f1,err)
c*** check err
          if ( err ) then
            if ( sig .gt. 1.d0 ) then
c*** do not further increase of sig
              err=.false.
              sig=sigmin
              f1=fmin
              do i=1,n
                x1(i)=x(i)-sig*d(i)
              enddo
              goto 200
            endif
            sig=sig*.5d0
            if ( sig .ge. sigsm ) then
              goto 100
            else
              stepte = -1.d0
              return
            endif
          endif
        ftest=f1
        call info(6)
c*****  new function value
        if ( sig .gt. 1.d0 ) then
          if ( f1 .gt. fmin ) then
c*****      f stops decreasing
            sig=sigmin
            f1=fmin
            do i=1,n
              x1(i)=x(i)-sig*d(i)
            enddo
            goto 200
          else
            if ( sig .lt. sigla ) then
              fmin = f1
              sigmin = sig
              sig=dmin1(sigla,sig+sig)
              goto 100
            else
              goto 200
            endif
          endif
        endif
        if ( fx - f1 .ge. sig*delta*dirder ) then
c*****  goldstein-armijo test satisfied
        if ( sig .eq. 1.d0 .and. cosphi .ge. theta .and. sig0 
     1               .ge. 1.d0  ) then
c*****    try sig . 1
            fmin = f1
            sigmin = sig
            if ( fx-f1 .lt. sig*dirder ) then
              sig=dmin1(sigla,
     1           dmax1(sig+sig,dirder*sig**2/(2.d0*(f1-fx+sig*dirder))))
            else
              sig=dmin1(sigla,sig+sig)
            endif
            goto 100
          endif
          goto 200
        else
          sig=dmax1(alpha*sig,
     1              dmin1(dirder*sig**2/(2.d0*(f1-fx+sig*dirder)),
     2                   .5d0*sig))
          if ( sig .lt. sigsm ) then
            stepte = -1.d0
            return
          else
            goto 100
          endif
        endif
200   continue
c******   new x accepted 
          fx0 = fx
          fx = f1
          stepte = 1.d0 
          x0norm = xnorm
          d0norm = dnorm
          sig 0 = sig
          do i = 1,n
            gradx0(i)=gradx(i)
            x0(i)=x(i)
            d0(i)=d(i)
            x(i)=x1(i)
            difx(i)=x(i)-x0(i)
          enddo
          if ( analyt ) then
            call gradf(x,gradx ,err)
          else
            call numgrd(x,gradx,err)
          endif
          xnorm=vecnor(n,x)
          if ( err ) then
c****  panic; f can be evaluated, but grad(f) not
            stepte=-2.d0
            return
          endif
          return
      end
c*******************************************************************
c     scalar product of two vectors or parts of vectors
c*******************************************************************
c copyright = spellucci 
      double precision function skal1(i,j,a,b)
      implicit none
      integer i,j,k
      double precision a(*),b(*)
      double precision s
        if ( i .gt. j ) then
          skal1=0.d0
          return
        else
          s=0.d0
          do   k=i,j
            s=s+a(k)*b(k)
          enddo
          skal1=s
          return
        endif
      end
c*******************************************************************
c     bfgs-method using modified update and cholesky-decomposition
c     inaccurate line search possible
c*******************************************************************
      subroutine bfgs(cold1)
c copyright = spellucci 
      include './domincom.inc'
      logical cold1
      integer cfold,cgfold,icsf,i,j,ifail
      double precision v(nx),s1,s2,s3,s4,s5,difxin,wi,vecnor,
     f       skal1,den1
      double precision dif1,dif2,h
      logical resta,err
      external vecnor,skal1
c******* initialization *********************
      icsf=0
      if ( cold1 ) then
        do   i=1,n
          x(i)=xst(i)
          x0(i)=x(i)
          difx(i)=1.d0+dabs(x(i))
c************ to avoid termination in testx in step one
        enddo
        xnorm=vecnor(n,x)
        call initia
c******** initia initializes the quasi-newton-matrix a
      endif
c******** allows for modification of problem parameters
      sig0=0.d0
      d0norm=1.d0
c******** no stepsize larger than 1 in the first step
      niter=0
      thet2=1.d0
      bfgste=0.d0
      do   i=1,n
        d0(i)=0.d0
      enddo
      err=.false. 
      call f(x,fx,err)
      if ( err ) then
        bfgste=-3.d0
        return
      endif
      err=.false.
      if ( analyt ) then
        call gradf(x,gradx,err)
      else
        call numgrd(x,gradx,err)
      endif
      if ( err ) then
        bfgste=-3.d0
        return
      endif
c******************************************************
c     main iteration loop starts here
c******************************************************
100   continue
      niter=niter+1
      if ( niter .gt. iterma ) then
        niter=niter-1
        bfgste=-2.d0
        return
      endif
      do i=1,14
        accinf(niter,i)=0.d0
      enddo
      accinf(niter,1)=niter
      accinf(niter,2)=fx
      accinf(niter,3)=vecnor(n,difx)
      accinf(niter,4)=vecnor(n,gradx)
      accinf(niter,13)=-1.d0
      call info(1)
      s1=diaga(1)
      s2=a(1,1)
      do i=2,n
        s1=s1+diaga(i)
        s2=dmin1(s2,a(i,i))
      enddo
c***** s1 = spur (a), s2=minimal element on the diagonal of cholesky
c***** factor of a
      if ( niter .gt. 1 ) then
        if ( (tracea*epsmac .gt. 1.d0 .and. traceb*epsmac .gt. 1.d0)
     f     .or. s1*epsmac .gt. s2**2 .or. 
     f      accinf(niter-1,8) .gt. 1.d0 /eta  ) then
          call refres(niter)
          if ( bfgste .eq. -3.d0 ) return
          resta=.true.
        else
          resta=.false.
        endif
      endif
      call testx
      cfold=icf
      cgfold=icgf
c******** check accuracy
      if ( bfgste .eq. 1.d0 )  return
200   continue
      call cholso(a,n,gradx,d)
c******** d = quasi-newton direction (uphill)
      dnorm=vecnor(n,d)
      if ( dnorm .eq. 0.d0 ) then
        bfgste=0.d0
        return
      endif
      dirder=skal1(1,n,d,gradx)
      accinf(niter,7)=dirder
      if ( delta*dirder .le. epsmac*(dabs(fx)+1.d0)*100.d0 ) then
        bfgste=2.d0
        return
      endif
      call info(2)
c
c
      call step
c
c
      accinf(niter,9)=sig
      accinf(niter,10)=dskal
      accinf(niter,11)=dnorm
      i=icf-cfold
      if ( .not. analyt ) i=i-6*n*(icgf-cgfold)
      accinf(niter,12)=dble(i)
      if ( test4 ) then
        write(*,fmt='(i5,'' f='',d15.7,'' n(g)='',d15.7,'' dird='',
     1                 d15.7,'' sig='',d15.7)')
     2      niter,fx,accinf(niter,4),accinf(niter,7),accinf(niter,9)
      endif
      call info(3)
      if ( stepte .ne. 1.d0 ) then
        accinf(niter,13)=1.d0
        if ( resta ) then
          bfgste=-1.d0
          return
        else
          call refres(niter)
          if ( bfgste .eq. -3.d0 ) return
          resta=.true.
          goto 200
        endif
      endif
      if ( fx0-fx .gt. epsf*(dabs(fx)+epsf)) then
        icsf=0
      else
        icsf=icsf+1
      endif
      if ( icsf .eq. 4 ) then
        bfgste=3.d0
        return
      endif
      if ( vecnor(n,difx) .eq. 0 ) then
        bfgste=4.d0
        return
      endif
c*********************************************
c     compute update vectors z and y
c*********************************************
      thet2=1.d0
      s1=0.d0
      s2=0.d0
      s3=0.d0
      den1=skal1(1,n,d,gradx0)/dskal
      h=1.d0/dsqrt(den1)
      do   i=1,n
        y(i)=gradx0(i)*h
        dif1=difx(i)
        dif2=gradx(i)-gradx0(i)
        s1=dif1**2 + s1
        s2=dif2**2 + s2
        s3=dif1*dif2 + s3
        z(i)=dif2
      enddo
      if ( s3 .lt. eta*s2 ) then
c**********************************************
c     bfgs-updating impossible from this information
c     f not uniformly convex of course
c**********************************************
        s4=((sig*dskal)**2)*den1
c******** s(k)(transpose)*a(k)*s(k) in the usual notation
        if ( s3 .lt. .2d0*s4 ) thet2=.8d0*s4/(s4-s3)
        if ( thet2 .ne. 1.d0 ) imod=imod+1
        s3=0.2d0*s4
        h=(1.d0-thet2)*sig*dskal
c******** powells modification
c******** h*gradx0 = a(k)*s(k)*(1-thet2)
        do   i=1,n
          z(i)=thet2*z(i)+h*gradx0(i)
        enddo           
      endif
      accinf(niter,6)=thet2
      s3=1.d0/dsqrt(s3)
      do   i=1,n
        z(i)=z(i)*s3
      enddo
      call info(4)
      accinf(niter,14)=1.d0
      call cholso(a,n,z,v)
c**** v = b(k)*y(k)/sqrt(y's) in the usual notation
      s4=0.d0
      s5=0.d0
      do i=1,n
        difxin=difx(i)*s3
        wi=difxin+v(i)
c****   w=(sig(i)+(b*y)(i))/sqrt(y's)
        s5=s5+z(i)*wi
        s4=s4+v(i)*difxin
      enddo
c******** update a now and compute its cholesky-decomposition
      if ( n .le. nsmall ) then
c******** direct updating, save old information
        do    i=1,n
          diaga0(i)=diaga(i)
          a0(i,i)=a(i,i)
          diaga(i)=diaga(i)-y(i)**2+z(i)**2
          a(i,i)=diaga(i)               
c******** the strict lower part of a(a0) holds the quasi-newton
c         matrix, its diagonal being diaga (diaga0)
c******** the upper triangular part holds the cholesky-factor  
          do    j=1,i-1
            a0(i,j)=a(i,j)
            a0(j,i)=a(j,i)
            a(i,j)=a(i,j)-y(i)*y(j)+z(i)*z(j)
          enddo
        enddo
        call chol(a,n,a,ifail)
        if ( ifail .ne. 0 ) then
c******** restore old matrices 
          accinf(niter,14)=-1.d0
          inoup=inoup+1
          do    i=1,n
            diaga(i)=diaga0(i)
            do    j=1,n
              a(i,j)=a0(i,j)
            enddo
          enddo
        else
          iup=iup+1 
        endif
      else
c********* large n: quasi-newton matrix given as its 
c          cholesky-factor only. store/modify/restore
c********* this information only
        do    i=1,n
          diaga(i)=a(i,i)
          do    j=1,i-1
            a(i,j)=a(j,i)
          enddo
        enddo
        call update(a,z,y,n,ifail)
        if ( ifail .ne. 0 ) then
          inoup=inoup+1
          accinf(niter,14)=-1.d0
          do    i=1,n
            a(i,i)=diaga(i)
            do    j=1,i-1
              a(j,i)=a(i,j)
            enddo
          enddo
        else
          iup=iup+1
        endif
      endif
c****************************************************
c     next step
c****************************************************
      if ( accinf (niter,14) .eq. 1.d0 ) then
c**** recursive computation of trace(a) and trace(b)
c**** it is stopped, if one trace becomes negative, which indicates
c**** unreliability
        if ( tracea .gt. 0.d0 )
     f   tracea=tracea+vecnor(n,z)**2-vecnor(n,y)**2
        if ( traceb .gt. 0.d0 )
     f   traceb=traceb-2.d0*s4+s1*s3**2*s5 
        call info(7)
      endif
      call info(5)
      goto 100
      end
c*******************************************************************
c     subprograms for computation of an updated cholesky-
c     decomposition, method of stewart
c*******************************************************************
c copyright = spellucci 
      subroutine leftel(a,b,y,yl,n)
      implicit none
      include './dominpar.inc'
      integer i,j,n
      double precision a(nx,nx),b(nx),y(nx),yl,h
c     leftel assumes that the cholesky-factor of a
c     a=r(transpose)*r is stored in the upper half of a.
c     b is a right hand side. leftel solves 
c         y(transpose)*r = b(transpose)
c     yl=norm(y)**2
      yl=0.d0
      do   i=1,n
      h=b(i)
        do    j=1,i-1
        h = h - a(j,i)*y(j)
        enddo
      h=h/a(i,i)
      y(i)=h
      yl = h**2 + yl
      enddo
      return
      end
c**********************************************************
      double precision function dsq1(a,b)
c
c     computes sqrt(a**2+b**2) numerically safe
c
      implicit none
      double precision a,b,a1,b1
      a1=dabs(a)
      b1=dabs(b)
      if ( a1 .gt. b1 ) then 
        dsq1=a1*dsqrt(1.d0+(b1/a1)**2)
      else
        if ( b1 .gt. a1 ) then
          dsq1=b1*dsqrt(1.d0+(a1/b1)**2)
        else
          dsq1=a1*dsqrt(2.d0)
        endif
      endif
      return
      end
c*******************************************************************
      subroutine update(r,z,y,n,ifail)
c copyright = spellucci 
      implicit none
      include './dominpar.inc'
      integer ifail,i,j,n,i1
      double precision r(nx,nx),z(nx),y(nx)
      double precision sdiag(nx),rn1(nx),w(nx)
      double precision yl,zl,wl,wn1,ai,bi,h,dsq1
c     update computes  the upper triangular cholesky-factor
c     r1 of
c               r(transpose)*r+z*z(transpose)-y*y(transpose)
c     and restores it in r. the strict lower triangle of r re-
c     mains unchanged.
c     ifail=1 if the decomposition does'nt exist, ifail=2 on dimension
c     error, ifail=0 on success.
      if ( n .gt. nx ) then
        ifail=2
        return
      endif
      ifail=0
c     save subdiagonal
      do    i=1,n-1
      sdiag(i)=r(i+1,i)
      r(i+1,i)=0.d0
      enddo
c     step one: include z*z(transpose)
      zl=0.d0
      do   i=1,n
      zl = zl + z(i)**2
      enddo
      if ( zl .ne. 0.d0 ) then
c     solve w(transpose)*r=z(transpose)
      call leftel(r,z,w,wl,n)
      wl=dsqrt(wl+1.d0)
c     u(2)*u(3)*...*u(n)*w = ( norm(w),0,..,0)(transpose)
c     u(i) rotations
      do   i=n,2,-1
      if ( w(i) .ne. 0.d0 ) then
        i1=i-1
        ai=w(i1)
        bi=w(i)
        w(i1)=dsq1(ai,bi)
        ai=ai/w(i1)
        bi=-bi/w(i1)
        r(i,i1)=bi*r(i1,i1)
        r(i1,i1)=ai*r(i1,i1)
        do   j=i,n
          h = ai*r(i1,j) - bi*r(i,j)
          r(i,j) = bi*r(i1,j) + ai*r(i,j)
          r(i1,j) = h
        enddo
      endif
      enddo
c     r=d*r, d=diag(wl,1,...,1), r now hessenberg
      do    i=1,n
      r(1,i)=r(1,i)*wl
      enddo
c     r=u(n-1)*...*u(1)*r now upper triangular, 
c     u(i)  givens-rotations
      do    i=1,n-1
        i1=i+1
        ai=r(i,i)
        bi=-r(i1,i)
        h=dsq1(ai,bi)
        if ( h .ne. 0.d0 ) then 
          ai=ai/h
          bi=bi/h
          r(i,i)=h
          r(i1,i)=0.d0
          do   j=i+1,n
            h = ai*r(i,j) - bi*r(i1,j)
            r(i1,j) = bi*r(i,j) + ai*r(i1,j)
            r(i,j) = h
          enddo
        endif
      enddo
      endif
c     step two :  include -y*y(transpose)
      yl=0.d0
      do   i=1,n
        yl = yl + y(i)**2
      enddo
      if ( yl .ne. 0.d0 ) then
        call leftel(r,y,w,wl,n)
        if ( wl .ge. 1.d0 ) then
          ifail=1
        else
          wl=dsqrt(1.d0-wl)
          wn1=wl
c******************************************************
c      ( r(new) ,0 )                (    r  , w )
c      (-----------) = u(1)*...u(n)*(-----------)
c      (y(transp),1)                ((0,..,0),wl)             
c******************************************************
          do    i=n,1,-1
            ai=wn1
            bi=w(i)
            wn1=dsq1(ai,bi)
            if ( wn1 .ne. 0.d0 ) then
              ai=ai/wn1
              bi=bi/wn1
              rn1(i)=bi*r(i,i)
              r(i,i)=ai*r(i,i)
              do    j=i+1,n
                h = ai*r(i,j) - bi*rn1(j)
                rn1(j) = bi*r(i,j) + ai*rn1(j)
                r(i,j) = h
              enddo
            endif
          enddo
        endif
      endif
c     restore subdiagonal
      do   i=1,n-1
        r(i+1,i)=sdiag(i)
      enddo
      return
      end
c*******************************************************************
c     cholesky decomposition of a symmetric positive matrix a
c     the strict lower triangle remains unaffected
c     the upper triangle including the diagonal holds the cholesky-
c     factor. initially the strict upper triangle may be undefined
c*******************************************************************
      subroutine chol(a,n,r,ifail)
c copyright = spellucci 
      implicit none
      include './dominpar.inc'
      integer i,j,k,ifail,n
      double precision a(nx,nx),r(nx,nx),h,s
c     computes the cholesky-factor r of a=r(transp)*r
c     and stores it in the upper triangle of r
c     a and r may be identical. the strict lower triangle
c     of a remains unchanged anyway.
c     ifail .ne. 0 if the decomposition does'nt exist,
c     =0 otherwise
      ifail=0
      do    i=1,n
        h=a(i,i)
        do   j=1,i-1
          h=h-r(j,i)**2
        enddo
        if ( h .le. 0.d0 ) then
          ifail=1
          return
        endif
        h=dsqrt(h)
        r(i,i)=h
        h=1.d0/h
        do    k=i+1,n
          s=0.d0
          do    j=1,i-1
            s=s+r(j,i)*r(j,k)
          enddo
          s=(a(k,i)-s)*h
          r(i,k)=s
        enddo
      enddo
      return
      end
      subroutine cholso(a,n,b,x)
c copyright = spellucci 
      implicit none
      include './dominpar.inc'
      integer i,j,n
      double precision a(nx,nx),b(nx),c(nx),x(nx)
      double precision s
c     solves the linear system a*x=b, a symmetric positive definite
c     it is assumed that the cholesky-factor r of
c     a = r(transpose)*r
c     is stored in the upper triangle of a by chol.
      do   i=1,n
        s=0.d0
        do    j=1,i-1
          s=s+a(j,i)*c(j)
        enddo
        c(i)=(b(i)-s)/a(i,i)
      enddo
      do    i=n,1,-1
        s=0.d0
        do    j=i+1,n
          s=s+a(i,j)*x(j)
        enddo
        x(i)=(c(i)-s)/a(i,i)
      enddo
      return
      end
c*******************************************************************
c     initia is used for initializing the quasi newton-update
c*******************************************************************
      subroutine initia
c copyright = spellucci 
      include './domincom.inc'
      integer i,j
      double precision xd(nx),xst1(nx),gradxs(nx),gradx1(nx),gn,vecnor
c******* initialize with scaled identity
      logical err
      external vecnor
      do i=1,n
c*** xst1 should be in the range of definiton of gradf
        xst1(i)=x(i)*(1.d0+epsx)+dsign(epsx**2,x(i))
        xd(i)=x(i)-xst1(i)
      enddo 
      err=.false.
      if ( analyt ) then
        call gradf(x,gradxs,err)
      else
        call numgrd(x,gradxs,err)
      endif
      if ( err ) then
        bfgste=-3.d0
        return
      endif
      gn=vecnor(n,gradxs)
      if ( accinf(1,1) .eq. 0.d0 ) epsg=epsg*(gn+epsg)
      if ( analyt ) then
        call gradf(xst1,gradx1,err)
      else
        call numgrd(xst1,gradx1,err)
      endif
      if ( err ) then
        bfgste=-3.d0
        return
      endif
      do i=1,n
        gradxs(i)=gradxs(i)-gradx1(i)
      enddo
      gn=vecnor(n,gradxs)
      gn=gn/vecnor(n,xd)/dble(n)
      if ( gn .le. dsqrt(epsmac) ) gn = 1.d0
c**** gn should be an estimate of the order of magnitude of the hessian
c**** in case of a very small gn the computation of gn itself is expected
c**** to be unreliable
      if ( n .le. nsmall ) then
        do    i=1,n
          do    j=1,n
            a(i,j)=0.d0
            a0(i,j)=0.d0
          enddo
          a(i,i)=dsqrt(gn)
          diaga(i)=gn
          diaga0(i)=gn
        enddo
      else
        do    i=1,n
          do    j=1,n
            a(j,i)=0.d0                 
          enddo
          a(i,i)=dsqrt(gn)
          diaga(i)=gn
        enddo
      endif
      tracea=dble(n)*gn
      traceb=dble(n)/gn
      return
      end
c*******************************************************************
c     refres is used on resta in bfgs
c     resta is done only on occasion of a too small stepsize
c     sig .lt. sigsm
c*******************************************************************
      subroutine refres(niter1)
      include './domincom.inc'
      integer niter1
c copyright = spellucci 
      ires=ires+1
      accinf(niter1,13)=1.d0
      call initia
c******** resta with scaled unit matrix
      return
      end
c*******************************************************************
c     testx checks for sufficient accuracy
c*******************************************************************
      subroutine testx
      include './domincom.inc'
      logical xsatis,gsatis
      double precision an,sx,sg,damin,vecnor
      integer i
      an=0.d0
      sx=vecnor(n,difx)
      sg=vecnor(n,gradx)
      damin=a(1,1)
      do   i=1,n
        an=an+diaga(i)
        damin=dmin1(damin,a(i,i))
      enddo
      accinf(niter,5)=an
      if ( tracea .gt. 0.d0 .and. traceb .gt. 0.d0 ) then
        accinf(niter,8)=tracea*traceb/dble(n*n)
      else
        accinf(niter,8)=an/damin**2
      endif
      xsatis = sx .le. epsx*(xnorm+epsx)
      gsatis = sg .le. dmax1(epsg,epsmac*accinf(niter,8)) 
      if ( xsatis .and. gsatis ) bfgste=1.d0
      return
      end
c*******************************************************************
c     info provides for intermediate output for 
c     testing purposes
c     info may have an empty body of course
c*******************************************************************
      subroutine info(case)
c copyright = spellucci 
c
c     prints intermediate information
c
      include './domincom.inc'
      integer case,i,j
      if ( .not. test2 ) return
      goto ( 1000,2000,3000,4000,5000,6000,7000 ) ,case
1000  continue
c      write(10,1100) niter,fx,accinf(niter,4)
1100  format(1h0,'******************************************'
     1       /1x,i3,'-ter iteration step',
     2       /1x,'f = ',d21.14,' norm(gradx)=',d21.14)
c      write(10,*) ' x = '
c      write(10,fmt='(1x,5(d21.14,2x))') (x(j),j=1,n)
      if ( test3 .and. n .le. nsmall ) then 
      call matdru(a,nx,nx,n,n,'a/r-mat ',10,.false.)
c      write(10,*) 'diagonal of updated quasi newton matrix'
c      write(10,1200) (diaga(j),j=1,n)
1200  format(1x,5(d21.14,2x))
      endif
      return
2000  continue
c      write(10,2100)    accinf(niter,5),accinf(niter,8)
2100  format(/'norm(a)=',d10.4,'  cond(a)=',d10.4)
c      write(10,*) ' d = '
c      write(10,fmt='(1x,5(d21.14,2x))') (d(j),j=1,n)
      return
3000  continue
c      write(10,3100) (accinf(niter,j),j=9,12)
3100  format(/,'sigma=',d10.4,'  dskal=',d10.4,' norm(d)=',d10.4,
     1     ' number of function calls=',d10.4)
      return
4000  continue
c      write(10,4100) thet2
c      write(10,*) ' update vector z '
c      write(10,4200) (z(i),i=1,n)
c      write(10,*) ' update vector y '
c      write(10,4200) (y(i),i=1,n)
      return
4100  format(/,'parameter theta2 =',d10.4)
4200  format(1x,5(d21.14,2x))
5000  continue
c      write(10,5100) accinf(niter,13),accinf(niter,14)
5100  format(/'restart =',d8.1,' update = ',d8.1)
      return
6000  continue
c      write(10,6100) sig,ftest
6100  format(1x,'step***  sig = ',d10.4,'  f(x-sig*d)=',d21.14)
      return
7000  continue
c      write(10,fmt='(1x,''trace a='',d15.7,'' trace b='',d15.7)')
c     f      tracea,traceb 
      end
c*****************************************************************
c     subprogram for structured output of a matrix 
c*****************************************************************
      subroutine matdru(a,me,ne,ma,na,head,lognum,fix)
      implicit none
      double precision a
      integer lognum,me,ma,ne,na,ju,jo,i,j,anz
      dimension a(me,ne)
      logical fix
      character*(*) head
      if ( ma .gt. 999 .or. na .gt. 999 ) then
         write(lognum
     f   ,fmt='(''call to matdru suppressed, dim too large'')')
         return
      endif
      write(lognum,10)  head
   10 format(/1x,a40)
      anz=8
      jo=0
   20 continue
      ju=jo+1
      jo=min(ju+anz-1,na)
      write(lognum,30)  (j,j=ju,jo)
   30 format(/1x,'row/column',8(6x,i3,6x))
      do i=1,ma
        if ( fix ) then
          write(lognum,40) i,(a(i,j),j=ju,jo)
   40     format(1x,3x,i4,3x,8(g14.7,1x))
        else
          write(lognum,50) i,(a(i,j),j=ju,jo)
   50     format(1x,3x,i4,3x,8(d14.7,1x))
        endif
      enddo
      if ( jo .lt. na ) goto 20
      return
      end
c*****************************************************************
      double precision function vecnor(n,x)
      implicit none
c*** euclidean norm of x , avoid overflow
      integer n,i
      double precision x(*)
      double precision xm,h
      if ( n .le. 0 ) then
        vecnor=0.d0
        return
      endif
      xm=dabs(x(1))
      do i=2,n
        xm=dmax1(xm,dabs(x(i)))
      enddo
      if ( xm .eq. 0.d0 ) then
        vecnor=0.d0
        return
      else
        h=0.d0
        do i=1,n
          h=h+(x(i)/xm)**2
        enddo
        vecnor=xm*dsqrt(h)
        return
      endif
      end    
c***************************************************************
c****************************************************************
c     computes gradient by high precision numerical differentiation
c*******************************************************************
c copyright = spellucci
      subroutine numgrd(xl,gradxl,err)
      include './domincom.inc'
      logical err
      double precision xl(*),gradxl(*),fxl(6)
      double precision sd1,sd2,sd3,xincr,zz,d1,d2,d3
      integer i
c****************************************************
c     high precision numerical differentiation
c     by sixth order extrapolation
c****************************************************
      err=.false.
      do   i=1,n
        zz=xl(i)
        xincr=deldif*(dabs(xl(i))+1.d0)
        xl(i)=zz-xincr
        call f(xl,fxl(1),err)
        if ( err ) return
        xl(i)=zz+xincr
        call f(xl,fxl(2),err)
        if ( err ) return
        xincr=xincr+xincr
        d1=xincr
        xl(i)=zz-xincr
        call f(xl,fxl(3),err)
        if ( err ) return
        xl(i)=zz+xincr
        call f(xl,fxl(4),err)
        if ( err ) return
        xincr=xincr+xincr
        d2=xincr
        xl(i)=zz-xincr
        call f(xl,fxl(5),err)
        if ( err ) return
        xl(i)=zz+xincr
        call f(xl,fxl(6),err)
        if ( err ) return
        xl(i)=zz
        d3=xincr+xincr
        sd1=(fxl(2)-fxl(1))/d1
        sd2=(fxl(4)-fxl(3))/d2
        sd3=(fxl(6)-fxl(5))/d3
        sd3=sd2-sd3
        sd2=sd1-sd2
        sd3=sd2-sd3
        gradxl(i)=sd1+.4d0*sd2+sd3/45.d0
      enddo
      icgf=icgf+1
      return
      end

