*       JEDC6.F, PROGRAM WHICH SOLVES THE KS MODEL WITH ENDOWMENT FACTOR
*       AND IN WHICH WE SIMULATE A TIME SERIES WITH A NON RANDOM CROSS SECTION
*       
*       The optimization procedure BFGS-MINIMIZER v030392 copyright p. spellucci
*       is used to find the parameter of the cross-sectional distribution
*
*        To implement the progam, if you work with gnu fortran 77, you should write
*        the following instruction: g77 jedc6.f domin.f
*
*	20/07/2006 12:58
 

      implicit real*8(a-h,o-z),integer(i-n)
      parameter (npar=729,npar2=108,nsimpson=301,nitime=1000,
     *           hfix=1.0D+00,remp=0.15D+00,
     *           durug=1.5D+00,unempg=0.04D+00,durgd=8.0D+00,
     *           durub=2.5D+00,unempb=0.10D+00,durbd=8.0D+00)


        real*4 secnds                             

	common/state/   stu(1000,10),stbar(10,2),st(1000,10)
	common/cheb/    cheb2(500,500)
	common/rpar/    blow,bhigh,bdiff
	common/par/     beta,gam,alpha,delta,caps
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
	common/prob/    prob(2,2,2,2),pagg(2,2),probf(2,2,2,2)
	common/coefind/ aold(8,npar),anew(8,npar)
	common/coefagg/ aggold(3,npar2),aggnew(3,npar2)	
	common/simpson/ hx(5000),hw(5000)
	common/ddddd/   ein1(7,2,5,5),ein2(7,2,5,5)	
	common/trunc/   tr1,tr2,tr3,tr4
	common/bound/   bu5,bl5,bu6,bl6

        double precision xsol,eta,ein1,ein2	              
        dimension root50(50),root(3000),xsol(6),eta(1)
     
	t = secnds(0.0)

	
	open(33,file='bigcoef.old',status='unknown')
	open(34,file='bigcoef.new',status='unknown')
	open(35,file='./bigpar.b33',status='unknown')
	open(36,file='cheb0.dat',   status='unknown')
        open(37,file='cheb50.dat',   status='unknown')
	open(41,file='bigagg.old', status='unknown')
	open(42,file='bigagg.new',status='unknown')
        open(85,file='stat_no.res',status='unknown')
        open(87,file='av_mmt_ub.res',   status='unknown')
        open(88,file='av_mmt_eb.res',   status='unknown')
        open(89,file='av_mmt_ug.res',   status='unknown')
        open(90,file='av_mmt_eg.res',   status='unknown')              

      one = 1.0D+00
      
      pgg00 = (durug-one)/durug
      pbb00 = (durub-one)/durub
      pbg00 = 1.25D+00*pbb00  
      pgb00 = 0.75D+00*pgg00
      pgg01 = (unempg - unempg*pgg00)/(one-unempg)
      pbb01 = (unempb - unempb*pbb00)/(one-unempb)
      pbg01 = (unempb - unempg*pbg00)/(one-unempg)
      pgb01 = (unempg - unempb*pgb00)/(one-unempb)
      pgg = (durgd-one)/durgd
      pagg(2,2) = pgg
      pgb = one - (durbd-one)/durbd
      pagg(2,1) = pgb
       
      pgg10 = one - (durug-one)/durug
      pbb10 = one - (durub-one)/durub
      pbg10 = one - 1.25D+00*pbb00  
      pgb10 = one - 0.75D+00*pgg00
      pgg11 = one - (unempg - unempg*pgg00)/(one-unempg)
      pbb11 = one - (unempb - unempb*pbb00)/(one-unempb)
      pbg11 = one - (unempb - unempg*pbg00)/(one-unempg)
      pgb11 = one - (unempg - unempb*pgb00)/(one-unempb)
      pbg = one - (durgd-one)/durgd
      pagg(1,2) = pbg      
      pbb = (durbd-one)/durbd
      pagg(1,1) = pbb      

      
      prob(2,2,2,2) = pgg*pgg11
      prob(2,2,1,2) = pbg*pbg11
      prob(2,2,2,1) = pgg*pgg01
      prob(2,2,1,1) = pbg*pbg01
      
      prob(1,2,2,2) = pgb*pgb11
      prob(1,2,1,2) = pbb*pbb11
      prob(1,2,2,1) = pgb*pgb01
      prob(1,2,1,1) = pbb*pbb01
      
      prob(2,1,2,2) = pgg*pgg10 
      prob(2,1,1,2) = pbg*pbg10
      prob(2,1,2,1) = pgg*pgg00
      prob(2,1,1,1) = pbg*pbg00

      prob(1,1,2,2) = pgb*pgb10 
      prob(1,1,1,2) = pbb*pbb10
      prob(1,1,2,1) = pgb*pgb00
      prob(1,1,1,1) = pbb*pbb00
        	
        read(35,*) i1max,i3max,i4max,i5max,i6max,
     $  i7max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,
     $  emlow,emhigh,beta,gam,alpha,delta,eps1,eps2,
     $  bl5,bu5,bl6,bu6,pclow,pchigh
     
     
        read(33,*) ((aold(i,j),j=1,npar),i=1,8)
        read(41,*) ((aggold(i,j),j=1,npar2),i=1,3)	

     
	imax   =   ipoint(i1max,i5max,i6max,i7max)
	if(imax.ne.npar) stop     
                       
	blow     = 0.00D+00
	bhigh    = 99.0D+00
	stu(1,2) = 0.00D+00
	stu(2,2) = 1.00D+00
	stu(1,3) = 0.99D+00        
	stu(2,3) = 1.01D+00
	stu(1,4) = 0.99D+00        
	stu(2,4) = 1.01D+00
	stu(1,8) = emlow
	stu(2,8) = emhigh
		
	stbar(1,1) = blow
	stbar(1,2) = bhigh	
	stbar(3,1) = stu(1,3)
	stbar(3,2) = stu(2,3)
	stbar(4,1) = stu(1,4)
	stbar(4,2) = stu(2,4)
	stbar(5,1) = bl5
	stbar(5,2) = bu5
	stbar(6,1) = bl6
	stbar(6,2) = bu6
	stbar(7,1) = pclow
	stbar(7,2) = pchigh

c
c  Flows matrix 
c

      probf(2,2,2,2) = pgg11*stu(2,8)
      probf(2,2,1,2) = pbg11*stu(2,8)
      probf(2,2,2,1) = pgg01*stu(2,8)     
      probf(2,2,1,1) = pbg01*stu(2,8)
      
      probf(1,2,2,2) = pgb11*stu(1,8)      
      probf(1,2,1,2) = pbb11*stu(1,8)
      probf(1,2,2,1) = pgb01*stu(1,8)
      probf(1,2,1,1) = pbb01*stu(1,8)
      
      probf(2,1,2,2) = pgg10*(one- stu(2,8))
      probf(2,1,1,2) = pbg10*(one- stu(2,8))
      probf(2,1,2,1) = pgg00*(one- stu(2,8))
      probf(2,1,1,1) = pbg00*(one- stu(2,8))

      probf(1,1,2,2) = pgb10*(one- stu(1,8)) 
      probf(1,1,1,2) = pbb10*(one- stu(1,8))
      probf(1,1,2,1) = pgb00*(one- stu(1,8))
      probf(1,1,1,1) = pbb00*(one- stu(1,8))	


c
c       nsimpson points
c
	
	hw(1) = 1./3.
	hw(nsimpson) = 1./3.
	hx(1) =  blow
	hx(nsimpson) = bhigh
	bdiff = hx(nsimpson)-hx(1)
	is = 1
	
	do 910 i = 2,nsimpson-1
	if(is.gt.0) then
	hw(i) = 4./3.
	is    = -1
	else
	hw(i) = 2./3.
	is    =  1
	endif
	hx(i) = hx(1) +  dble(i-1)*bdiff/dble(nsimpson-1)
910     continue


        read(36,*) (root(j),j=1,870)	
        read(37,*) (root50(j),j=1,50)
	
	do 10 is1 = 1,is1max
	st(is1,1) = root50(is1)
10      continue
	do 20 is1 = 1,is1max
	bb = st(is1,1)
	stu(is1,1) = scinv(bb,1)
20      continue
		 
	do 12 is3 = 1,is3max
	istart = (is3max-2)*30
	st(is3,3) = root(istart+is3)
12      continue
	 
	do 13 is4 = 1,is4max
	istart = (is4max-2)*30
	st(is4,4) = root(istart+is4)
13      continue

	do 14 is5 = 1,is5max
	istart = (is5max-2)*30
	st(is5,5) = root(istart+is5)
14      continue
	do 21 is5 = 1,is5max
	bb = st(is5,5)
	stu(is5,5) = scinv(bb,5)
21      continue

	do 15 is6 = 1,is6max
	istart = (is6max-2)*30
	st(is6,6) = root(istart+is6)
15      continue
	do 22 is6 = 1,is6max
	bb = st(is6,6)
	stu(is6,6) = scinv(bb,6)
22      continue
		
	do 16 is7 = 1,is7max
	istart = (is7max-2)*30
	st(is7,7) = root(istart+is7)
16      continue
	do 23 is7 = 1,is7max
	bb = st(is7,7)
	stu(is7,7) = scinv(bb,7)
23      continue


      jt=0
      do 43 is3 = 1,is3max
      do 43 is4 = 1,is4max
      do 43 is5 = 1,is5max
      do 43 is6 = 1,is6max
      do 43 is7 = 1,is7max
	jt  = ispoint2(is3,is4,is5,is6,is7)
	ss3 = st(is3,3)
	ss4 = st(is4,4)
	ss5 = st(is5,5)
	ss6 = st(is6,6)
	ss7 = st(is7,7)
	do 44 j3 = 1,i3max+1
	do 44 j4 = 1,i4max+1
	do 44 j5 = 1,i5max+1
	do 44 j6 = 1,i6max+1
	do 44 j7 = 1,i7max+1
	i3 = j3 - 1
	i4 = j4 - 1
	i5 = j5 - 1
	i6 = j6 - 1
	i7 = j7 - 1
	j   =  ipoint2(i3,i4,i5,i6,i7)
	cheb2(jt,j) = hh2(ss3,ss4,ss5,ss6,ss7,i3,i4,i5,i6,i7)
44      continue
43      continue

c	Initial moments of the strictly possitive capital holdings of agent
c       with respect to the aggregate shock
 
        varunempb   = 365.664364
        varempb     = 360.080959
        zm3unempb   = 5080.633669 
        zm3empb     = 5058.657796   
        zm4unempb   = 416453.608753
        zm4empb     = 404293.791229
        zm5unempb   = 13318161.930742 
        zm5empb     = 13678093.417108
        zm6unempb   = 767195580.873886 
        zm6empb     = 802570053.838035

        varunempg   = 367.834240
        varempg     = 364.518530 
        zm3unempg   = 5161.460288
        zm3empg     = 5156.529820 
        zm4unempg   = 420710.289824
        zm4empg     = 413408.661812
        zm5unempg   = 13702902.341034
        zm5empg     = 13892306.768946
        zm6unempg   = 791580566.672244 
        zm6empg     = 812427252.615880               

c	Initial parameter solution of the cross-sectional distribution
        
        open(9,file='solunemp.new',form='formatted')
         do 576 k4 = 1,is4max
         do 578 k5 = 1,is5max
         do 579 k6 = 1,is6max
         read(9,341)   ein1(1,k4,k5,k6),ein1(2,k4,k5,k6),
     *               ein1(3,k4,k5,k6),ein1(4,k4,k5,k6),
     *               ein1(5,k4,k5,k6),ein1(6,k4,k5,k6),
     *               ein1(7,k4,k5,k6)

341         format(7f20.15)       
579      continue
578      continue
576      continue
         close(9)

        open(10,file='solemp.new',form='formatted')
         do 580 k4 = 1,is4max
         do 582 k5 = 1,is5max
         do 583 k6 = 1,is6max
         read(10,341)  ein2(1,k4,k5,k6),ein2(2,k4,k5,k6),
     *               ein2(3,k4,k5,k6),ein2(4,k4,k5,k6),
     *               ein2(5,k4,k5,k6),ein2(6,k4,k5,k6),
     *               ein2(7,k4,k5,k6)

583      continue
582      continue
581      continue
580      continue
         close(10)

	
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c		Main program: Iterating on Aggregate Policy Rules
c		
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc     
        
	do 448 itera = 1,1000
  
        write(*,*) itera,448
	
	do 300 iter = 1,10000
				
       write(*,*) ''
       write(*,*) '----------------------'
       write(*,*) 'Individual problem'
       write(*,*) '----------------------'
       				
        do 7 itype    = 1,2
        do 8 iaggold  = 1,2
        do 9 iaggcur  = 1,2

        if((itype.eq.1).and.(iaggold.eq.1).and.(iaggcur.eq.1))
     $    ivec=1
            	              	
        if((itype.eq.1).and.(iaggold.eq.1).and.(iaggcur.eq.2)) 
     $    ivec=2
            	
        if((itype.eq.1).and.(iaggold.eq.2).and.(iaggcur.eq.1)) 
     $    ivec=3

        if((itype.eq.1).and.(iaggold.eq.2).and.(iaggcur.eq.2)) 
     $    ivec=4            	
                
        if((itype.eq.2).and.(iaggold.eq.1).and.(iaggcur.eq.1))
     $    ivec=5
            	              	
        if((itype.eq.2).and.(iaggold.eq.1).and.(iaggcur.eq.2)) 
     $    ivec=6
            	
        if((itype.eq.2).and.(iaggold.eq.2).and.(iaggcur.eq.1)) 
     $    ivec=7

        if((itype.eq.2).and.(iaggold.eq.2).and.(iaggcur.eq.2)) 
     $    ivec=8            	

        write(*,*) itype,iaggold,iaggcur,ivec

        call sbeta(itype,iaggold,iaggcur,ivec)  

9     continue
8     continue
7     continue


	accur = 0.
        do 309 i = 1,8
	do 310 j = 1,npar
	if(abs(aold(i,j)).gt.0.05) then
	accur = accur + abs( (aold(i,j)-anew(i,j))/aold(i,j)  )
	else
	accur = accur + abs( (aold(i,j)-anew(i,j)) )
	endif
	aold(i,j) = eps1*anew(i,j) + (1.-eps1)*aold(i,j)
310     continue
309     continue
	

        if(accur.lt.0.05) goto 305        


300     continue

305     continue


       write(*,*) ''
       write(*,*) '----------------------'
       write(*,*) 'Simulation'
       write(*,*) '----------------------'


      call       dosim(avunempb,varunempb,      
     *        zm3unempb,zm4unempb,zm5unempb,zm6unempb,pcunempb,
     *        avempb,varempb,zm3empb,zm4empb,zm5empb,zm6empb,      
     *        pcempb,avunempg,varunempg,zm3unempg,zm4unempg,
     *        zm5unempg,zm6unempg,pcunempg,avempg,varempg,
     *        zm3empg,zm4empg,zm5empg,zm6empg,pcempg)

                            
       write(85,*) ''
       write(85,*) '----------------------'
       write(85,*) 'New moment averages '
       write(85,*) '----------------------'
  
       write(85,*) 'avb', avempb,avunempb
       write(85,*) 'varb', varempb,varunempb
       write(85,*) 'z3b', zm3empb,zm3unempb 
       write(85,*) 'z4b', zm4empb,zm4unempb 
       write(85,*) 'z5b', zm5empb,zm5unempb 
       write(85,*) 'z6b', zm6empb,zm6unempb 
       write(85,*) 'pcb', pcempb,pcunempb

       write(85,*) 'avg', avempg,avunempg
       write(85,*) 'varg', varempg,varunempg
       write(85,*) 'z3g', zm3empg,zm3unempg 
       write(85,*) 'z4g', zm4empg,zm4unempg 
       write(85,*) 'z5g', zm5empg,zm5unempg 
       write(85,*) 'z6g', zm6empg,zm6unempg        
       write(85,*) 'pcg', pcempg,pcunempg
       write(85,*) ''        
              
       write(*,*) ''
       write(*,*) '----------------------'
       write(*,*) 'Nonlinear root finding'
       write(*,*) '----------------------'

        write(*,*) 'b', varunempb,zm3unempb,zm4unempb,
     *        zm5unempb,zm6unempb,pcunempb,
     *        varempb,zm3empb,zm4empb,zm5empb,zm6empb,
     *        pcempb

        write(*,*) 'g', varunempg,zm3unempg,zm4unempg,
     *        zm5unempg,zm6unempg,pcunempg,
     *        varempg,zm3empg,zm4empg,zm5empg,zm6empg,
     *        pcempg
     
	do 1000 k4 = 1,is4max
	do 1000 k5 = 1,is5max
	do 1000 k6 = 1,is6max
	       
c       WRITE(*,*) k4,k5,k6

       avemp   = stu(k5,5)
       avunemp = stu(k6,6)
       	
       if (k4.eq.1) then 
        varunemp  = varunempb
        varemp    = varempb  
        zm3unemp  = zm3unempb
        zm3emp    = zm3empb  
        zm4unemp  = zm4unempb
        zm4emp    = zm4empb  
        zm5unemp  = zm5unempb
        zm5emp    = zm5empb  
        zm6unemp  = zm6unempb
        zm6emp    = zm6empb  
       else     

        varunemp  = varunempg
        varemp    = varempg
        zm3unemp  = zm3unempg
        zm3emp    = zm3empg  
        zm4unemp  = zm4unempg
        zm4emp    = zm4empg  
        zm5unemp  = zm5unempg
        zm5emp    = zm5empg  
        zm6unemp  = zm6unempg
        zm6emp    = zm6empg          
       endif

        eta(1)    = ein1(1,k4,k5,k6)                              
	xsol(1)   = ein1(2,k4,k5,k6)
	xsol(2)   = ein1(3,k4,k5,k6)
	xsol(3)   = ein1(4,k4,k5,k6)
	xsol(4)   = ein1(5,k4,k5,k6)
	xsol(5)   = ein1(6,k4,k5,k6)
	xsol(6)   = ein1(7,k4,k5,k6)
	
        call k_dens(xsol,eta,avunemp,varunemp,
     *          zm3unemp,zm4unemp,zm5unemp,zm6unemp)

	ein1(1,k4,k5,k6) = eta(1)
	ein1(2,k4,k5,k6) = xsol(1)
	ein1(3,k4,k5,k6) = xsol(2)        
	ein1(4,k4,k5,k6) = xsol(3)        
	ein1(5,k4,k5,k6) = xsol(4)        
	ein1(6,k4,k5,k6) = xsol(5)
	ein1(7,k4,k5,k6) = xsol(6)
	
        eta(1)    = ein2(1,k4,k5,k6)                               
	xsol(1)   = ein2(2,k4,k5,k6)
	xsol(2)   = ein2(3,k4,k5,k6)
	xsol(3)   = ein2(4,k4,k5,k6)
	xsol(4)   = ein2(5,k4,k5,k6)
	xsol(5)   = ein2(6,k4,k5,k6)
	xsol(6)   = ein2(7,k4,k5,k6)	
     
        call k_dens(xsol,eta,avemp,varemp,
     *          zm3emp,zm4emp,zm5emp,zm6emp)
          
	ein2(1,k4,k5,k6) = eta(1)
	ein2(2,k4,k5,k6) = xsol(1)
	ein2(3,k4,k5,k6) = xsol(2)        
	ein2(4,k4,k5,k6) = xsol(3)        
	ein2(5,k4,k5,k6) = xsol(4)        
	ein2(6,k4,k5,k6) = xsol(5)        
	ein2(7,k4,k5,k6) = xsol(6)
1000    continue


        open(9,file='solunemp00.new',form='formatted')
         do 591 k4 = 1,is4max
         do 592 k5 = 1,is5max
         do 593 k6 = 1,is6max
               write(9,341)  ein1(1,k4,k5,k6),ein1(2,k4,k5,k6),
     *                     ein1(3,k4,k5,k6),ein1(4,k4,k5,k6),
     *                     ein1(5,k4,k5,k6),ein1(6,k4,k5,k6),
     *                     ein1(7,k4,k5,k6)

593      continue
592      continue
591      continue
         close(9)

        open(10,file='solemp00.new',form='formatted')
         do 595 k4 = 1,is4max
         do 597 k5 = 1,is5max
         do 598 k6 = 1,is6max
         write(10,341)  ein2(1,k4,k5,k6),ein2(2,k4,k5,k6),
     *                ein2(3,k4,k5,k6),ein2(4,k4,k5,k6),
     *                ein2(5,k4,k5,k6),ein2(6,k4,k5,k6),
     *                ein2(7,k4,k5,k6)
     
598      continue
597      continue
596      continue
595      continue
         close(10)
         

*
*       UPDATE THE AGGREGATE LAW OF MOTION
*


        call update_law(varunempb,zm3unempb,zm4unempb,
     *        zm5unempb,zm6unempb,varempb,zm3empb,zm4empb,
     *        zm5empb,zm6empb,varunempg,zm3unempg,zm4unempg,
     *        zm5unempg,zm6unempg,varempg,zm3empg,zm4empg,
     *        zm5empg,zm6empg)

	accur = 0.
	do 3310 i = 1,2
	do 3310 j = 1,npar2
	if(abs(aggold(i,j)).gt.0.01) then
	accur = accur + abs( (aggold(i,j)-aggnew(i,j))/aggold(i,j)  )
	else
	accur = accur + abs( (aggold(i,j)-aggnew(i,j)) )
	endif
	aggold(i,j) = eps2*aggnew(i,j) + (1.-eps2)*aggold(i,j)
3310    continue


        write(*,*) 'macro', accur

	if(accur.lt.0.0001) goto 3305


448     continue

3305    continue

	
	t = secnds(0.0) -t
        write(34,265) ((aold(i,j),j=1,npar),i=1,8)
        write(42,266) ((aggold(i,j),j=1,npar2),i=1,3)
265   format(9f15.8)
266   format(6f15.8)
	write(*,*) 'it took ',t,' seconds'

        open(9,file='solunempres.new',form='formatted')
         do 683 k4 = 1,is4max
         do 684 k5 = 1,is5max
         do 685 k6 = 1,is6max
               write(9,341)  ein1(1,k4,k5,k6),ein1(2,k4,k5,k6),
     *                     ein1(3,k4,k5,k6),ein1(4,k4,k5,k6),
     *                     ein1(5,k4,k5,k6),ein1(6,k4,k5,k6),
     *                     ein1(7,k4,k5,k6)
685      continue
684      continue
683      continue
         close(9)

        open(10,file='solempres.new',form='formatted')
         do 687 k4 = 1,is4max
         do 688 k5 = 1,is5max
         do 689 k6 = 1,is6max
         write(10,341)  ein2(1,k4,k5,k6),ein2(2,k4,k5,k6),
     *                ein2(3,k4,k5,k6),ein2(4,k4,k5,k6),
     *                ein2(5,k4,k5,k6),ein2(6,k4,k5,k6),
     *                     ein2(7,k4,k5,k6)
689      continue
688      continue
687      continue
         close(10)


        stop
        end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c		Subroutines and functions
c		
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	 subroutine sbeta(itype,iaggold,iaggcur,ivec)
	 implicit real*8(a-h,o-z),integer(i-n)	
	 parameter(npar=729,npar2=108,hfix=1.00D+00,remp=0.15D+00)

	 common/state/   stu(1000,10),stbar(10,2),st(1000,10)
	 common/rpar/    blow,bhigh,bdiff
	 common/par/     beta,gam,alpha,delta,caps
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
	 common/prob/    prob(2,2,2,2),pagg(2,2),probf(2,2,2,2)
	common/coefind/ aold(8,npar),anew(8,npar)
	common/coefagg/ aggold(3,npar2),aggnew(3,npar2)	

      DOUBLE PRECISION   ONE         , ZERO
      DOUBLE PRECISION   TEMP      
      PARAMETER        ( ONE = 1.0D+0, ZERO = 0.0D+0 )
      DOUBLE PRECISION   XX(NPAR,NPAR)	 
     
      dimension chebreg(6250,npar),y(6250),xy(npar),work(npar)
     	 	
	jtreg = 0        

        do 11 k = 1,6250
	  y(k) = zero
        do 12 j = 1,npar
	  chebreg(k,j) = zero
12     continue
11     continue


       
	do 10 is1 = 1,is1max
	do 10 is5 = 1,is5max
	do 10 is6 = 1,is6max
	do 10 is7 = 1,is7max
        	
	s1old = st(is1,1)
	s5old = st(is5,5)
	s6old = st(is6,6)
	s7old = st(is7,7)
	
 	esca   =  1./stu(1,8)
	empl   =  stu(iaggcur,8)
	
	pc     = stu(is7,7)
	pcu    = (probf(iaggold,1,iaggcur,1)*pc)/(one-empl)
	pce    = (probf(iaggold,1,iaggcur,2)*pc)/empl
	
      caps=  empl*(one-pce)*stu(is5,5) + (one-empl)*(one-pcu)*stu(is6,6)		
	rental =  alpha*stu(iaggcur,4)*((caps/(esca*empl))**(alpha-1.))
	sal    =  (1.-alpha)*stu(iaggcur,4)* ((caps/(esca*empl))**alpha)
     		
	exp1   = pol(s1old,s5old,s6old,s7old,ivec)	
	cons1  = (exp1)**(1./gam)	
	wealth = stu(is1,1)*(1.+rental-delta) + 
     $  esca*(stu(itype,2)-((stu(itype,2)/empl)-1.)*remp)*sal	
	bond1  = wealth - cons1     

        
       if(bond1.lt.blow) then
	bond1 =  blow
	cons1 =  wealth-bond1
       endif
       if(bond1.gt.bhigh) then
	bond1 =  bhigh
	cons1 =  wealth-bond1
       endif

       s3old = st(iaggold,3)
       s4old = st(iaggcur,4)

       pcnew  = aggfunc(s3old,s4old,s5old,s6old,s7old,1)

       avenew = aggfunc(s3old,s4old,s5old,s6old,s7old,2)
         
       avunew = aggfunc(s3old,s4old,s5old,s6old,s7old,3)



*
*       Modified PEA: Calculate conditional expectation if bond1>0
*


      if (bond1.gt.0.00D+00) then

	expec1 = 0.

        do 35 lnew = 1,2

	empl   =  stu(lnew,8)        
        
        pcu1   = (probf(iaggcur,1,lnew,1)*pcnew)/(one-empl)
        pce1   = (probf(iaggcur,1,lnew,2)*pcnew)/empl

        fuu    = probf(iaggcur,1,lnew,1)*(one-pcnew)
        fue    = probf(iaggcur,1,lnew,2)*(one-pcnew)
        feu    = probf(iaggcur,2,lnew,1)
        fee    = probf(iaggcur,2,lnew,2)
        emplnc = fee + fue
        umplnc = fuu + feu
	
        ave1 = (fee*avenew + fue*avunew)/emplnc
        avu1 = (feu*avenew + fuu*avunew)/umplnc

        
        s5 = sca(ave1,5)
        s6 = sca(avu1,6)
        s7 = sca(pcnew,7)
        
        caps   =  empl*(one-pce1)*ave1 + (one-empl)*(one-pcu1)*avu1		
	rental =  alpha*stu(lnew,4)*((caps/(esca*empl))**(alpha-1.))        
        salnew =  (1.-alpha)*stu(lnew,4)*((caps/(esca*empl))**alpha)
		 
        do 35 jnew = 1,2

	s1    =  sca(bond1,1)

        if((jnew.eq.1).and.(iaggcur.eq.1).and.(lnew.eq.1))
     $    ivec1=1            	              	
        if((jnew.eq.1).and.(iaggcur.eq.1).and.(lnew.eq.2)) 
     $    ivec1=2            	
        if((jnew.eq.1).and.(iaggcur.eq.2).and.(lnew.eq.1)) 
     $    ivec1=3
        if((jnew.eq.1).and.(iaggcur.eq.2).and.(lnew.eq.2)) 
     $    ivec1=4            	                
        if((jnew.eq.2).and.(iaggcur.eq.1).and.(lnew.eq.1))
     $    ivec1=5            	              	
        if((jnew.eq.2).and.(iaggcur.eq.1).and.(lnew.eq.2)) 
     $    ivec1=6            	
        if((jnew.eq.2).and.(iaggcur.eq.2).and.(lnew.eq.1)) 
     $    ivec1=7
        if((jnew.eq.2).and.(iaggcur.eq.2).and.(lnew.eq.2)) 
     $    ivec1=8            	

        exp2  =  pol(s1,s5,s6,s7,ivec1)
        cons2 =  (exp2)**(1./gam)
        wealth1 = bond1*(1+rental-delta) + 
     $ esca*(stu(jnew,2)-((stu(jnew,2)/empl)-1)*remp)*salnew
        bond2 =  wealth1 - cons2 

        
        if(bond2.lt.blow) then
	bond2 =  blow
	cons2 =  wealth1 - bond2
        endif
        if(bond2.gt.bhigh) then
	bond2 =  bhigh
	cons2 =  wealth1 - bond2
        endif       

	Umc=cons2**gam
   
	expec1 = expec1 +
     $    prob(iaggcur,itype,lnew,jnew)*beta*(rental+1.-delta)*Umc


35      continue
	       
	jtreg = jtreg + 1	       
	y(jtreg) = log(expec1)


C        Individual Regressions


	do 41 j1 = 1,i1max+1
	do 41 j5 = 1,i5max+1
	do 41 j6 = 1,i6max+1
	do 41 j7 = 1,i7max+1
	i1 = j1 - 1
	i5 = j5 - 1
	i6 = j6 - 1
	i7 = j7 - 1
	j   =  ipoint(i1,i5,i6,i7)
	chebreg(jtreg,j) = hh(s1old,s5old,s6old,s7old,
     $    i1,i5,i6,i7)
41      continue

        endif

10      continue

	JMAX = JTREG
        write(*,*) 'jtreg', jtreg,itype,iaggold,iaggcur,ivec

	DO 110 J = 1,NPAR
	XY(J) = ZERO
	DO 111 K = 1,NPAR
	XX(J,K) = ZERO
111     CONTINUE
110     CONTINUE

            DO 120, J = 1, npar
               DO 121, I = 1, npar
                  TEMP = ZERO
                  DO 100, L = 1, jmax
                     TEMP = TEMP + chebreg( L, I )*chebreg( L, J )
  100             CONTINUE
                     XX( I, J ) = TEMP
  121          CONTINUE
  120       CONTINUE

	DO 140 J = 1,NPAR
	DO 140 I = 1,JMAX
	XY(J) = XY(J) + CHEBREG(I,J)*Y(I)
140     CONTINUE
       
        CALL DGEFA(XX,NPAR,NPAR,IPVTRES,INFORES)
        CALL DGEDI(XX,NPAR,NPAR,IPVTRES,DET,WORK,01)	

        
	DO 145 J = 1,NPAR
	ANEW(IVEC,J) = 0.
	DO 145 K = 1,NPAR
	ANEW(IVEC,J) = ANEW(IVEC,J)+XX(J,K)*XY(K)
145     CONTINUE

150     CONTINUE

       end      


      subroutine dosim(avunempbhat,varunempbhat,      
     *        zm3unempbhat,zm4unempbhat,zm5unempbhat,
     *        zm6unempbhat,pcunempbhat,avempbhat,varempbhat,      
     *        zm3empbhat,zm4empbhat,zm5empbhat,zm6empbhat,
     *        pcempbhat,avunempghat,varunempghat,
     *        zm3unempghat,zm4unempghat,zm5unempghat,
     *        zm6unempghat,pcunempghat,avempghat,varempghat,
     *        zm3empghat,zm4empghat,zm5empghat,
     *        zm6empghat,pcempghat)
     
        implicit real*8(a-h,o-z),integer(i-n)
        parameter(npar=729,npar2=108,nsimpson=301,nitime=1000,
     *           durgd=8.0D+00,durbd=8.0D+00)
     
	common/state/   stu(1000,10),stbar(10,2),st(1000,10)
	common/rpar/    blow,bhigh,bdiff
	common/par/     beta,gam,alpha,delta,caps
	common/prob/    prob(2,2,2,2),pagg(2,2),probf(2,2,2,2)
	common/coefind/ aold(8,npar),anew(8,npar)
	common/coefagg/ aggold(3,npar2),aggnew(3,npar2)	
	common/simpson/ hx(5000),hw(5000)
	common/ddddd/   ein1(7,2,5,5),ein2(7,2,5,5)	
	common/mmtsim/  zmmt_ub(nitime,7),zmmt_ug(nitime,7),
     $  zmmt_eb(nitime,7),zmmt_eg(nitime,7)

        double precision xsol1,xsol2,eta1,eta2,ein1,ein2

        dimension sim1(1000),sim2(1000),
     $  zidcst1(1000),zidncst1(1000),
     $  xsol1(6),xsol2(6),eta1(1),eta2(1)

        open(83,file='mmtesolve_qua.new',status='unknown')
        open(84,file='mmtusolve_qua.new',status='unknown')
                       
        one = 1.0D+00
    
        pgg = (durgd-one)/durgd
        pgb = one - (durbd-one)/durbd
      	        
        iaggold = 1
        iaggcur = 1  
        pc      = 0.00D+00     
        pcu     = 0.00D+00        
        pce     = 0.00D+00                   

        nbad  = 0
        ngood = 0       
                              
	eta1(1)    = ein1(1,1,3,3)
	xsol1(1)   = ein1(2,1,3,3)
	xsol1(2)   = ein1(3,1,3,3)
	xsol1(3)   = ein1(4,1,3,3)
	xsol1(4)   = ein1(5,1,3,3)
	xsol1(5)   = ein1(6,1,3,3)
	xsol1(6)   = ein1(7,1,3,3)
	
	eta2(1)    = ein2(1,1,3,3)
	xsol2(1)   = ein2(2,1,3,3)
	xsol2(2)   = ein2(3,1,3,3)
	xsol2(3)   = ein2(4,1,3,3)
	xsol2(4)   = ein2(5,1,3,3)	
	xsol2(5)   = ein2(6,1,3,3)	
	xsol2(6)   = ein2(7,1,3,3)	

        avunemp  = stu(3,6)
        varunemp = varunempbhat
        zm3unemp = zm3unempbhat
        zm4unemp = zm4unempbhat
        zm5unemp = zm5unempbhat
        zm6unemp = zm6unempbhat
        
        avemp    = stu(3,5)
        varemp   = varempbhat
        zm3emp   = zm3empbhat
        zm4emp   = zm4empbhat 
        zm5emp   = zm5empbhat 
        zm6emp   = zm6empbhat 
     	        
        call sgrnd(4357)  
             
        do 448 itime = 1,nitime
                
	e10 = eta1(1)
	e11 = xsol1(1)
	e12 = xsol1(2)
	e13 = xsol1(3)
	e14 = xsol1(4)
	e15 = xsol1(5)
	e16 = xsol1(6)
	
	e20 = eta2(1)
	e21 = xsol2(1)
	e22 = xsol2(2)
	e23 = xsol2(3)
	e24 = xsol2(4)
	e25 = xsol2(5)
	e26 = xsol2(6)	
                		           	
      
	hh = bdiff/dble(nsimpson-1)
	
	do 831 i = 1,nsimpson
	hin = hx(i)
	if(hx(i).lt.blow)  hin = blow

	indiv   = 1
	bunemp  = bfunc(hin,indiv,iaggold,iaggcur,avemp,avunemp,pc)
	sim1(i) = bunemp

        if (bunemp .le. blow) then
           zidcst1(i) = 1.
           zidncst1(i)= 0.
        else
           zidcst1(i) = 0.
           zidncst1(i)= 1.
        endif                  	

	indiv   = 2
	bemp    = bfunc(hin,indiv,iaggold,iaggcur,avemp,avunemp,pc)
	sim2(i) = bemp
        
831     continue
	
       zeta = 0.0D+00
       ave  = 0.0D+00
       avu  = 0.0D+00
       vae  = 0.0D+00
       vau  = 0.0D+00
       ske  = 0.0D+00
       sku  = 0.0D+00
       zkue = 0.0D+00
       zkuu = 0.0D+00
       zm5e = 0.0D+00
       zm5u = 0.0D+00
       zm6e = 0.0D+00
       zm6u = 0.0D+00       
                    
        do 832 i = 1,nsimpson	

        zeta = zeta +
     $  hh*zidcst1(i)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,
     $  zm4unemp,zm5unemp,zm6unemp,hx(i))*hw(i)

	ave= ave + 
     $  hh*sim2(i)*e20*dens(e21,e22,e23,e24,e25,e26,
     $  avemp,varemp,zm3emp,zm4emp,
     $  zm5emp,zm6emp,hx(i))*hw(i)
     
     	avu= avu + 
     $  hh*sim1(i)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,zm4unemp,
     $  zm5unemp,zm6unemp,hx(i))*hw(i)
                  
	vae= vae + 
     $  hh*(sim2(i)**2)*e20*dens(e21,e22,e23,e24,e25,e26,
     $  avemp,varemp,zm3emp,zm4emp,
     $  zm5emp,zm6emp,hx(i))*hw(i)
               
     	vau= vau + 
     $  hh*(sim1(i)**2)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,zm4unemp,
     $  zm5unemp,zm6unemp,hx(i))*hw(i)

	ske= ske + 
     $  hh*(sim2(i)**3.)*e20*dens(e21,e22,e23,e24,e25,e26,
     $  avemp,varemp,zm3emp,zm4emp,
     $  zm5emp,zm6emp,hx(i))*hw(i)
               
     	sku= sku + 
     $  hh*(sim1(i)**3.)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,zm4unemp,
     $  zm5unemp,zm6unemp,hx(i))*hw(i)    

	zkue= zkue + 
     $  hh*(sim2(i)**4.)*e20*dens(e21,e22,e23,e24,e25,e26,
     $  avemp,varemp,zm3emp,zm4emp,
     $  zm5emp,zm6emp,hx(i))*hw(i)
               
     	zkuu= zkuu + 
     $  hh*(sim1(i)**4.)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,zm4unemp,
     $  zm5unemp,zm6unemp,hx(i))*hw(i)     

        zm5e = zm5e +             
     $  hh*(sim2(i)**5.)*e20*dens(e21,e22,e23,e24,e25,e26,
     $  avemp,varemp,zm3emp,zm4emp,
     $  zm5emp,zm6emp,hx(i))*hw(i)
               
     	zm5u= zm5u + 
     $  hh*(sim1(i)**5.)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,zm4unemp,
     $  zm5unemp,zm6unemp,hx(i))*hw(i)     

        zm6e = zm6e +             
     $  hh*(sim2(i)**6.)*e20*dens(e21,e22,e23,e24,e25,e26,
     $  avemp,varemp,zm3emp,zm4emp,
     $  zm5emp,zm6emp,hx(i))*hw(i)
               
     	zm6u= zm6u + 
     $  hh*(sim1(i)**6.)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,zm4unemp,
     $  zm5unemp,zm6unemp,hx(i))*hw(i)     
             
832     continue           
      
      pc1 =(one-pcu)*zeta + pcu

      avu = avu/(one-zeta)
      ave =(one-pce)*ave + 
     $  pce*bfunc(blow,2,iaggold,iaggcur,avemp,avunemp,pc)     
        
      vau = vau/(one-zeta)
      vae =(one-pce)*vae +
     $  pce*(bfunc(blow,2,iaggold,iaggcur,avemp,avunemp,pc)**2)    

      sku = sku/(one-zeta)
      ske =(one-pce)*ske + 
     $  pce*(bfunc(blow,2,iaggold,iaggcur,avemp,avunemp,pc)**3)

      zkuu= zkuu/(one-zeta)               
      zkue=(one-pce)*zkue + 
     $  pce*(bfunc(blow,2,iaggold,iaggcur,avemp,avunemp,pc)**4)

      zm5u= zm5u/(one-zeta)
      zm5e=(one-pce)*zm5e + 
     $  pce*(bfunc(blow,2,iaggold,iaggcur,avemp,avunemp,pc)**5)

      zm6u= zm6u/(one-zeta)
      zm6e=(one-pce)*zm6e + 
     $  pce*(bfunc(blow,2,iaggold,iaggcur,avemp,avunemp,pc)**6)
     

	r3 = grnd()
        if(iaggcur.eq.2) then
	        if(r3.lt.pgg) then
		iaggnew = 2
               else
		iaggnew = 1
	        endif
        else                        
	        if(r3.lt.pgb) then
		iaggnew = 2
	        else
		iaggnew = 1
	        endif
        endif
        

      pce1=(probf(iaggcur,1,iaggnew,2)*pc1)/stu(iaggnew,8)
      pcu1=(probf(iaggcur,1,iaggnew,1)*pc1)/(one-stu(iaggnew,8))

      fuu    = probf(iaggcur,1,iaggnew,1)*(1.-pc1)
      fue    = probf(iaggcur,1,iaggnew,2)*(1.-pc1)
      feu    = probf(iaggcur,2,iaggnew,1)
      fee    = probf(iaggcur,2,iaggnew,2)
      emplnc = fee + fue
      umplnc = fuu + feu
                              
      avempl1 = (fee*ave + fue*avu)/emplnc
      avumpl1 = (feu*ave + fuu*avu)/umplnc
        
      vaempl1 = (fee*vae + fue*vau)/emplnc        
      vaumpl1 = (feu*vae + fuu*vau)/umplnc
      vacempl1= vaempl1 - avempl1**2.
      vacumpl1= vaumpl1 - avumpl1**2.
	
      skempl1 = (fee*ske + fue*sku)/emplnc
      skumpl1 = (feu*ske + fuu*sku)/umplnc
      skcempl1= skempl1 - 3.*vaempl1*avempl1 + 2.*(avempl1**3.)
      skcumpl1= skumpl1 - 3.*vaumpl1*avumpl1 + 2.*(avumpl1**3.)

      zkuempl1= (fee*zkue + fue*zkuu)/emplnc
      zkuumpl1= (feu*zkue + fuu*zkuu)/umplnc	
      zkucempl1=zkuempl1 - 4.*skempl1*avempl1 + 
     $  6.*vaempl1*(avempl1**2.) - 3.*(avempl1**4.)
      zkucumpl1=zkuumpl1 - 4.*skumpl1*avumpl1 + 
     $  6.*vaumpl1*(avumpl1**2.) - 3*(avumpl1**4.)

      zm5empl1= (fee*zm5e + fue*zm5u)/emplnc
      zm5umpl1= (feu*zm5e + fuu*zm5u)/umplnc
      zm5cempl1= zm5empl1 - 5.*zkuempl1*avempl1 + 
     $  10.*skempl1*(avempl1**2.) - 10.*vaempl1*(avempl1**3.) +
     $  4.*(avempl1**5.)
      zm5cumpl1= zm5umpl1 - 5.*zkuumpl1*avumpl1 + 
     $  10.*skumpl1*(avumpl1**2.) - 10.*vaumpl1*(avumpl1**3.) + 
     $  4.*(avumpl1**5.)      

      zm6empl1= (fee*zm6e + fue*zm6u)/emplnc
      zm6umpl1= (feu*zm6e + fuu*zm6u)/umplnc
      zm6cempl1= zm6empl1 - 6.*zm5empl1*avempl1 + 
     $  15.*zkuempl1*(avempl1**2.) - 20.*skempl1*(avempl1**3.) + 
     $  15.*vaempl1*(avempl1**4.) - 5.*(avempl1**6.)         
      zm6cumpl1= zm6umpl1 - 6.*zm5umpl1*avumpl1 + 
     $  15.*zkuumpl1*(avumpl1**2.) - 20.*skumpl1*(avumpl1**3.) + 
     $  15.*vaumpl1*(avumpl1**4.) - 5.*(avumpl1**6.)      



        write(83,350) itime+1,iaggold,iaggcur,iaggnew,
     $  avempl1,vacempl1,skcempl1,zkucempl1,zm5cempl1,
     $  zm6cempl1,pc1,pcu1,pce1
350         format(4i5,9f25.6)    

        write(84,350) itime+1,iaggold,iaggcur,iaggnew,
     $  avumpl1,vacumpl1,skcumpl1,zkucumpl1,zm5cumpl1,
     $  zm6cumpl1,pc1,pcu1,pce1
    
        write(*,350) itime+1,iaggold,iaggcur,iaggnew,
     $  avumpl1,vacumpl1,skcumpl1,zkucumpl1,zm5cumpl1,
     $  zm6cumpl1,pc1,pcu1,pce1
     
        write(*,350) itime+1,iaggold,iaggcur,iaggnew,
     $  avempl1,vacempl1,skcempl1,zkucempl1,zm5cempl1,
     $  zm6cempl1,pc1,pcu1,pce1


        if (iaggnew.eq.1) then

            nbad = nbad +1
            zmmt_eb(nbad,1) = avempl1
            zmmt_eb(nbad,2) = vacempl1
            zmmt_eb(nbad,3) = skcempl1
            zmmt_eb(nbad,4) = zkucempl1   
            zmmt_eb(nbad,5) = zm5cumpl1   
            zmmt_eb(nbad,6) = zm6cumpl1   
            zmmt_eb(nbad,7) = pce1   
                                             
            zmmt_ub(nbad,1) = avumpl1
            zmmt_ub(nbad,2) = vacumpl1
            zmmt_ub(nbad,3) = skcumpl1
            zmmt_ub(nbad,4) = zkucumpl1
            zmmt_ub(nbad,5) = zm5cempl1
            zmmt_ub(nbad,6) = zm6cempl1
            zmmt_ub(nbad,7) = pcu1
            
        else

            ngood = ngood + 1
            write(*,*) 'ngood',ngood
            zmmt_eg(ngood,1) = avempl1
            zmmt_eg(ngood,2) = vacempl1
            zmmt_eg(ngood,3) = skcempl1
            zmmt_eg(ngood,4) = zkucempl1   
            zmmt_eg(ngood,5) = zm5cumpl1   
            zmmt_eg(ngood,6) = zm6cumpl1   
            zmmt_eg(ngood,7) = pce1   
                                             
            zmmt_ug(ngood,1) = avumpl1
            zmmt_ug(ngood,2) = vacumpl1
            zmmt_ug(ngood,3) = skcumpl1
            zmmt_ug(ngood,4) = zkucumpl1
            zmmt_ug(ngood,5) = zm5cempl1
            zmmt_ug(ngood,6) = zm6cempl1
            zmmt_ug(ngood,7) = pcu1

        endif        	          
    
                
        avemp    = avempl1
        avunemp  = avumpl1
        varemp   = vacempl1
        varunemp = vacumpl1
        zm3emp   = skcempl1
        zm3unemp = skcumpl1
        zm4emp   = zkucempl1
        zm4unemp = zkucumpl1
        zm5emp   = zm5cempl1
        zm5unemp = zm5cumpl1 
        zm6emp   = zm6cempl1
        zm6unemp = zm6cumpl1        

        pc       = pc1
        pcu      = pcu1
        pce      = pce1
        
        iaggold  = iaggcur
	iaggcur  = iaggnew
	
        call k_dens(xsol1,eta1,avunemp,varunemp,zm3unemp,
     *          zm4unemp,zm5unemp,zm6unemp)

        call k_dens(xsol2,eta2,avemp,varemp,zm3emp,
     *          zm4emp,zm5emp,zm6emp)

448     continue              

        write(*,*) nbad,ngood
               
        avempbhat    = avmmt_eb(nbad,1)
        avunempbhat  = avmmt_ub(nbad,1)
        varempbhat   = avmmt_eb(nbad,2)
        varunempbhat = avmmt_ub(nbad,2)
        zm3empbhat   = avmmt_eb(nbad,3)
        zm3unempbhat = avmmt_ub(nbad,3)
        zm4empbhat   = avmmt_eb(nbad,4)
        zm4unempbhat = avmmt_ub(nbad,4)
        zm5empbhat   = avmmt_eb(nbad,5)
        zm5unempbhat = avmmt_ub(nbad,5)
        zm6empbhat   = avmmt_eb(nbad,6)
        zm6unempbhat = avmmt_ub(nbad,6)
        pcempbhat    = avmmt_eb(nbad,7)
        pcunempbhat  = avmmt_ub(nbad,7)

        avempghat    = avmmt_eg(ngood,1)
        avunempghat  = avmmt_ug(ngood,1)
        varempghat   = avmmt_eg(ngood,2)
        varunempghat = avmmt_ug(ngood,2)
        zm3empghat   = avmmt_eg(ngood,3)
        zm3unempghat = avmmt_ug(ngood,3)
        zm4empghat   = avmmt_eg(ngood,4)
        zm4unempghat = avmmt_ug(ngood,4)
        zm5empghat   = avmmt_eg(ngood,5)
        zm5unempghat = avmmt_ug(ngood,5)
        zm6empghat   = avmmt_eg(ngood,6)
        zm6unempghat = avmmt_ug(ngood,6)
        pcempghat    = avmmt_eg(ngood,7)
        pcunempghat  = avmmt_ug(ngood,7)

        write(*,*) ''
        write(*,*) '----------------------'
        write(*,*) 'New moment average '
        write(*,*) '----------------------'       
        write(*,444) avunempbhat,varunempbhat,zm3unempbhat,zm4unempbhat,
     $   zm5unempbhat,zm6unempbhat,pcunempbhat
        write(*,444) avempbhat,varempbhat,zm3empbhat,zm4empbhat,
     $   zm5empbhat,zm6empbhat,pcempbhat
        write(*,444) avunempghat,varunempghat,zm3unempghat,zm4unempghat,
     $   zm5unempghat,zm6unempghat,pcunempghat
        write(*,444) avempghat,varempghat,zm3empghat,zm4empghat,
     $   zm5empghat,zm6empghat,pcempghat
                
        write(87,444) avunempbhat,varunempbhat,zm3unempbhat,
     $   zm4unempbhat,zm5unempbhat,zm6unempbhat,pcunempbhat
        write(88,444) avempbhat,varempbhat,zm3empbhat,zm4empbhat,
     $   zm5empbhat,zm6empbhat,pcempbhat
        write(89,444) avunempghat,varunempghat,zm3unempghat,
     $   zm4unempghat,zm5unempghat,zm6unempghat,pcunempghat
        write(90,444) avempghat,varempghat,zm3empghat,zm4empghat,
     $   zm5empghat,zm6empghat,pcempghat
444         format(7f25.6)    
 

       end


       subroutine update_law(varunempb,zm3unempb,zm4unempb,
     *        zm5unempb,zm6unempb,varempb,zm3empb,zm4empb,
     *        zm5empb,zm6empb,varunempg,zm3unempg,zm4unempg,
     *        zm5unempg,zm6unempg,varempg,zm3empg,zm4empg,
     *        zm5empg,zm6empg)
     
	implicit real*8(a-h,o-z),integer(i-n)
	parameter(npar=729,npar2=108,nsimpson=301)

	common/state/   stu(1000,10),stbar(10,2),st(1000,10)
	 common/cheb/    cheb2(500,500)
	common/rpar/    blow,bhigh,bdiff
	common/par/     beta,gam,alpha,delta,caps
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
	common/prob/    prob(2,2,2,2),pagg(2,2),probf(2,2,2,2)
	common/coefind/ aold(8,npar),anew(8,npar)
	common/coefagg/ aggold(3,npar2),aggnew(3,npar2)	
	common/simpson/ hx(5000),hw(5000)
	common/ddddd/   ein1(7,2,5,5),ein2(7,2,5,5)	
	common/trunc/   tr1,tr2,tr3,tr4
	common/bound/   bu5,bl5,bu6,bl6

        dimension xx(npar2,npar2),xy(npar2),yreg(500,3)
        dimension sim1(nsimpson),sim2(nsimpson),
     $  zidcst1(nsimpson),zidncst1(nsimpson)                

	do 1000 k3 = 1,is3max
	do 1000 k4 = 1,is4max
	do 1000 k5 = 1,is5max
	do 1000 k6 = 1,is6max
	do 1000 k7 = 1,is7max
	
        avemp   = stu(k5,5)
        avunemp = stu(k6,6)
        pc      = stu(k7,7)
        
       if (k4.eq.1) then 
        varunemp  = varunempb
        varemp    = varempb  
        zm3unemp  = zm3unempb
        zm3emp    = zm3empb  
        zm4unemp  = zm4unempb
        zm4emp    = zm4empb  
        zm5unemp  = zm5unempb
        zm5emp    = zm5empb  
        zm6unemp  = zm6unempb
        zm6emp    = zm6empb          
       else     
        varunemp  = varunempg
        varemp    = varempg
        zm3unemp  = zm3unempg
        zm3emp    = zm3empg  
        zm4unemp  = zm4unempg
        zm4emp    = zm4empg  
        zm5unemp  = zm5unempg
        zm5emp    = zm5empg  
        zm6unemp  = zm6unempg
        zm6emp    = zm6empg  
       endif
        
	e10 = ein1(1,k4,k5,k6)
	e11 = ein1(2,k4,k5,k6)
	e12 = ein1(3,k4,k5,k6)
	e13 = ein1(4,k4,k5,k6)
	e14 = ein1(5,k4,k5,k6)
	e15 = ein1(6,k4,k5,k6)
	e16 = ein1(7,k4,k5,k6)	
	
	e20 = ein2(1,k4,k5,k6)
	e21 = ein2(2,k4,k5,k6)
	e22 = ein2(3,k4,k5,k6)
	e23 = ein2(4,k4,k5,k6)
	e24 = ein2(5,k4,k5,k6)
	e25 = ein2(6,k4,k5,k6)
	e26 = ein2(7,k4,k5,k6)

	jt1 = ispoint2(k3,k4,k5,k6,k7)
	
	hh = bdiff/dble(nsimpson-1)
	
	do 831 i = 1,nsimpson
	hin = hx(i)
	if(hx(i).lt.blow)  hin = blow

	indiv   = 1
	bunemp  = bfunc(hin,indiv,k3,k4,avemp,avunemp,pc)
	sim1(i) = bunemp

        if (bunemp .le. blow) then
           zidcst1(i) = 1.
           zidncst1(i)= 0.
        else
           zidcst1(i) = 0.
           zidncst1(i)= 1.
        endif                  	

	indiv   = 2
	bemp    = bfunc(hin,indiv,k3,k4,avemp,avunemp,pc)
	sim2(i) = bemp

831     continue


       zeta = 0.0D+00
       ave  = 0.0D+00
       avu  = 0.0D+00
	
       do 832 i = 1,nsimpson	
       
        zeta = zeta +
     $  hh*zidcst1(i)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,
     $  zm4unemp,zm5unemp,zm6unemp,hx(i))*hw(i)

	ave= ave + 
     $  hh*sim2(i)*e20*dens(e21,e22,e23,e24,e25,e26,
     $  avemp,varemp,zm3emp,zm4emp,
     $  zm5emp,zm6emp,hx(i))*hw(i)
     
     	avu= avu + 
     $  hh*sim1(i)*e10*dens(e11,e12,e13,e14,e15,e16,
     $  avunemp,varunemp,zm3unemp,zm4unemp,
     $  zm5unemp,zm6unemp,hx(i))*hw(i)
                     
832     continue

       pcu = (probf(k3,1,k4,1)*pc)/(1.-stu(k4,8))       
       pce = (probf(k3,1,k4,2)*pc)/stu(k4,8)

       pc1 =(1.-pcu)*zeta + pcu

       avu = avu/(1.-zeta)
       ave =(1.-pce)*ave +       
     $  pce*bfunc(blow,2,k3,k4,avemp,avunemp,pc)     
     


       yreg(jt1,1) = pc1
       yreg(jt1,2) = ave
       yreg(jt1,3) = avu
	  
1000    continue


*
*
*       REGRESSIONS for the law of motion
*
*
	
        do 5000 ireg = 1,3
	
	NPMAX = NPAR2
	JMAX  = is3max*is4max*is5max*is6max*is7max

	DO 110 J = 1,NPMAX
	XY(J) = 0.0
	DO 110 K = 1,NPMAX
	XX(J,K) = 0.0
110     CONTINUE

	DO 130 J = 1,NPMAX
	DO 130 I = 1,JMAX
	XX(J,J) = XX(J,J) + CHEB2(I,J)*CHEB2(I,J)       
130     CONTINUE

	DO 135 J = 1,NPMAX
	XX(J,J) = 1./XX(J,J)
135     CONTINUE

	DO 140 J = 1,NPMAX
	DO 140 I = 1,JMAX
	XY(J) = XY(J) + CHEB2(I,J)*YREG(I,IREG)
140     CONTINUE

	DO 145 J = 1,NPMAX
	AGGNEW(IREG,J) = XX(J,J)*XY(J)
145     CONTINUE


5000    continue

	end


      subroutine k_dens(xsol0,eta0,av,var,xm3,xm4,xm5,xm6)

      implicit real*8(a-h,o-z),integer(i-n)
      parameter (nsimpson=301)         

      include 'dominpar.inc'
      double precision x,d,gradx,fx,xnorm,dnorm,
     1       sig,x0,d0,gradx0,fx0,x0norm,
     1       d0norm,sig0,difx,ftest,dirder
      common/xdat/x(nx),d(nx),gradx(nx),fx,xnorm,dnorm,sig,
     1          x0(nx),d0(nx),gradx0(nx),fx0,x0norm,d0norm,sig0,
     2          difx(nx),ftest,dirder
      logical test1,test2,test3,cold,test4
      common/param/epsx,epsg,epsf,test1,test2,test3,test4,cold
      double precision eta,thet2,bfgste
      integer niter,iterma
      common/bfgsparam/niter,iterma,eta,thet2,bfgste
      integer n
      common/dim/n
      logical analyt
      common/gradinf/analyt      
      double precision xst
      common/xst/xst(nx)
      character*80 ident
      common/ident/ident


       double precision xsol0,eta0
      
        common/rpar/    blow,bhigh,bdiff
        common/simpson/ hx(5000),hw(5000)        
        common/mmt/     zm1,zm2,zm3,zm4,zm5,zm6

        dimension xsol0(6),eta0(1)

       ident='cross-sectional distribution'
       n=6        
       cold=.true.
       analyt=.true.

	zm1       = av
	zm2       = var
	zm3       = xm3
	zm4       = xm4
	zm5       = xm5
	zm6       = xm6
                
        xst(1)=xsol0(1)
        xst(2)=xsol0(2)
        xst(3)=xsol0(3)
        xst(4)=xsol0(4)                
        xst(5)=xsol0(5)
        xst(6)=xsol0(6)
                             
         call domin
                	
	xsol0(1) = x(1)
	xsol0(2) = x(2)        
	xsol0(3) = x(3)        
	xsol0(4) = x(4)        
	xsol0(5) = x(5)        
	xsol0(6) = x(6)        
	         
         call newt(eta0,1)

      end
       
              
        subroutine f(x,fx,err)
        implicit real*8(a-h,o-z),integer(i-n)

         parameter(nsimpson=301)
         double precision x(*),fx
         logical err
         integer cf,cg,cu,csu,cre,cm

         common/domin_count/cf,cg,cu,csu,cre,cm
	 common/rpar/    blow,bhigh,bdiff
        common/simpson/ hx(5000),hw(5000)        
        common/mmt/     zm1,zm2,zm3,zm4,zm5,zm6

        
      err=.false.
      cf=cf+1

      e1 = x(1)        
      e2 = x(2)        
      e3 = x(3)        
      e4 = x(4)        
      e5 = x(5)        
      e6 = x(6)        
                              	
      fx = 0.

      hh = bdiff/dble(nsimpson-1)
      do 930 i = 1,nsimpson
        hin = hx(i)
	if(hin.lt.blow)  hin = blow
	fx = fx +  hh*dens(e1,e2,e3,e4,e5,e6,zm1,zm2,zm3,
     $   zm4,zm5,zm6,hx(i))*hw(i)
930     continue

      return
      end

      subroutine gradf(x,gradx,err)
      parameter(nsimpson=301)

      implicit real*8(a-h,o-z),integer(i-n)
      logical err
      double precision x(*),gradx(*)

        common/rpar/    blow,bhigh,bdiff
        common/simpson/ hx(5000),hw(5000)
        common/mmt/     zm1,zm2,zm3,zm4,zm5,zm6

      err=.false.
      
      e1 = x(1)        
      e2 = x(2)        
      e3 = x(3)        
      e4 = x(4)        
      e5 = x(5)
      e6 = x(6)
                        
      fx1 = 0.
      fx2 = 0.
      fx3 = 0.
      fx4 = 0.
      fx5 = 0.
      fx6 = 0.
                        
      hh = bdiff/dble(nsimpson-1)
      do 930 i = 1,nsimpson
        hin = hx(i)
	if(hin.lt.blow)  hin = blow
	fx1 = fx1 +  hh*(hin-zm1)*
     $  dens(e1,e2,e3,e4,e5,e6,zm1,zm2,zm3,zm4,zm5,zm6,hx(i))*hw(i)
	fx2 = fx2 +  hh*((((hin-zm1)**2)-zm2)/10)*
     $  dens(e1,e2,e3,e4,e5,e6,zm1,zm2,zm3,zm4,zm5,zm6,hx(i))*hw(i)
	fx3 = fx3 +  hh*((((hin-zm1)**3)-zm3)/1000)*
     $  dens(e1,e2,e3,e4,e5,e6,zm1,zm2,zm3,zm4,zm5,zm6,hx(i))*hw(i)
	fx4 = fx4 +  hh*((((hin-zm1)**4)-zm4)/10000)*
     $  dens(e1,e2,e3,e4,e5,e6,zm1,zm2,zm3,zm4,zm5,zm6,hx(i))*hw(i)
	fx5 = fx5 +  hh*((((hin-zm1)**5)-zm5)/1000000)*
     $  dens(e1,e2,e3,e4,e5,e6,zm1,zm2,zm3,zm4,zm5,zm6,hx(i))*hw(i)
	fx6 = fx6 +  hh*((((hin-zm1)**6)-zm6)/100000000)*
     $  dens(e1,e2,e3,e4,e5,e6,zm1,zm2,zm3,zm4,zm5,zm6,hx(i))*hw(i)	     
930     continue

      gradx(1)=fx1
      gradx(2)=fx2
      gradx(3)=fx3
      gradx(4)=fx4
      gradx(5)=fx5
      gradx(6)=fx6
                        
      return
      end


      subroutine funcv(numpar,eta0,fvec)     

      implicit real*8(a-h,o-z),integer(i-n)
      include 'dominpar.inc'
      double precision x,d,gradx,fx,xnorm,dnorm,
     1       sig,x0,d0,gradx0,fx0,x0norm,
     1       d0norm,sig0,difx,ftest,dirder
      common/xdat/x(nx),d(nx),gradx(nx),fx,xnorm,dnorm,sig,
     1          x0(nx),d0(nx),gradx0(nx),fx0,x0norm,d0norm,sig0,
     2          difx(nx),ftest,dirder


      
        common/rpar/    blow,bhigh,bdiff 
        common/simpson/ hx(5000),hw(5000)        
        common/mmt/     zm1,zm2,zm3,zm4,zm5,zm6
      
        parameter(nsimpson=301)
        dimension eta0(1),fvec(numpar)

        e0 = eta0(1)
	e1 = x(1)        
	e2 = x(2)
	e3 = x(3)
	e4 = x(4)
	e5 = x(5)
	e6 = x(6)
	
	a0 = 0.

	hh = bdiff/dble(nsimpson-1)
        do 930 i = 1,nsimpson
	hin = hx(i)
	if(hin.lt.blow)  hin = blow
	a0 = a0 +  hh*e0*dens(e1,e2,e3,e4,e5,e6,
     $       zm1,zm2,zm3,zm4,zm5,zm6,hx(i))*hw(i)
930     continue

        fvec(1) = a0 - 1.00D+00
	
        end
        

	real*8 function bfunc(aindiv,itype,iaggold,iaggcur,avemp,
     $                      avunemp,pc)
	implicit real*8(a-h,o-z),integer(i-n)
	parameter(npar=729,remp=0.15D+00)

	common/state/   stu(1000,10),stbar(10,2),st(1000,10)
	common/par/     beta,gam,alpha,delta,caps
	common/rpar/    blow,bhigh,bdiff
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax
     	common/coefind/ aold(8,npar),anew(8,npar)
	common/prob/    prob(2,2,2,2),pagg(2,2),probf(2,2,2,2)
		        		
	s1     =  sca(aindiv,1)
        s5     =  sca(avemp,5)
        s6     =  sca(avunemp,6)
	s7     =  sca(pc,7)

	esca   = 1./stu(1,8)
	empl   = stu(iaggcur,8)
	
	pcu    = (probf(iaggold,1,iaggcur,1)*pc)/(1.-empl)
	pce    = (probf(iaggold,1,iaggcur,2)*pc)/empl
	
	caps   = empl*(1.-pce)*avemp + (1.-empl)*(1.-pcu)*avunemp
	rental = alpha*stu(iaggcur,4)*((caps/(esca*empl))**(alpha-1.))
	sal    = (1-alpha)*stu(iaggcur,4)*((caps/(esca*empl))**alpha)
     

        if((itype.eq.1).and.(iaggold.eq.1).and.(iaggcur.eq.1))
     $   ivec=1            	              	
        if((itype.eq.1).and.(iaggold.eq.1).and.(iaggcur.eq.2)) 
     $   ivec=2            	
        if((itype.eq.1).and.(iaggold.eq.2).and.(iaggcur.eq.1)) 
     $   ivec=3
        if((itype.eq.1).and.(iaggold.eq.2).and.(iaggcur.eq.2)) 
     $   ivec=4            	                
        if((itype.eq.2).and.(iaggold.eq.1).and.(iaggcur.eq.1))
     $   ivec=5            	              	
        if((itype.eq.2).and.(iaggold.eq.1).and.(iaggcur.eq.2)) 
     $   ivec=6            	
        if((itype.eq.2).and.(iaggold.eq.2).and.(iaggcur.eq.1)) 
     $   ivec=7
        if((itype.eq.2).and.(iaggold.eq.2).and.(iaggcur.eq.2))
     $   ivec=8            	


	expb   =  pol(s1,s5,s6,s7,ivec)
	consb  =  (expb)**(1./gam)
	bfunc  =  aindiv*(1+rental-delta) - consb + 
     $  esca*(stu(itype,2)-((stu(itype,2)/empl)-1)*remp)*sal

        if(bfunc.lt.blow) then
	  bfunc  =  blow
        endif
        if(bfunc.gt.bhigh) then
	  bfunc  =  bhigh
        endif

        end

	real*8 function aggfunc(s3,s4,s5,s6,s7,ireg)                 
	Implicit real*8(a-h,o-z),integer(i-n)
        parameter (npar2=108)
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
	common/coefagg/ aggold(3,npar2),aggnew(3,npar2)	


	aggfunc = 0.
	do 20 j3 = 1,i3max+1
	do 20 j4 = 1,i4max+1
	do 20 j5 = 1,i5max+1
	do 20 j6 = 1,i6max+1
	do 20 j7 = 1,i7max+1
	i3 = j3 - 1
	i4 = j4 - 1
	i5 = j5 - 1     
	i6 = j6 - 1     
	i7 = j7 - 1     
	jj =  ipoint2(i3,i4,i5,i6,i7)	 
	aggfunc =  aggfunc 
     $        + aggold(ireg,jj)*hh2(s3,s4,s5,s6,s7,i3,i4,i5,i6,i7)

20      continue

        end              
	
        
	real*8 function pol(s1,s5,s6,s7,ivec)
        implicit real*8(a-h,o-z),integer(i-n)
        parameter (npar=729)
        
        common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
        common/coefind/ aold(8,npar),anew(8,npar)
             
	pol = 0.
	do 20 j1 = 1,i1max+1
	do 20 j5 = 1,i5max+1
	do 20 j6 = 1,i6max+1	
	do 20 j7 = 1,i7max+1	
	i1 = j1 - 1     
	i5 = j5 - 1     
	i6 = j6 - 1     	
	i7 = j7 - 1     	
	jj =  ipoint(i1,i5,i6,i7)
	pol =  pol + aold(ivec,jj)*hh(s1,s5,s6,s7,i1,i5,i6,i7)
20      continue

	pol = exp(pol)


        end               

        real*8 function avmmt_ub(nagg,j)
        implicit real*8(a-h,o-z),integer(i-n)
        parameter(nitime=1000)
	common/mmtsim/  zmmt_ub(nitime,7),zmmt_ug(nitime,7),
     $  zmmt_eb(nitime,7),zmmt_eg(nitime,7)
        avmmt_ub = 0.
        do 50 i = 1,nagg
	avmmt_ub = avmmt_ub + zmmt_ub(i,j)
50      continue
	avmmt_ub = avmmt_ub/dble(nagg)
	
        end

        real*8 function avmmt_ug(nagg,j)
        implicit real*8(a-h,o-z),integer(i-n)
        parameter(nitime=1000)
	common/mmtsim/  zmmt_ub(nitime,7),zmmt_ug(nitime,7),
     $  zmmt_eb(nitime,7),zmmt_eg(nitime,7)
        avmmt_ug = 0.
        do 50 i = 1,nagg
	avmmt_ug = avmmt_ug + zmmt_ug(i,j)
50      continue
	avmmt_ug = avmmt_ug/dble(nagg)
	
        end

        real*8 function avmmt_eb(nagg,j)
        implicit real*8(a-h,o-z),integer(i-n)
        parameter(nitime=1000)
	common/mmtsim/  zmmt_ub(nitime,7),zmmt_ug(nitime,7),
     $  zmmt_eb(nitime,7),zmmt_eg(nitime,7)
        avmmt_eb = 0.
        do 50 i = 1,nagg
	avmmt_eb = avmmt_eb + zmmt_eb(i,j)
50      continue
	avmmt_eb = avmmt_eb/dble(nagg)
	
        end

        real*8 function avmmt_eg(nagg,j)
        implicit real*8(a-h,o-z),integer(i-n)
        parameter(nitime=1000)
	common/mmtsim/  zmmt_ub(nitime,7),zmmt_ug(nitime,7),
     $  zmmt_eb(nitime,7),zmmt_eg(nitime,7)
        avmmt_eg = 0.
        do 50 i = 1,nagg
	avmmt_eg = avmmt_eg + zmmt_eg(i,j)
50      continue
	avmmt_eg = avmmt_eg/dble(nagg)
	
        end
        
                                      
	integer function ipoint(i1,i5,i6,i7)
	implicit real*8(a-h,o-z),integer(i-n)
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
	 
	ipoint = 1 + i5 
     $  + i6*(i5max+1) 
     $  + i1*(i6max+1)*(i5max+1)            
     $  + i7*(i1max+1)*(i6max+1)*(i5max+1)            
     
     
        end        

	integer function ipoint2(i3,i4,i5,i6,i7)
	implicit real*8(a-h,o-z),integer(i-n)
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
	 
	ipoint2 = 1 + i3
     $  + i4*(i3max+1) 
     $  + i5*(i4max+1)*(i3max+1)       
     $  + i6*(i5max+1)*(i4max+1)*(i3max+1)       
     $  + i7*(i6max+1)*(i5max+1)*(i4max+1)*(i3max+1)       
        end
        
	integer function ispoint2(is3,is4,is5,is6,is7)
	implicit real*8(a-h,o-z),integer(i-n)
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
	
	ispoint2 = is3 
     $  + (is4-1)*(is3max) 
     $  + (is5-1)*(is4max*is3max)
     $  + (is6-1)*(is5max*is4max*is3max)
     $  + (is7-1)*(is6max*is5max*is4max*is3max)
        end
                
	real*8 function sca(x,i)
	implicit real*8(a-h,o-z),integer(i-n)
        common/state/ stu(1000,10),stbar(10,2),st(1000,10)
	common/rpar/    blow,bhigh,bdiff
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	

	sca =  ( 2.*x -  stbar(i,2) - stbar(i,1) ) 
     $        /  (stbar(i,2)-stbar(i,1))

	end 

	real*8 function scinv(x,i)
	implicit real*8(a-h,o-z),integer(i-n)
	common/state/ stu(1000,10),stbar(10,2),st(1000,10)
	common/rpar/    blow,bhigh,bdiff
	common/ipar/    i1max,i3max,i4max,i5max,i6max,
     $  i7max,i8max,is1max,is3max,is4max,
     $  is5max,is6max,is7max,is8max,imax	
	 
	scinv =  (    stbar(i,2) + stbar(i,1)  
     $        +    x*(stbar(i,2) - stbar(i,1))   ) / 2.

	end 


	real*8 function h(x,i)
	implicit real*8(a-h,o-z),integer(i-n)
        
        dimension a(200)

	a(1) = 1.
	a(2) = x

	if(i.le.1) then
	h =  a(i+1)
	goto 99
	endif

	
	if(i.gt.1) then

	do 10 j = 2,i
	a(j+1) = 2.*x*a(j) - a(j-1)
10      continue
	h =  a(i+1)

	endif

99      continue

	end


	real*8 function hh(s1,s5,s6,s7,i1,i5,i6,i7)
	implicit real*8(a-h,o-z),integer(i-n)
	
	hh = h(s1,i1)*h(s5,i5)*h(s6,i6)*h(s7,i7)
	
	end

	real*8 function hh2(s3,s4,s5,s6,s7,i3,i4,i5,i6,i7)
	implicit real*8(a-h,o-z),integer(i-n)
	
	hh2 = h(s3,i3)*h(s4,i4)*h(s5,i5)*h(s6,i6)*h(s7,i7)
	
	end	

	real*8 function dens(e1,e2,e3,e4,e5,e6,zm1,zm2,zm3,zm4,zm5,zm6,bb)
	implicit real*8(a-h,o-z),integer(i-n)
       	 
	dens = exp(e1*(bb-zm1) + (e2*(((bb-zm1)**2)-zm2))/10
     $        + (e3*(((bb-zm1)**3)-zm3))/1000 
     $        + (e4*(((bb-zm1)**4)-zm4))/10000
     $        + (e5*(((bb-zm1)**5)-zm5))/1000000 
     $        + (e6*(((bb-zm1)**6)-zm6))/100000000  )        
        
        end      


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Subroutine from Numerical Recipes Software 
c		
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc     



      SUBROUTINE newt(x,n)
      INTEGER n,nn,NP,MAXITS
      LOGICAL check
      DOUBLE PRECISION x(n),fvec,TOLF,TOLMIN,TOLX,STPMX
      PARAMETER (NP=40,MAXITS=6000,TOLF=1.d-8,TOLMIN=1.d-12,TOLX=3.d-16,
     *STPMX=10000.d0)
      COMMON /newtv/ fvec(NP),nn
      SAVE /newtv/
CU    USES fdjac,fmin,lnsrch,lubksb,ludcmp
      INTEGER i,its,j,indx(NP)
      DOUBLE PRECISION d,den,f,fold,stpmax,sum,temp,test,fjac(NP,NP),g
     *(NP),p(NP),
     *xold(NP),fmin
      EXTERNAL fmin
      nn=n
      f=fmin(x)
      test=0.d0
      do 11 i=1,n
	if(abs(fvec(i)).gt.test)test=abs(fvec(i))
11    continue
      if(test.lt..01d0*TOLF)return
      sum=0.d0
      do 12 i=1,n
	sum=sum+x(i)**2
12    continue
      stpmax=STPMX*max(sqrt(sum), dble(n))
      do 21 its=1,MAXITS
	call fdjac(n,x,fvec,NP,fjac)
	do 14 i=1,n
	  sum=0.d0
	  do 13 j=1,n
	    sum=sum+fjac(j,i)*fvec(j)
13        continue
	  g(i)=sum
14      continue
	do 15 i=1,n
	  xold(i)=x(i)
15      continue
	fold=f
	do 16 i=1,n
	  p(i)=-fvec(i)
16      continue
	call ludcmp(fjac,n,NP,indx,d)
	call lubksb(fjac,n,NP,indx,p)
	call lnsrch(n,xold,fold,g,p,x,f,stpmax,check,fmin)
	test=0.d0
	do 17 i=1,n
	  if(abs(fvec(i)).gt.test)test=abs(fvec(i))
17      continue
	if(test.lt.TOLF)then
	  check=.false.
	  return
	endif
	if(check)then
	  test=0.d0
	  den=max(f,.5d0*n)
	  do 18 i=1,n
	    temp=abs(g(i))*max(abs(x(i)),1.d0)/den
	    if(temp.gt.test)test=temp
18        continue
	  if(test.lt.TOLMIN)then
	    check=.true.
	  else
	    check=.false.
	  endif
	  return
	endif
	test=0.d0
	do 19 i=1,n
	  temp=(abs(x(i)-xold(i)))/max(abs(x(i)),1.d0)
	  if(temp.gt.test)test=temp
19      continue
	if(test.lt.TOLX)return
21    continue
      pause 'MAXITS exceeded in newt'
      END
C  (C) Copr. 1986-92 Numerical Recipes Software D.Q=.
      
      SUBROUTINE lubksb(a,n,np,indx,b)
      INTEGER n,np,indx(n)
      DOUBLE PRECISION a(np,np),b(n)
      INTEGER i,ii,j,ll
      DOUBLE PRECISION sum
      ii=0
      do 12 i=1,n
	ll=indx(i)
	sum=b(ll)
	b(ll)=b(i)
	if (ii.ne.0)then
	  do 11 j=ii,i-1
	    sum=sum-a(i,j)*b(j)
11        continue
	else if (sum.ne.0.d0) then
	  ii=i
	endif
	b(i)=sum
12    continue
      do 14 i=n,1,-1
	sum=b(i)
	do 13 j=i+1,n
	  sum=sum-a(i,j)*b(j)
13      continue
	b(i)=sum/a(i,i)
14    continue
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software D.Q=.
      SUBROUTINE ludcmp(a,n,np,indx,d)
      INTEGER n,np,indx(n),NMAX
      DOUBLE PRECISION d,a(np,np),TINY
      PARAMETER (NMAX=500,TINY=1.0d-20)
      INTEGER i,imax,j,k
      DOUBLE PRECISION aamax,dum,sum,vv(NMAX)
      d=1.d0
      do 12 i=1,n
	aamax=0.d0
	do 11 j=1,n
	  if (abs(a(i,j)).gt.aamax) aamax=abs(a(i,j))
11      continue
	if (aamax.eq.0.d0) pause 'singular matrix in ludcmp'
	vv(i)=1.d0/aamax
12    continue
      do 19 j=1,n
	do 14 i=1,j-1
	  sum=a(i,j)
	  do 13 k=1,i-1
	    sum=sum-a(i,k)*a(k,j)
13        continue
	  a(i,j)=sum
14      continue
	aamax=0.d0
	do 16 i=j,n
	  sum=a(i,j)
	  do 15 k=1,j-1
	    sum=sum-a(i,k)*a(k,j)
15        continue
	  a(i,j)=sum
	  dum=vv(i)*abs(sum)
	  if (dum.ge.aamax) then
	    imax=i
	    aamax=dum
	  endif
16      continue
	if (j.ne.imax)then
	  do 17 k=1,n
	    dum=a(imax,k)
	    a(imax,k)=a(j,k)
	    a(j,k)=dum
17        continue
	  d=-d
	  vv(imax)=vv(j)
	endif
	indx(j)=imax
	if(a(j,j).eq.0.d0)a(j,j)=TINY
	if(j.ne.n)then
	  dum=1.d0/a(j,j)
	  do 18 i=j+1,n
	    a(i,j)=a(i,j)*dum
18        continue
	endif
19    continue
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software D.Q=.
      SUBROUTINE fdjac(n,x,fvec,np,df)
      INTEGER n,np,NMAX
      DOUBLE PRECISION df(np,np),fvec(n),x(n),EPS
      PARAMETER (NMAX=40,EPS=1.d-8)
CU    USES funcv
      INTEGER i,j
      DOUBLE PRECISION h,temp,f(NMAX)
      do 12 j=1,n
	temp=x(j)
	h=EPS*abs(temp)
	if(h.eq.0.d0)h=EPS
	x(j)=temp+h
	h=x(j)-temp
	call funcv(n,x,f)
	x(j)=temp
	do 11 i=1,n
	  df(i,j)=(f(i)-fvec(i))/h
11      continue
12    continue
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software D.Q=.
      FUNCTION fmin(x)
      INTEGER n,NP
      DOUBLE PRECISION fmin,x(*),fvec
      PARAMETER (NP=40)
      COMMON /newtv/ fvec(NP),n
      SAVE /newtv/
CU    USES funcv
      INTEGER i
      DOUBLE PRECISION sum
      call funcv(n,x,fvec)
      sum=0.d0
      do 11 i=1,n
	sum=sum+fvec(i)**2
11    continue
      fmin=0.5d0*sum
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software D.Q=.
      SUBROUTINE lnsrch(n,xold,fold,g,p,x,f,stpmax,check,func)
      INTEGER n
      LOGICAL check
      DOUBLE PRECISION f,fold,stpmax,g(n),p(n),x(n),xold(n),func,ALF
     *,TOLX
      PARAMETER (ALF=1.d-4,TOLX=3.d-16)
      EXTERNAL func
CU    USES func
      INTEGER i
      DOUBLE PRECISION a,alam,alam2,alamin,b,disc,f2,fold2,rhs1,rhs2
     *,slope,sum,temp,
     *test,tmplam
      check=.false.
      sum=0.d0
      do 11 i=1,n
	sum=sum+p(i)*p(i)
11    continue
      sum=sqrt(sum)
      if(sum.gt.stpmax)then
	do 12 i=1,n
	  p(i)=p(i)*stpmax/sum
12      continue
      endif
      slope=0.d0
      do 13 i=1,n
	slope=slope+g(i)*p(i)
13    continue
      test=0.d0
      do 14 i=1,n
	temp=abs(p(i))/max(abs(xold(i)),1.d0)
	if(temp.gt.test)test=temp
14    continue
      alamin=TOLX/test
      alam=1.d0
1     continue
	do 15 i=1,n
	  x(i)=xold(i)+alam*p(i)
15      continue
	f=func(x)
	if(alam.lt.alamin)then
	  do 16 i=1,n
	    x(i)=xold(i)
16        continue
	  check=.true.
	  return
	else if(f.le.fold+ALF*alam*slope)then
	  return
	else
	  if(alam.eq.1.d0)then
	    tmplam=-slope/(2.d0*(f-fold-slope))
	  else
	    rhs1=f-fold-alam*slope
	    rhs2=f2-fold2-alam2*slope
	    a=(rhs1/alam**2-rhs2/alam2**2)/(alam-alam2)
	    b=(-alam2*rhs1/alam**2+alam*rhs2/alam2**2)/(alam-alam2)
	    if(a.eq.0.d0)then
	      tmplam=-slope/(2.d0*b)
	    else
	      disc=b*b-3.d0*a*slope
	      tmplam=(-b+sqrt(disc))/(3.d0*a)
	    endif
	    if(tmplam.gt..5d0*alam)tmplam=.5d0*alam
	  endif
	endif
	alam2=alam
	f2=f
	fold2=fold
	alam=max(tmplam,.1d0*alam)
      goto 1
      END       
      
      subroutine sgrnd(seed)
*
      implicit integer(a-z)
*
* Period parameters
      parameter(N     =  624)
*
      dimension mt(0:N-1)
*                     the array for the state vector
      common /block/mti,mt
      save   /block/
*
*      setting initial seeds to mt[N] using
*      the generator Line 25 of Table 1 in
*      [KNUTH 1981, The Art of Computer Programming
*         Vol. 2 (2nd Ed.), pp102]
*
      mt(0)= iand(seed,-1)
      do 1000 mti=1,N-1
*        mt(mti) = iand(69069 * mt(mti-1),-1)   MJ 3/5/2004

*     See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier.
*     In the previous versions, MSBs of the seed affect  
*     only MSBs of the array mt[].                       
*     2002/01/09 modified by Makoto Matsumoto            
*     Fortran version 2004/3/15 Michel Juillard
        mt(mti) = (1812433253*ieor(mt(mti-1),ishft(mt(mti-1),-30))+ mti)
        mt(mti) = iand(mt(mti),-1)
 1000 continue
*
      return
      end

CC Check the subroutine


************************************************************************
      double precision function grnd()
*
      implicit integer(a-z)
*
* Period parameters
      parameter(N     =  624)
      parameter(N1    =  N+1)
      parameter(M     =  397)
      parameter(MATA  = -1727483681)
*                                    constant vector a
      parameter(UMASK = -2147483648)
*                                    most significant w-r bits
      parameter(LMASK =  2147483647)
*                                    least significant r bits
* Tempering parameters
      parameter(TMASKB= -1658038656)
      parameter(TMASKC= -272236544)
*
      dimension mt(0:N-1)
*                     the array for the state vector
      common /block/mti,mt
      save   /block/
      data   mti/N1/
*                     mti==N+1 means mt[N] is not initialized
*
      dimension mag01(0:1)
      data mag01/0, MATA/
      save mag01
*                        mag01(x) = x * MATA for x=0,1
*
      TSHFTU(y)=ishft(y,-11)
      TSHFTS(y)=ishft(y,7)
      TSHFTT(y)=ishft(y,15)
      TSHFTL(y)=ishft(y,-18)
*
      if(mti.ge.N) then
*                       generate N words at one time
        if(mti.eq.N+1) then
*                            if sgrnd() has not been called,
*          call sgrnd(4357)  MJ 2004/3/15
          call sgrnd(5489)
*                              a default initial seed is used
        endif
*
        do 1000 kk=0,N-M-1
            y=ior(iand(mt(kk),UMASK),iand(mt(kk+1),LMASK))
            mt(kk)=ieor(ieor(mt(kk+M),ishft(y,-1)),mag01(iand(y,1)))
 1000   continue
        do 1100 kk=N-M,N-2
            y=ior(iand(mt(kk),UMASK),iand(mt(kk+1),LMASK))
            mt(kk)=ieor(ieor(mt(kk+(M-N)),ishft(y,-1)),mag01(iand(y,1)))
 1100   continue
        y=ior(iand(mt(N-1),UMASK),iand(mt(0),LMASK))
        mt(N-1)=ieor(ieor(mt(M-1),ishft(y,-1)),mag01(iand(y,1)))
        mti = 0
      endif
*
      y=mt(mti)
      mti=mti+1
      y=ieor(y,TSHFTU(y))
      y=ieor(y,iand(TSHFTS(y),TMASKB))
      y=ieor(y,iand(TSHFTT(y),TMASKC))
      y=ieor(y,TSHFTL(y))
*
      if(y.lt.0) then
        grnd=(dble(y)+2.0d0**32)/(2.0d0**32-1.0d0)
      else
        grnd=dble(y)/(2.0d0**32-1.0d0)
      endif
*
      return
      end
           
cccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Subroutines and function to derive the inverse of a matrix
c
cccccccccccccccccccccccccccccccccccccccccccccccc
      
      subroutine dgefa(a,lda,n,ipvt,info)
      integer lda,n,ipvt(1),info	
      double precision a(lda,1)
c
c     dgefa factors a double precision matrix by gaussian elimination.
c
c     dgefa is usually called by dgeco, but it can be called
c     directly with a saving in time if  rcond  is not needed.
c     (time for dgeco) = (1 + 9/n)*(time for dgefa) .
c
c     on entry
c
c        a       double precision(lda, n)
c                the matrix to be factored.
c
c        lda     integer
c                the leading dimension of the array  a .
c
c        n       integer
c                the order of the matrix  a .
c
c     on return
c
c        a       an upper triangular matrix and the multipliers
c                which were used to obtain it.
c                the factorization can be written  a = l*u  where
c                l  is a product of permutation and unit lower
c                triangular matrices and  u  is upper triangular.
c
c        ipvt    integer(n)
c                an integer vector of pivot indices.
c
c        info    integer
c                = 0  normal value.
c                = k  if  u(k,k) .eq. 0.0 .  this is not an error
c                     condition for this subroutine, but it does
c                     indicate that dgesl or dgedi will divide by zero
c                     if called.  use  rcond  in dgeco for a reliable
c                     indication of singularity.
c
c     linpack. this version dated 08/14/78 .
c     cleve moler, university of new mexico, argonne national lab.
c
c     subroutines and functions
c
c     blas daxpy,dscal,idamax
c
c     internal variables
c
      double precision t
      integer idamax,j,k,kp1,l,nm1
c
c
c     gaussian elimination with partial pivoting
c
      info = 0
      nm1 = n - 1
      if (nm1 .lt. 1) go to 70
      do 60 k = 1, nm1
         kp1 = k + 1
c
c        find l = pivot index
c
         l = idamax(n-k+1,a(k,k),1) + k - 1
         ipvt(k) = l
c
c        zero pivot implies this column already triangularized
c
         if (a(l,k) .eq. 0.0d0) go to 40
c
c           interchange if necessary
c
            if (l .eq. k) go to 10
               t = a(l,k)
               a(l,k) = a(k,k)
               a(k,k) = t
   10       continue
c
c           compute multipliers
c
            t = -1.0d0/a(k,k)
            call dscal(n-k,t,a(k+1,k),1)
c
c           row elimination with column indexing
c
            do 30 j = kp1, n
               t = a(l,j)
               if (l .eq. k) go to 20
                  a(l,j) = a(k,j)
                  a(k,j) = t
   20          continue
               call daxpy(n-k,t,a(k+1,k),1,a(k+1,j),1)
   30       continue
         go to 50
   40    continue
            info = k
   50    continue
   60 continue
   70 continue
      ipvt(n) = n
      if (a(n,n) .eq. 0.0d0) info = n
      return
      end


      subroutine dgedi(a,lda,n,ipvt,det,work,job)
      integer lda,n,ipvt(1),job
      double precision a(lda,1),det(2),work(1)
c
c     dgedi computes the determinant and inverse of a matrix
c     using the factors computed by dgeco or dgefa.
c
c     on entry
c
c        a       double precision(lda, n)
c                the output from dgeco or dgefa.
c
c        lda     integer
c                the leading dimension of the array  a .
c
c        n       integer
c                the order of the matrix  a .
c
c        ipvt    integer(n)
c                the pivot vector from dgeco or dgefa.
c
c        work    double precision(n)
c                work vector.  contents destroyed.
c
c        job     integer
c                = 11   both determinant and inverse.
c                = 01   inverse only.
c                = 10   determinant only.
c
c     on return
c
c        a       inverse of original matrix if requested.
c                otherwise unchanged.
c
c        det     double precision(2)
c                determinant of original matrix if requested.
c                otherwise not referenced.
c                determinant = det(1) * 10.0**det(2)
c                with  1.0 .le. dabs(det(1)) .lt. 10.0
c                or  det(1) .eq. 0.0 .
c
c     error condition
c
c        a division by zero will occur if the input factor contains
c        a zero on the diagonal and the inverse is requested.
c        it will not occur if the subroutines are called correctly
c        and if dgeco has set rcond .gt. 0.0 or dgefa has set
c        info .eq. 0 .
c
c     linpack. this version dated 08/14/78 .
c     cleve moler, university of new mexico, argonne national lab.
c
c     subroutines and functions
c
c     blas daxpy,dscal,dswap
c     fortran dabs,mod
c
c     internal variables
c
      double precision t
      double precision ten
      integer i,j,k,kb,kp1,l,nm1
c
c
c     compute determinant
c
      if (job/10 .eq. 0) go to 70
         det(1) = 1.0d0
         det(2) = 0.0d0
         ten = 10.0d0
         do 50 i = 1, n
            if (ipvt(i) .ne. i) det(1) = -det(1)
            det(1) = a(i,i)*det(1)
c        ...exit
            if (det(1) .eq. 0.0d0) go to 60
   10       if (dabs(det(1)) .ge. 1.0d0) go to 20
               det(1) = ten*det(1)
               det(2) = det(2) - 1.0d0
            go to 10
   20       continue
   30       if (dabs(det(1)) .lt. ten) go to 40
               det(1) = det(1)/ten
               det(2) = det(2) + 1.0d0
            go to 30
   40       continue
   50    continue
   60    continue
   70 continue
c
c     compute inverse(u)
c
      if (mod(job,10) .eq. 0) go to 150
         do 100 k = 1, n
            a(k,k) = 1.0d0/a(k,k)
            t = -a(k,k)
            call dscal(k-1,t,a(1,k),1)
            kp1 = k + 1
            if (n .lt. kp1) go to 90
            do 80 j = kp1, n
               t = a(k,j)
               a(k,j) = 0.0d0
               call daxpy(k,t,a(1,k),1,a(1,j),1)
   80       continue
   90       continue
  100    continue
c
c        form inverse(u)*inverse(l)
c
         nm1 = n - 1
         if (nm1 .lt. 1) go to 140
         do 130 kb = 1, nm1
            k = n - kb
            kp1 = k + 1
            do 110 i = kp1, n
               work(i) = a(i,k)
               a(i,k) = 0.0d0
  110       continue
            do 120 j = kp1, n
               t = work(j)
               call daxpy(n,t,a(1,j),1,a(1,k),1)
  120       continue
            l = ipvt(k)
            if (l .ne. k) call dswap(n,a(1,k),1,a(1,l),1)
  130    continue
  140    continue
  150 continue
      return
      end

      subroutine daxpy(n,da,dx,incx,dy,incy)
c
c     constant times a vector plus a vector.
c     uses unrolled loops for increments equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      double precision dx(1),dy(1),da
      integer i,incx,incy,ix,iy,m,mp1,n
c
      if(n.le.0)return
      if (da .eq. 0.0d0) return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dy(iy) = dy(iy) + da*dx(ix)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dy(i) = dy(i) + da*dx(i)
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        dy(i) = dy(i) + da*dx(i)
        dy(i + 1) = dy(i + 1) + da*dx(i + 1)
        dy(i + 2) = dy(i + 2) + da*dx(i + 2)
        dy(i + 3) = dy(i + 3) + da*dx(i + 3)
   50 continue
      return
      end
      double precision function ddot(n,dx,incx,dy,incy)
c
c     forms the dot product of two vectors.
c     uses unrolled loops for increments equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      double precision dx(1),dy(1),dtemp
      integer i,incx,incy,ix,iy,m,mp1,n
c
      ddot = 0.0d0
      dtemp = 0.0d0
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dtemp = dtemp + dx(ix)*dy(iy)
        ix = ix + incx
        iy = iy + incy
   10 continue
      ddot = dtemp
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,5)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dtemp = dtemp + dx(i)*dy(i)
   30 continue
      if( n .lt. 5 ) go to 60
   40 mp1 = m + 1
      do 50 i = mp1,n,5
        dtemp = dtemp + dx(i)*dy(i) + dx(i + 1)*dy(i + 1) +
     *   dx(i + 2)*dy(i + 2) + dx(i + 3)*dy(i + 3) + dx(i + 4)*dy(i + 4)
   50 continue
   60 ddot = dtemp
      return
      end


      subroutine  dscal(n,da,dx,incx)
c
c     scales a vector by a constant.
c     uses unrolled loops for increment equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      double precision da,dx(1)
      integer i,incx,m,mp1,n,nincx
c
      if(n.le.0)return
      if(incx.eq.1)go to 20
c
c        code for increment not equal to 1
c
      nincx = n*incx
      do 10 i = 1,nincx,incx
        dx(i) = da*dx(i)
   10 continue
      return
c
c        code for increment equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,5)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dx(i) = da*dx(i)
   30 continue
      if( n .lt. 5 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,5
        dx(i) = da*dx(i)
        dx(i + 1) = da*dx(i + 1)
        dx(i + 2) = da*dx(i + 2)
        dx(i + 3) = da*dx(i + 3)
        dx(i + 4) = da*dx(i + 4)
   50 continue
      return
      end

      integer function idamax(n,dx,incx)
c
c     finds the index of element having max. dabsolute value.
c     jack dongarra, linpack, 3/11/78.
c
      double precision dx(1),dmax
      integer i,incx,ix,n
c
      idamax = 0
      if( n .lt. 1 ) return
      idamax = 1
      if(n.eq.1)return
      if(incx.eq.1)go to 20
c
c        code for increment not equal to 1
c
      ix = 1
      dmax = dabs(dx(1))
      ix = ix + incx
      do 10 i = 2,n
         if(dabs(dx(ix)).le.dmax) go to 5
         idamax = i
         dmax = dabs(dx(ix))
    5    ix = ix + incx
   10 continue
      return
c
c        code for increment equal to 1
c
   20 dmax = dabs(dx(1))
      do 30 i = 2,n
         if(dabs(dx(i)).le.dmax) go to 30
         idamax = i
         dmax = dabs(dx(i))
   30 continue
      return
      end
      
      subroutine  dswap (n,dx,incx,dy,incy)
c
c     interchanges two vectors.
c     uses unrolled loops for increments equal one.
c     jack dongarra, linpack, 3/11/78.
c     modified 12/3/93, array(1) declarations changed to array(*)
c
      double precision dx(*),dy(*),dtemp
      integer i,incx,incy,ix,iy,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c       code for unequal increments or equal increments not equal
c         to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dtemp = dx(ix)
        dx(ix) = dy(iy)
        dy(iy) = dtemp
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c       code for both increments equal to 1
c
c
c       clean-up loop
c
   20 m = mod(n,3)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dtemp = dx(i)
        dx(i) = dy(i)
        dy(i) = dtemp
   30 continue
      if( n .lt. 3 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,3
        dtemp = dx(i)
        dx(i) = dy(i)
        dy(i) = dtemp
        dtemp = dx(i + 1)
        dx(i + 1) = dy(i + 1)
        dy(i + 1) = dtemp
        dtemp = dx(i + 2)
        dx(i + 2) = dy(i + 2)
        dy(i + 2) = dtemp
   50 continue
      return
      end
            
