@*****************************************************************************@
@                                                                             @
@                                 D . P . D .                                 @
@                                                                             @
@        A program in the GAUSS matrix programming language to compute        @
@        GMM estimates for a dynamic model from unbalanced panel data.        @
@                                                                             @
@        Manuel Arellano and Stephen Bond                    June 1989        @
@                                                                             @
@*****************************************************************************@

output off; ?;?;?;?;?;?;?;?;
" ***************                 D . P . D .                ***************";
" Version 6/6/89"; ?;?;?;?;

format /m1 /rd 1,0;
" State form of model";
" - type 0 for levels, 1 for first-differences or 2 for orthogonal deviations";
idif=con(1,1); ddd=0; if idif==1; ddd=1; endif;
" Select estimation method";
" - type 0 for OLS or 1 for IV"; iiv=con(1,1);
" Do you want robust test statistics and two-step estimates";
" - type 1 for yes or 0 for no"; icov=con(1,1); ?; iconst1=0; iconst2=0;
" Do you want time dummies as regressors {1/0}"; itim1=con(1,1);
if itim1==1; itim2=1; iconst1=1; iconst2=1; else; itim2=0; if iiv==1;
" Do you want time dummies as instruments {1/0}"; itim2=con(1,1);
if itim2==1; iconst2=1; endif; endif; endif;
" Do you want industry dummies as regressors {1/0}"; iind1=con(1,1);
if iind1==1; iind2=1; iconst1=1; iconst2=1; else; iind2=0; if iiv==1;
" Do you want industry dummies as instruments {1/0}"; iind2=con(1,1);
if iind2==1; iconst2=1; endif; endif; endif;
if iconst1==0;
" Do you want a constant as a regressor {1/0}"; iconst1=con(1,1);
if iconst1==1; iconst2==1; else; if iiv==1;
" Do you want a constant as an instrument {1/0}"; iconst2=con(1,1);
endif; endif; endif; ?;
" Print descriptive statistics {1/0}"; idesc=con(1,1);
" Print parameter covariance matrices {1/0}"; ipar=con(1,1);

speed=hsec;
mm=rowsf(f2); ef=seekr(f2,startf2); inf1=readr(f2,mm);
ra=int(inf1[1,2]/ncomp); rb=inf1[1,2]%ncomp;
if ra<1; inf=inf1[1,.]; else; inf=inf1[1,1]~ncomp;
bj=2; do while bj<=ra; inf=inf|(inf1[1,1]~ncomp); bj=bj+1; endo;
if rb>0; inf=inf|(inf1[1,1]~rb); endif; endif;
aj=2; do while aj<=rows(inf1);
ra=int(inf1[aj,2]/ncomp); rb=inf1[aj,2]%ncomp;
if ra<1; inf=inf|inf1[aj,.]; else;
bj=1; do while bj<=ra; inf=inf|(inf1[aj,1]~ncomp); bj=bj+1; endo;
if rb>0; inf=inf|(inf1[aj,1]~rb); endif; endif;
aj=aj+1; endo; mm=rows(inf); infmax=maxc(inf); tmax=infmax[1,1]; @tmax=tmax-1;@
i=lag+2; do while i<=tmax; if i==lag+2; dv=i; ssd=i+year1-1901;
else; dv=dv|i; ssd=ssd|i+year1-1901; endif; i=i+1; endo;
i=1; do while i<=indmax; if i==1; dv1=i; else; dv1=dv1|i; endif; i=i+1; endo;
ef=seekr(f1,startf1); r=1;  goto done;

@---------------------------- Subroutine Defdata -----------------------------@
defdata:
  format 5,0;
  r;; t=inf[r,1]; t;; mul=inf[r,2]; mul;; t1=t-lag-1;
  nr=mul*t;                                           @ Making appropriate nr @
  data=readr(f1,nr);                                    @ Reads data set here @

@templog=ln(data[.,7]);
templog=tlag(templog,1,0,t)-tlag(templog,0,1,t);
data=tlag(data,1,0,t);
t=t-1; t1=t1-1;@

@------------------------- construct dummy variables -------------------------@
  hist=data[.,yearcol];
  dhist=hist-year1+1; ldhist=tlag(dhist,lag+1,0,t);
  fdums=dummy(ldhist,dv); if itim2==1; tdums=fdums[.,2:cols(fdums)]; endif;

@ldhist2=tlag(dhist,lag,0,t); fdums=dummy(ldhist2,dv); @

  ind=data[.,indcol]; lind=tlag(ind,lag+1,0,t);
  idums=dummy(lind,dv1); if iind2==1; indums=idums[.,2:cols(idums)]; endif;

  clear y,x,z;

@---------------- data transformations and model specification ---------------@
  gosub model;

  clear data,zgmm,dtbi;

@-----------------------------------------------------------------------------@
  if iiv==0; if ich==0; z=x; endif; endif; kp=cols(x); namey=namey~namey;
  if idesc==1; nameyx=namex; yx=y~x; kk=cols(yx); endif;
  if iconst1==1; x=ones(rows(y),1)~x; namex="CONST"~namex; kp=kp+1;
  z=ones(rows(y),1)~z; namez="CONST"~namez; else;
  if iconst2==1; z=ones(rows(y),1)~z; namez="CONST"~namez; endif; endif;
  if Itim1==1; x=x~tdums; kd=kp+cols(tdums);
  z=z~tdums; namez=namez~"TIM DUMS"; else;
  if itim2==1; z=z~tdums; namez=namez~"TIM DUMS"; endif; endif;
  if iind1==1; x=x~indums; z=z~indums; namez=namez~"IND DUMS"; else;
  if iind2==1; z=z~indums; namez=namez~"IND DUMS"; endif; endif;
  clear tdums,indums; cinst=cols(z); cinst; @if cinst>90;
  " Selected instrument matrix has too many columns:";; cinst;
  " Cannot exceed 90. Please reselect."; end; endif;@
  if cinst<cols(x); " Insufficient number of instruments. Please reselect.";
  end; endif;
  if cinst==cols(x); if iiv==1; ich=1; endif; iiv=0; endif;

  n=rows(y);
  fms=fms+mul;                                          @ fms=number of firms @
  obs=obs+n;                                     @ obs=number of observations @
  k=cols(x);                              @ k=number of independent variables @
return;
@----------------------------- End of Subroutine -----------------------------@
done:
?; "          *******************Reading Data********************";
clear obs,sumy,xz,zy,yy,xx,xy,zkz,mom,sumyx,sumx,fms,y2y,x2x,y2x,x2y,y1y,
x1x,y1x,x1y,yky2,xkx2,ykx2,zky2,zkx2,yky1,xkx1,ykx1,zky1,zkx1,nc1,nc2;
r=1;
do while r<=mm;
   gosub defdata;                                                 @ Read data @
   yy=moment(y,1)+yy;                                  @ Construct matrix y'y @
   xy=x'y+xy;                                          @ Construct matrix x'y @
   xz=x'z+xz;                                          @ Construct matrix x'z @
   zy=z'y+zy;                                          @ Construct matrix z'y @
   xx=moment(x,1)+xx;                                  @ Construct matrix x'x @
   if ddd==0; zkz=moment(z,1)+zkz; else;
   ir=1; do while ir<=mul;
   zkz=quad(z[(ir-1)*t1+1:ir*t1,.],z[(ir-1)*t1+1:ir*t1,.],t1)+zkz;
   ir=ir+1; endo; endif;
if t1>=2; y01=tlag(y,0,1,t1); y10=tlag(y,1,0,t1);
          x01=tlag(x,0,1,t1); x10=tlag(x,1,0,t1);
 y1y=y01'y10+y1y; x1x=x01'x10+x1x; y1x=y01'x10+y1x;
 x1y=x01'y10+x1y; clear y10,x10;
 if ddd==0; yky1=moment(y01,1)+yky1; else; yky1=quad(y01,y01,t1-1)+yky1; endif;
 if ddd==0; xkx1=moment(x01,1)+xkx1; else; xkx1=quad(x01,x01,t1-1)+xkx1; endif;
 ykx1=quad(y01,x01,t1-1)+ykx1; clear y01,x01; nc1=nc1+mul;
 zky1=quad(z,app(y,1,t1),t1)+zky1; zkx1=quad(z,app(x,1,t1),t1)+zkx1; endif;
if t1>=3; y02=tlag(y,0,2,t1); y20=tlag(y,2,0,t1);
          x02=tlag(x,0,2,t1); x20=tlag(x,2,0,t1);
 y2y=y02'y20+y2y; x2x=x02'x20+x2x; y2x=y02'x20+y2x;
 x2y=x02'y20+x2y; clear y20,x20;
 if ddd==0; yky2=moment(y02,1)+yky2; else; yky2=quad(y02,y02,t1-2)+yky2; endif;
 if ddd==0; xkx2=moment(x02,1)+xkx2; else; xkx2=quad(x02,x02,t1-2)+xkx2; endif;
 ykx2=quad(y02,x02,t1-2)+ykx2; clear y02,x02; nc2=nc2+mul;
 zky2=quad(z,app(y,2,t1),t1)+zky2; zkx2=quad(z,app(x,2,t1),t1)+zkx2; endif;
   sumx=sumc(x)+sumx; sumy=sumc(y)+sumy; clear y,x,z;
   if idesc==1;                                      @ Descriptive statistics @
   if obs<=n; yxmn=minc(yx)'; yxmx=maxc(yx)'; else;
   yxmn=yxmn|(minc(yx)'); yxmx=yxmx|(maxc(yx)'); endif;
   mom=moment(yx,1)+mom; sumyx=sumc(yx)+sumyx;
   endif; clear yx;
   r=r+1;
endo; xbar=sumx./obs;
if idesc==1;                                         @ Descriptive statistics @
yxbar=sumyx./obs; ybar=yxbar[1,1];
yxmin=minc(yxmn); yxmax=maxc(yxmx);
yxstd=sqrt((diag(mom)-(obs.*yxbar^2))./(obs-1));
ayxstd=sqrt((diag(mom)-(obs.*yxbar^2))./obs);
corr=(mom-(obs.*(yxbar*yxbar')))./(obs.*(ayxstd*ayxstd'));
else; ybar=sumy/obs;
endif;

zx=xz'; inzkz=invpd(zkz); clear zkz;
xmx=xz*inzkz*zx; xmy=xz*inzkz*zy;
inxmx=invpd(xmx); b=inxmx*xmy;               @ Solve for coefficient vector b @

rss=yy+b'xx*b-2.*b'xy; tss=yy-obs*ybar^2;
yhyh=b'xx*b; yhbar=b'xbar; ess=yhyh-obs*yhbar^2;
df=obs-k;                                                @ Degrees of freedom @
s=rss./df;                                 @ Sigma squared from IV regression @

clear xmx; vc=s*inxmx; stderr=sqrt(diag(vc));
trat=b./stderr; pvt=2*cdfnc(abs(trat));
if tmax-lag-1>=3; v2v=y2y+b'x2x*b-y2x*b-b'x2y; v2x=y2x-b'x2x;
vhat2=(yky2+b'xkx2*b-2*ykx2*b-2*v2x*inxmx*xz*inzkz*(zky2-zkx2*b)+
v2x*inxmx*v2x')*s; m2=v2v./sqrt(vhat2); endif;
if tmax-lag-1>=2; v1v=y1y+b'x1x*b-y1x*b-b'x1y; v1x=y1x-b'x1x;
vhat1=(yky1+b'xkx1*b-2*ykx1*b-2*v1x*inxmx*xz*inzkz*(zky1-zkx1*b)+
v1x*inxmx*v1x')*s; m1=v1v./sqrt(vhat1); endif;
uz=zy'-b'xz; if iiv==1; sar=(uz*inzkz*uz')./s; dfs=cinst-k; endif;
if iconst1==1; bc=b[2:kp,1]; vcc=vc[2:kp,2:kp];
else; bc=b[1:kp,1]; vcc=vc[1:kp,1:kp]; endif;
z1=bc'invpd(vcc)*bc; dfz=rows(bc);
if itim1==1; btim=b[kp+1:kd,1]; vctim=vc[kp+1:kd,kp+1:kd]; if idif/=0;
btim=b[1 kp+1:kd,1]; vctim=vc[1 kp+1:kd,1 kp+1:kd]; endif;
z2=btim'invpd(vctim)*btim; dfz2=rows(btim); endif;
if iind1==1; if itim1==1; bind=b[kd+1:k,1]; vcind=vc[kd+1:k,kd+1:k];
else; bind=b[kp+1:k,1]; vcind=vc[kp+1:k,kp+1:k]; endif;
z3=bind'invpd(vcind)*bind; dfz3=rows(bind); endif;
if itim1==1; if iind1==1; bdum=b[kp+1:k,1]; vcdum=vc[kp+1:k,kp+1:k];
if idif/=0; bdum=b[1 kp+1:k,1]; vcdum=vc[1 kp+1:k,1 kp+1:k]; endif;
z4=bdum'invpd(vcdum)*bdum; dfz4=rows(bdum); endif; endif;
if waldtest==1;
if iconst1==1; testcols=testcols+ones(rows(testcols),1); endif;
buser=submat(b,testcols,0); vcuser=submat(vc,testcols,testcols);
nameus=submat(namex,0,testcols);
z5=buser'invpd(vcuser)*buser; dfz5=rows(buser); endif;
xzinzkz=xz*inzkz;
clear inzkz,yky1,xkx1,ykx1,zky1,zkx1,yky2,xkx2,ykx2,zky2,zkx2,imike;
@------------------------- Robust Statistics Option --------------------------@
if icov==1;
ef=seekr(f1,startf1);
clear obs,fms,hh,tt,zkz2,zomv2w,vomv2w,zomv1w,vomv1w;
?; "          *************Reading Data-Second Pass**************"; ?;
r=1;
do while r<=mm;
    gosub defdata;
    u=y-(x*b); t2=tmax-lag-1;
    clear y,x,zt;
    rs=1; do while rs<=mul;
      org=hist[(rs-1)*t+1,1]-year1; nd=org+t1;
      res=u[(rs-1)*t1+1:rs*t1,.]; if org>0;
      ache=zeros(org,nd)|(zeros(t1,org)~res*res');
      tobs=zeros(org,nd)|(zeros(t1,org)~ones(t1,t1));
      else; ache=res*res'; tobs=ones(t1,t1); endif; if (t2-nd)>0;
      ache=ache~zeros(nd,t2-nd)|zeros(t2-nd,t2);
      tobs=tobs~zeros(nd,t2-nd)|zeros(t2-nd,t2); endif;
      hh=hh+ache; tt=tt+tobs; clear ache,tobs;
      zt=z[(rs-1)*t1+1:rs*t1,.]; vv=res*res'; @if ddd==0;
      vv=vv.*eye(rows(res)); endif;@ zkz2=zkz2+zt'vv*zt; if t1>=3;
      u2=u[(rs-1)*t1+1:rs*t1-2,.]; zomv2w=zomv2w+zt'vv*(zeros(2,1)|u2);
      vomv2w=vomv2w+u2'vv[3:rows(vv),3:cols(vv)]*u2; endif; if t1>=2;
      u1=u[(rs-1)*t1+1:rs*t1-1,.]; zomv1w=zomv1w+zt'vv*(zeros(1,1)|u1);
      vomv1w=vomv1w+u1'vv[2:rows(vv),2:cols(vv)]*u1; endif;
    clear u2,zt,res,vv,u1;
    rs=rs+1; endo;
    clear u,z;
r=r+1; endo;
omega=hh./tt;
omega1=omega./sqrt(diag(omega)*diag(omega)');
@----------------- Robust statistics for one-step estimates ------------------@
xax2=xzinzkz*zkz2*xzinzkz'; vc2=inxmx*xax2*inxmx; stderr2=sqrt(diag(vc2));
trat2=b./stderr2; pvt2=2*cdfnc(abs(trat2)); if tmax-lag-1>=3;
vhat2w=vomv2w-(2.*v2x*inxmx*xzinzkz*zomv2w)+(v2x*vc2*v2x');
m2w=v2v./sqrt(vhat2w); endif; if tmax-lag-1>=2;
vhat1w=vomv1w-(2.*v1x*inxmx*xzinzkz*zomv1w)+(v1x*vc2*v1x');
m1w=v1v./sqrt(vhat1w); endif;
@theta=b[2:4,1]; vtheta=vc2[2:4,2:4]; fi=theta[1,1].*theta[3,1]+
theta[2,1]; q=theta[3,1]|ones(1,1)|theta[1,1];
comfac=sqrt((fi^2)./(q'vtheta*q));@
if iconst1==1; vc2c=vc2[2:kp,2:kp];
else; vc2c=vc2[1:kp,1:kp]; endif;
z1w=bc'invpd(vc2c)*bc;
if itim1==1; vc2tim=vc2[kp+1:kd,kp+1:kd]; if idif/=0;
vc2tim=vc2[1 kp+1:kd,1 kp+1:kd]; endif;
z2w=btim'invpd(vc2tim)*btim; endif;
if iind1==1; if itim1==1; vc2ind=vc2[kd+1:k,kd+1:k];
else; vc2ind=vc2[kp+1:k,kp+1:k]; endif;
z3w=bind'invpd(vc2ind)*bind; endif;
if itim1==1; if iind1==1; vc2dum=vc2[kp+1:k,kp+1:k];
if idif/=0; vc2dum=vc2[1 kp+1:k,1 kp+1:k]; endif;
z4w=bdum'invpd(vc2dum)*bdum; endif; endif;
if waldtest==1;
vc2user=submat(vc2,testcols,testcols);
z5w=buser'invpd(vc2user)*buser; endif;
@---------------------------- Two-step estimates -----------------------------@
if cinst>=fms; imike=1; endif;

@imike=1;@

if imike==0; if iiv==1;
inzkz2=invpd(zkz2); clear zkz2;
bxmx=xz*inzkz2*zx; bxmy=xz*inzkz2*zy; bvc=invpd(bxmx);
bb=bvc*bxmy; bstderr=sqrt(diag(bvc)); btrat=bb./bstderr;
bpvt=2*cdfnc(abs(btrat)); if tmax-lag-1>=3;
bv2v=y2y+bb'x2x*bb-y2x*bb-bb'x2y;
bvhat2w=vomv2w-(2.*v2x*bvc*xz*inzkz2*zomv2w)+(v2x*bvc*v2x');
bm2w=bv2v./sqrt(bvhat2w); endif; if tmax-lag-1>=2;
bv1v=y1y+bb'x1x*bb-y1x*bb-bb'x1y;
bvhat1w=vomv1w-(2.*v1x*bvc*xz*inzkz2*zomv1w)+(v1x*bvc*v1x');
bm1w=bv1v./sqrt(bvhat1w); endif;
buz=zy'-bb'xz;
bsar=buz*inzkz2*buz';
if iconst1==1; bbc=bb[2:kp,1]; bvcc=bvc[2:kp,2:kp];
else; bbc=bb[1:kp,1]; bvcc=bvc[1:kp,1:kp]; endif;
bz1=bbc'invpd(bvcc)*bbc;
if itim1==1; bbtim=bb[kp+1:kd,1]; bvctim=bvc[kp+1:kd,kp+1:kd];
if idif/=0; bbtim=bb[1 kp+1:kd,1]; bvctim=bvc[1 kp+1:kd,1 kp+1:kd]; endif;
bz2=bbtim'invpd(bvctim)*bbtim; endif;
if iind1==1; if itim1==1; bbind=bb[kd+1:k,1]; bvcind=bvc[kd+1:k,kd+1:k];
else; bbind=bb[kp+1:k,1]; bvcind=bvc[kp+1:k,kp+1:k]; endif;
bz3=bbind'invpd(bvcind)*bbind; endif;
if itim1==1; if iind1==1; bbdum=bb[kp+1:k,1]; bvcdum=bvc[kp+1:k,kp+1:k];
if idif/=0; bbdum=bb[1 kp+1:k,1]; bvcdum=bvc[1 kp+1:k,1 kp+1:k]; endif;
bz4=bbdum'invpd(bvcdum)*bbdum; endif; endif;
if waldtest==1;
bbuser=submat(bb,testcols,0); bvcuser=submat(bvc,testcols,testcols);
bz5=bbuser'invpd(bvcuser)*bbuser; endif;
endif; endif; endif;
@------------------- End of Option ----- Now Print Results -------------------@
output on; ?;?;?;?; cls;
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++";
?; "                               D.P.D.  RESULTS "; ?;
if idif==0; "LEVELS";; endif;
if idif==1; "FIRST DIFFERENCES";; endif;
if idif==2; "ORTHOGONAL DEVIATIONS";; endif;
if iiv==0; if ich==1; "     IV"; else; "     OLS"; endif; endif;
if iiv==1; "     IV"; endif;
?; format 7,0; "Number of firms:" fms;;
format 4,0; "     Sample period is ";; year1+lag+1;; "to ";; year1+tmax-1;
format 10,0; "Observations:"  obs;; "     Degrees of freedom:" df;
?; "Dependent variable is:";; format /m1 8,8; print $namey[1,1];
if iiv==0; if ich==0; goto one; endif; endif;
?; "Instruments used are:";
print $namez; one: ?;
"----------------------------------------------------------------------------";
?; "ONE-STEP ESTIMATES";
?; format 14,6;  "RSS =" rss;;"          TSS =" tss;
"Estimated sigma-squared (levels)  =";; if idif==1; 0.5*s; else; s; endif; ?;
"   Wald test of joint significance:  " z1;; format 4,0; "   df =" dfz;
if itim1==1; format 14,6;
"   Wald test - jt sig of time dums:  " z2;; format 4,0; "   df =" dfz2;
endif; if iind1==1; format 14,6;
"   Wald test - jt sig of  ind dums:  " z3;; format 4,0; "   df =" dfz3;
endif; if itim1==1; if iind1==1; format 14,6;
"   Wald test - jt sig of both dums:  " z4;; format 4,0; "   df =" dfz4;
endif; endif; if waldtest==1; format 14,6;
"        Wald test selected by user:  " z5;; format 4,0; "   df =" dfz5;
"   Testing:";; format 8,8; print $nameus;
endif; format 14,6; if iiv==1;
"                       Sargan test:  " sar;; format 4,0; "   df =" dfs;
endif;
?;"Var             Coef         Std. Error       T-Stat         P-Value";
i=1; do until i>k;
if i<=kp; format /m1 8,8; print $namex[1,i];;
else; if itim1==1; if i<=kd;  "     D";; format 2,0; ssd[i-kp+1,1];;
                   else; "      I";; format 1,0; dv1[i-kd+1,1];; endif;
      else; "      I";; format 1,0; dv1[i-kp+1,1];; endif; endif;
format 14,6; b[i,1];; stderr[i,1];; trat[i,1];; /rd pvt[i,1];
i=i+1; endo; ?;
"NOTE: Standard errors and test statistics not robust to heteroskedasticity";
if tmax-lag-1>=2; ?;format 10,3;
"Test for  first-order serial correlation:";; m1;; " [";; format 5,0; nc1;;
"]"; endif; if tmax-lag-1>=3; format 10,3;
"Test for second-order serial correlation:";; m2;; " [";; format 5,0; nc2;;
"]"; endif; if icov==1; ?;
"----------------------------------------------------------------------------";
?; "ONE-STEP ESTIMATES WITH ROBUST TEST STATISTICS"; ?; format 14,6;
"   Wald test of joint significance:  " z1w;; format 4,0; "   df =" dfz;
if itim1==1; format 14,6;
"   Wald test - jt sig of time dums:  " z2w;; format 4,0; "   df =" dfz2;
endif; if iind1==1; format 14,6;
"   Wald test - jt sig of  ind dums:  " z3w;; format 4,0; "   df =" dfz3;
endif; if itim1==1; if iind1==1; format 14,6;
"   Wald test - jt sig of both dums:  " z4w;; format 4,0; "   df =" dfz4;
endif; endif; if waldtest==1; format 14,6;
"        Wald test selected by user:  " z5w;; format 4,0; "   df =" dfz5;
"   Testing:";; format 8,8; print $nameus;
endif;
?;"Var             Coef         Std. Error       T-Stat         P-Value";
i=1; do until i>k;
if i<=kp; format /m1 8,8; print $namex[1,i];;
else; if itim1==1; if i<=kd;  "     D";; format 2,0; ssd[i-kp+1,1];;
                   else; "      I";; format 1,0; dv1[i-kd+1,1];; endif;
      else; "      I";; format 1,0; dv1[i-kp+1,1];; endif; endif;
format 14,6; b[i,1];; stderr2[i,1];; trat2[i,1];; /rd pvt2[i,1];
i=i+1; endo; if idif==2; ?;
"NOTE: Standard errors and test statistics not robust to heteroskedasticity
      over time"; endif; if tmax-lag-1>=2; ?; format 10,3;
"Robust test for  first-order serial correlation:";; m1w;; " [";; format 5,0;
nc1;; "]"; endif; if tmax-lag-1>=3; format 10,3;
"Robust test for second-order serial correlation:";; m2w;; " [";; format 5,0;
nc2;; "]";  endif; ?; "           Estimated serial correlation matrix"; ?;
i=1; do while i<=cols(omega1); j=1; do while j<=i; format 6,3;
if j==i; omega1[j,i]; else; omega1[j,i];; endif;
j=j+1; endo; i=i+1; endo;
?; "   Number of observations available to sample covariances"; ?;
i=1; do while i<=cols(tt); j=1; do while j<=i; format 6,0;
if j==i; tt[j,i]; else; tt[j,i];; endif;
j=j+1; endo; i=i+1; endo; if iiv==1; ?;
if imike==1; "***UNABLE TO COMPUTE TWO-STEP ESTIMATES***";
"***NUMBER OF INSTRUMENTS EXCEEDS NUMBER OF UNITS***"; else;
"----------------------------------------------------------------------------";
?; "TWO-STEP ESTIMATES"; ?; format 14,6;
"   Wald test of joint significance:  " bz1;; format 4,0; "   df =" dfz;
if itim1==1; format 14,6;
"   Wald test - jt sig of time dums:  " bz2;; format 4,0; "   df =" dfz2;
endif; if iind1==1; format 14,6;
"   Wald test - jt sig of  ind dums:  " bz3;; format 4,0; "   df =" dfz3;
endif; if itim1==1; if iind1==1; format 14,6;
"   Wald test - jt sig of both dums:  " bz4;; format 4,0; "   df =" dfz4;
endif; endif; if waldtest==1; format 14,6;
"        Wald test selected by user:  " bz5;; format 4,0; "   df =" dfz5;
"   Testing:";; format 8,8; print $nameus;
endif; format 14,6;
"                       Sargan test:  " bsar;; format 4,0; "   df =" dfs;
?;"Var             Coef         Std. Error       T-Stat         P-Value";
i=1; do until i>k;
if i<=kp; format /m1 8,8; print $namex[1,i];;
else; if itim1==1; if i<=kd;  "     D";; format 2,0; ssd[i-kp+1,1];;
                   else; "      I";; format 1,0; dv1[i-kd+1,1];; endif;
      else; "      I";; format 1,0; dv1[i-kp+1,1];; endif; endif;
format 14,6; bb[i,1];; bstderr[i,1];; btrat[i,1];; /rd bpvt[i,1];
i=i+1; endo; if idif==2; ?;
"NOTE: Standard errors and test statistics not robust to heteroskedasticity
      over time"; endif; if tmax-lag-1>=2; ?; format 10,3;
"Robust test for  first-order serial correlation:";; bm1w;; " [";; format 5,0;
nc1;; "]"; endif;  if tmax-lag-1>=3; format 10,3;
"Robust test for second-order serial correlation:";; bm2w;; " [";; format 5,0;
nc2;; "]"; endif; endif; else; if ich==1; ?;?;
"Model just identified - two-step estimates and one-step estimates coincide";
else; ?;?;
"OLS estimation - two-step estimates and one-step estimates coincide";
endif; endif; endif;
if idesc==1; ?;?;
"----------------------------------------------------------------------------";
?; "DESCRIPTIVE STATISTICS"; ?;
"Variable       Mean   Std Dev       Min       Max"; ?;
format /m1 10,8; print $namey[1,1];;
format 10,5; ybar;; yxstd[1,1];; yxmin[1,1];; yxmax[1,1];
i=1; do while i<=kk-1;
format /m1 10,8; print $nameyx[1,i];;
format 10,5; yxbar[i+1,1];; yxstd[i+1,1];; yxmin[i+1,1];; yxmax[i+1,1];
i=i+1; endo;
?; "Correlation Matrix"; ?; outwidth 252;
format /m1 /rd 8,8; print $namey[1,1];;
i=1; do while i<=kk-1; format 8,8; print $nameyx[1,i];;
i=i+1; endo; ?; format /m1 8,2;
i=1; do while i<=kk; j=1; do while j<=i; if j==i; corr[j,i];
else; corr[j,i];; endif; j=j+1; endo; i=i+1; endo; outwidth 80;
endif;
if ipar==1; outwidth 252; ?;?; vc=vc.*100000;
"----------------------------------------------------------------------------";
?; "ASYMPTOTIC VARIANCE MATRICES";
?; "Non-robust AVM of one-step estimates (x100000)"; ?;
i=1; do until i>k; if i<=kp; format /m1 8,8;
if i==k; print $namex[1,i]; else; print $namex[1,i];; endif;
else; if itim1==1; if i<=kd; format 2,0; if i==k; "     D";; ssd[i-kp+1,1];
                             else; "     D";; ssd[i-kp+1,1];; endif;
                   else; format 1,0; if i==k; "      I";; dv1[i-kd,1];
                         else; "      I";; dv1[i-kd,1];; endif; endif;
      else; format 1,0; if i==k; "      I";; dv1[i-kp+1,1];
            else; "      I";; dv1[i-kp+1,1];; endif;
      endif;
endif; i=i+1; endo;
i=1; do while i<=cols(vc); j=1; do while j<=i; format 8,3;
if j==i; vc[j,i]; else; vc[j,i];; endif;
j=j+1; endo; i=i+1; endo;
if icov==1; vc2=vc2.*100000;
?; "Robust AVM of one-step estimates (x100000)"; ?;
i=1; do until i>k; if i<=kp; format /m1 8,8;
if i==k; print $namex[1,i]; else; print $namex[1,i];; endif;
else; if itim1==1; if i<=kd; format 2,0; if i==k; "     D";; ssd[i-kp+1,1];
                             else; "     D";; ssd[i-kp+1,1];; endif;
                   else; format 1,0; if i==k; "      I";; dv1[i-kd+1,1];
                         else; "      I";; dv1[i-kd+1,1];; endif; endif;
      else; format 1,0; if i==k; "      I";; dv1[i-kp+1,1];
            else; "      I";; dv1[i-kp+1,1];; endif;
      endif;
endif; i=i+1; endo;
i=1; do while i<=cols(vc2); j=1; do while j<=i; format 8,3;
if j==i; vc2[j,i]; else; vc2[j,i];; endif;
j=j+1; endo; i=i+1; endo; if iiv==1; if imike==0; bvc=bvc.*100000;
?; "Robust AVM of two-step estimates (x100000)"; ?;
i=1; do until i>k; if i<=kp; format /m1 8,8;
if i==k; print $namex[1,i]; else; print $namex[1,i];; endif;
else; if itim1==1; if i<=kd; format 2,0; if i==k; "     D";; ssd[i-kp+1,1];
                             else; "     D";; ssd[i-kp+1,1];; endif;
                   else; format 1,0; if i==k; "      I";; dv1[i-kd+1,1];
                         else; "      I";; dv1[i-kd+1,1];; endif; endif;
      else; format 1,0; if i==k; "      I";; dv1[i-kp+1,1];
            else; "      I";; dv1[i-kp+1,1];; endif;
      endif;
endif; i=i+1; endo;
i=1; do while i<=cols(bvc); j=1; do while j<=i; format 8,3;
if j==i; bvc[j,i]; else; bvc[j,i];; endif;
j=j+1; endo; i=i+1; endo;
endif; endif; endif; endif;
?;?; format 10,3; outwidth 80;
"  Execution time is ";; cts=hsec-speed; cts=cts/100;
cts;;" seconds ";
@------------------------------ End of program -------------------------------@
@?; "  Comfac test on robust one-step estimates =";; format 12,8; comfac;@
@rssb=yy+bb'xx*bb-2.*bb'xy; sb=rssb./df; "two-step sigma squared = ";;
format 12,6; sb;@

