// dynareestimateCshort.mod

var lc, lk, lz, ly;
varexo e;

parameters beta, rho, alpha, nu, delta;

model;
exp(-nu*lc)=beta*(exp(-nu*lc(+1)))*(exp(lz(+1))*alpha*exp((alpha-1)*lk)+1-delta);
exp(lc)+exp(lk) =exp(lz+alpha*lk(-1))+(1-delta)*exp(lk(-1));
ly = lz+alpha*lk(-1);
lz = rho*lz(-1)+e;
end;

initval;
lc = -1.02;
lk = -1.61;
ly = -0.36*1.61;
lz = 0;
end;

rho   = 0.95;
beta  = 0.99;
nu    = 1;
delta = 0.025;

varobs lc;

estimated_params;
alpha   , beta_pdf, 0.42, 0.10;
stderr e, inv_gamma_pdf, 0.010, inf;
end;

estimation(datafile=cdata,nobs=400,mh_nblocks=2,mh_replic=2500,mh_jscale=2.7,mh_init_scale=12) lc;

