// dynaresolve.mod

var c, k, z;
varexo e;

parameters beta, rho, alpha, nu, delta, sig;

load parameterfile;
set_param_value('alpha',alpha)
set_param_value('rho',rho)
set_param_value('beta',beta)
set_param_value('nu',nu)
set_param_value('sig',sig)
set_param_value('delta',delta)


model;
exp(-nu*c)=beta*(exp(-nu*c(+1)))*(exp(z(+1))*alpha*exp((alpha-1)*k)+1-delta);
exp(c)+exp(k)=exp(z+alpha*k(-1))+(1-delta)*exp(k(-1));
z = rho*z(-1)+e;
end;

initval;
c = -1.02;
k = -1.61;
z = 0;
end;

shocks;
var e; stderr sig;
end;

stoch_simul(order=1,nocorr,nomoments,IRF=0) k z c;