% generatedata.m
%
% this program generates data with the solution for modelc
%
% !!!! running this program requires the updated version of disp_dr.m
% (which writes the policy functions to the matrix decision, exactly
% the way you see it on the screen). Alternatively, you can upload them
% from the files created by Dynare, but I find this easier especially for
% second-order
%

alpha = 0.36;
beta  = 0.99;
delta = 0.025;
rho   = 0.95;
sig    = 0.007;
nu = 1;
merrorc = 0.00;
merrork = 0.00;
merrory = 0.00;

save parameterfile nu alpha rho beta sig delta 

% note that the measurement errors are not needed to solve the model

%indicate which column of decision corresponds with which variable
%note that for each application you have to check that these column
%indications are correct. Here the labels are the same for each program

iiicap=1;
iiicons=3;

%this saves parameter values into parameterfile.mat

dynare dynaresolve noclearall
load dynarerocks;    % this loads the dynare solutions exactly as they are written on the screen
ddd = decision;

%
% Output generated by Dynare and stored in dynarerocks 
% (if alternative disp_dr.m is used)
%

randn('state', 20080303);

% ordering of the variables

pertk   = 1;
pertz   = 2;
pertc   = 3;

k_ss = (beta*alpha/(1-beta*(1-delta)))^(1/(1-alpha));

% Simulation

T  = 1000; % length of usuable simulation
Tb = 5001;   % first observation used 
Te = T+Tb-1;

    lk     = zeros(Te,1);
    lc     = zeros(Te,1);
    y      = zeros(T,1);    
    lz     = zeros(Te,1);   % log productivity
    e      = sig*randn(Te,1);
    state  = ones(4,1);

    for t = 2:Te        
        lz(t) = rho*lz(t-1) + e(t);    
    end

    z = exp(lz);

    lk(1) = log(k_ss);

    for t = 2:Te
    state(2) = lk(t-1)-log(k_ss);
    state(3) = lz(t-1);
    state(4) = e(t);
    lk(t)    = ddd(:,pertk)'*state;
    lc(t)    = ddd(:,pertc)'*state;
    end

    ly = lz(Tb:Te)+alpha*lk(Tb-1:Te-1)+merrory*randn(T,1);
    lk = lk(Tb:Te)+merrork*randn(T,1);
    lc = lc(Tb:Te)+merrorc*randn(T,1);

%    plot(lk(1:100))
    
    save ydata ly 
    save kdata lk 
    save cdata lc 
    save zdata lz
    save zckydata lz lc lk ly
    