// dynareestimateA.mod

var lc, lk, lz, ly;
varexo e;

parameters beta, rho, alpha, nu, delta;

model;
exp(-nu*lc)=beta*(exp(-nu*lc(+1)))*(exp(lz(+1))*alpha*exp((alpha-1)*lk)+1-delta);
exp(lc)+exp(lk) =exp(lz+alpha*lk(-1))+(1-delta)*exp(lk(-1));
ly = lz+alpha*lk(-1);
lz = rho*lz(-1)+e;
end;

initval;
lc = -1.02;
lk = -1.61;
ly = -0.36*1.61;
lz = 0;
end;

alpha = 0.36;
rho   = 0.95;
beta  = 0.99;
nu    = 1;
delta = 0.025;

varobs lc;

estimated_params;
stderr e, inv_gamma_pdf, 0.007, inf;
end;

estimation(datafile=cdata,mh_nblocks=5,mh_replic=10000,mh_jscale=3,mh_init_scale=12) lc;

