// dynareestimateB.mod

var lc, lk, lz, ly;
varexo e;

parameters beta, rho, alpha, nu, delta;

alpha = 0.36;
beta = 0.99;
delta = 0.025;
rho = 0.95;
nu = 1;

model;
exp(-nu*lc)=beta*(exp(-nu*lc(+1)))*(exp(lz(+1))*alpha*exp((alpha-1)*lk)+1-delta);
exp(lc)+exp(lk) =exp(lz+alpha*lk(-1))+(1-delta)*exp(lk(-1));
ly = lz+alpha*lk(-1);
lz = rho*lz(-1)+e;
end;

initval;
lc = -1.02;
lk = -1.61;
ly = -0.36*1.61;
lz = 0;
end;

varobs lc;

estimated_params;
alpha   , beta_pdf, 0.36, 0.025;
beta    , beta_pdf, 0.99, 0.003;
delta   , beta_pdf, 0.025, 0.01;
rho     , beta_pdf, 0.95, 0.025;
nu      , gamma_pdf, 1, 0.25;
stderr e, inv_gamma_pdf, 0.007, inf;
end;

estimation(datafile=cdata,solve_algo=3,mh_nblocks=5,mh_replic=10000,mh_jscale=0.4,mh_init_scale=1.6) lc;

