%% ========================================================================
% main2.m
%
% Author: Joris de Wind (de_wind_joris@hotmail.com)
% Date:   March 11, 2009
%
% With thanks to Michel Juillard for showing how to do this
%==========================================================================

%% ========================================================================
% General idea:
%
% This program creates a Dynare++ source file called 
% standard_growth_model_total.mod 
% and from within this Matlab file you can set
% (i) the parameter of risk aversion nu
% (ii) the standard deviation of the shock
% (iii) the order of the approximation
% (iv)  the number of observations in the simulations
%
% As two examples it loops over the perturbation order for two values of 
% nu and plots the simulated consumption series
%
% Of course, it is easy to modify this program and make more stuff
% adjustable
%
% There are four parts to the Dynare++ source file that is created. 
% The two parts that never change are 
%
% standard_growth_model_block_begin.mod and
% standard_growth_model_block_end.mod
%
% This Matlab file puts the line that defines the riskaversion parameter
% in between these two blocks and puts the line that defines the amount of
% uncertainty after the standard_growth_model_block_end.mod block.
% All four parts are combined. 
%
% This Matlab file calls the Dynare++ program that solves the model and the
% Dynare++ simulation program that simulates the series. The simulated
% series are stored in a matrix sim
%
%% ========================================================================
% 1.   Section the user has to edit to set
% i)   Risk-aversion
% ii)  variance shocks
% iii) perturbation-order
% iv)  number of periods for the simulation
% v)   directory in which Dynare++ is located
%==========================================================================

nu      = 1        ;        %risk-aversion
vcov    = 0.007^2  ;        %variance
order   = 1        ;        %pertubation-order
T       = 2000     ;        %number of periods
mydynareppdirectory = sprintf('c:\\dynarepp'); 
%specify here the location of Dynare++

%% ========================================================================
% 2. Preparing the standard_growth_model_total.mod file
%==========================================================================

delete standard_growth_model_total.mod                                      
%Otherwise the new stuff keeps on getting appended to old stuff.
!type standard_growth_model_block_begin.mod >> standard_growth_model_total.mod;
%this puts the *_begin.mod file into *_total.mod
temp = sprintf('echo nu    = %d; >> standard_growth_model_total.mod',nu);
system(temp);
%this creates a line that sets the value of nu and adds it to *_total.mod
!type standard_growth_model_block_end.mod >> standard_growth_model_total.mod;
%this puts the *_end.mod file into *_total.mod
temp = sprintf('echo vcov = [%d]; >> standard_growth_model_total.mod',vcov);
system(temp);
%this creates a line that sets the value of vcov and adds it to *_total.mod

%% ========================================================================
% 3. Running Dynare++
%==========================================================================

temp = sprintf('%s\\dynare++ --order %i standard_growth_model_total.mod',...
    mydynareppdirectory,order);
system(temp);

delete standard_growth_model_total.jnl
delete standard_growth_model_total_f.m
delete standard_growth_model_total_ff.m
delete standard_growth_model_total.dump

%% ========================================================================
% 4. Simulation
%==========================================================================

randn('state',20090314);                                  
e = sqrt(vcov)*randn(1,T);
sim = dynare_simul('standard_growth_model_total.mat',e);