%% ========================================================================
% main2loop.m
%
% Author: Joris de Wind (de_wind_joris@hotmail.com)
% Date:   March 11, 2009
%
% With thanks to Michel Juillard for showing how to do this
%==========================================================================

%% ========================================================================
% General idea:
%
% This program uses the tricks of main2.m but now loops over two different
% values of risk aversion (low and high) and different perturbation orders
%
% Which perturbation order you can reach depends on your computer
%
%% ========================================================================
% 1.   Section the user has to edit to set
% i)   Risk-aversion
% ii)  variance shocks
% iii) perturbation-order
% iv)  number of periods for the simulation
% v)   directory in which Dynare++ is located
%==========================================================================

vcov    = 0.05^2  ;        %variance
T       = 100     ;        %number of periods
mydynareppdirectory = sprintf('c:\\dynarepp'); 
%specify here the location of Dynare++
iordermax = 8;
consstore = zeros(T,iordermax,2);

for iorder = 1:iordermax
    iorder
    for inu = 1:2
        if inu==1
            nu = 1;
        else
            nu = 5;
        end

 
%% ========================================================================
% 2. Preparing the standard_growth_model_total.mod file
%==========================================================================

delete standard_growth_model_total.mod                                      
%Otherwise the new stuff keeps on getting appended to old stuff.
!type standard_growth_model_block_begin.mod >> standard_growth_model_total.mod;
%this puts the *_begin.mod file into *_total.mod
temp = sprintf('echo nu    = %d; >> standard_growth_model_total.mod',nu);
system(temp);
%this creates a line that sets the value of nu and adds it to *_total.mod
!type standard_growth_model_block_end.mod >> standard_growth_model_total.mod;
%this puts the *_end.mod file into *_total.mod
temp = sprintf('echo vcov = [%d]; >> standard_growth_model_total.mod',vcov);
system(temp);
%this creates a line that sets the value of vcov and adds it to *_total.mod

%% ========================================================================
% 3. Running Dynare++
%==========================================================================

temp = sprintf('%s\\dynare++ --order %i standard_growth_model_total.mod',...
    mydynareppdirectory,iorder);
system(temp);

delete standard_growth_model_total.jnl
delete standard_growth_model_total_f.m
delete standard_growth_model_total_ff.m
delete standard_growth_model_total.dump

%% ========================================================================
% 4. Simulation
%==========================================================================

randn('state',20090314);                                  
e = sqrt(vcov)*randn(1,T);
sim = dynare_simul('standard_growth_model_total.mat',e);

consstore(:,iorder,inu)=sim(3,:)';
    end

    
figure(1)
if iorder>1
    plot(consstore(:,1:iorder-1,1))
    hold on
    plot(consstore(:,iorder,1),'linewidth',2.2,'color',[0 0 0])
    title(['temporary graph for low risk aversion, order:',num2str(iorder)],'fontsize',10)
    xlabel('black (blue) is highest (1st) order solution')
    hold off
    if iorder==iordermax
        figure(3)
    plot(consstore(:,1:iorder-1,1))
    hold on
    plot(consstore(:,iorder,1),'linewidth',2.2,'color',[0 0 0])
    title(['final graph for low risk aversion, order:',num2str(iorder)],'fontsize',10)
    xlabel('black (blue) is highest (1st) order solution')
    hold off
    end
end
figure(2)
if iorder>1
    plot(consstore(:,1:iorder-1,2))
    hold on
    plot(consstore(:,iorder,2),'linewidth',2.2,'color',[0 0 0])
    title(['temporary graph for high risk aversion, order:',num2str(iorder)],'fontsize',10)
    xlabel('black (blue) is highest (1st) order solution')
    hold off
    if iorder==iordermax
        figure(4)
    plot(consstore(:,1:iorder-1,2))
    hold on
    plot(consstore(:,iorder,2),'linewidth',2.2,'color',[0 0 0])
    title(['final graph for high risk aversion, order:',num2str(iorder)],'fontsize',10)
    xlabel('black (blue) is highest (1st) order solution')
    hold off
    end
end

end