%% ========================================================================
% main2loopvariance.m
%
% Author: Joris de Wind (de_wind_joris@hotmail.com)
% Date:   March 11, 2009
%
% With thanks to Michel Juillard for showing how to do this
%==========================================================================

%% ========================================================================
% General idea:
%
% This program uses the tricks of main2.m but now loops over two different
% values of the standard deviation (low and high) 
% and different perturbation orders
%
% The interesting thing about this example is that the second-order
% solution pushes the consumption value up considerably, but the
% third-order solution pushes it back down again and higher-order solutions
% even push it BELOW the first-order solution. That is, to understand the
% effect of uncertainty on the mean consumption level you have to go beyond
% a third-order approximation.
%
% For capital, one does find that the simulated value of
% higher-order solution is always above the average of the first-order
% solution, but consistent with the findings for consumption, the capital
% values are highest for the second-order solution
%
% Which perturbation order you can reach depends on your computer
%
%% ========================================================================
% 1.   Section the user has to edit to set
% i)   Risk-aversion
% ii)  variance shocks
% iii) perturbation-order
% iv)  number of periods for the simulation
% v)   directory in which Dynare++ is located
%==========================================================================

nu      = 5;
vcovlow  = 0.007^2;
vcovhigh = 0.07^2;
T       = 100     ;        %number of periods
mydynareppdirectory = sprintf('c:\\dynarepp'); 
%specify here the location of Dynare++
iordermax = 5;
consstore = zeros(T,iordermax,2);

for iorder = 1:iordermax
    iorder
    for ivar = 1:2
        if ivar==1
            vcov = vcovlow;
        else
            vcov = vcovhigh;
        end
 
%% ========================================================================
% 2. Preparing the standard_growth_model_total.mod file
%==========================================================================

delete standard_growth_model_total.mod                                      
%Otherwise the new stuff keeps on getting appended to old stuff.
!type standard_growth_model_block_begin.mod >> standard_growth_model_total.mod;
%this puts the *_begin.mod file into *_total.mod
temp = sprintf('echo nu    = %d; >> standard_growth_model_total.mod',nu);
system(temp);
%this creates a line that sets the value of nu and adds it to *_total.mod
!type standard_growth_model_block_end.mod >> standard_growth_model_total.mod;
%this puts the *_end.mod file into *_total.mod
temp = sprintf('echo vcov = [%d]; >> standard_growth_model_total.mod',vcov);
system(temp);
%this creates a line that sets the value of vcov and adds it to *_total.mod

%% ========================================================================
% 3. Running Dynare++
%==========================================================================

temp = sprintf('%s\\dynare++ --order %i standard_growth_model_total.mod',...
    mydynareppdirectory,iorder);
system(temp);

delete standard_growth_model_total.jnl
delete standard_growth_model_total_f.m
delete standard_growth_model_total_ff.m
delete standard_growth_model_total.dump

%% ========================================================================
% 4. Simulation
%==========================================================================

randn('state',20090314);                                  
e = sqrt(0.000001)*randn(1,T);
sim = dynare_simul('standard_growth_model_total.mat',e);

consstore(:,iorder,ivar)=sim(3,:)';
    end

    
figure
    plot(consstore(:,iorder,1),'linewidth',2.2,'color','b')
    hold on
    plot(consstore(:,iorder,2),'linewidth',2.2,'color',[0 0 0])
    legend('first-order solution for low & high uncertainty', ...
        'highest-order solution for high uncertainty', ...
        'location','southoutside')
    hold on
    if iorder > 1
    plot(consstore(:,1:iorder-1,2))
    end
    title(['consumption for low and high uncertainty policy rule - up to order:',num2str(iorder)],'fontsize',10)
    hold off
end