// modelcloglinear2.mod
// standard growth model
// variables are the log of consumption, the log of capital, and the log of productivity
// Dynare generates a law of motion that is linear in these variables (since order = 1)
//
// identical to modelcloglinear.mod but this file reads in all parameter values
//
 
var lnc, lnk, lnz;
varexo e;

parameters beta, rho, alpha, nu, delta, sig;

load parameterfile;
set_param_value('alpha',alpha)
set_param_value('rho',rho)
set_param_value('beta',beta)
set_param_value('nu',nu)
set_param_value('sig',sig)
set_param_value('delta',delta)

model;
exp(-nu*lnc)=beta*(exp(-nu*lnc(+1)))*(exp(lnz(+1))*alpha*exp((alpha-1)*lnk)+1-delta);
exp(lnc)+exp(lnk)=exp(lnz+alpha*lnk(-1))+(1-delta)*exp(lnk(-1));
lnz = rho*lnz(-1)+e;
end;

initval;
lnk = log(6.366837);
lnc = log(1.310525);
lnz = 0;
end;

shocks;
var e; stderr sig;
end;

stoch_simul(order=1,nocorr,nomoments,IRF=0) lnk lnz lnc;