// modelblevel2ndorder.mod
// standard growth model
// variables are the level of consumption, the level of capital, and the log of productivity
// Dynare generates a law of motion that is 2nd-order in these variables (since order = 2)
 
var c, k, lnz;
varexo e;

parameters beta, rho, alpha, nu, delta, sig;

alpha = 0.36;
rho   = 0.95;
beta  = 0.99;
load nuparam;
set_param_value('nu',nu)
load sigparam;
set_param_value('sig',sig)
delta = 0.10;

model;
c^(-nu)=beta*c(+1)^(-nu)*(exp(lnz(+1))*alpha*k^(alpha-1)+1-delta);
c+k=exp(lnz)*k(-1)^alpha+(1-delta)*k(-1);
lnz = rho*lnz(-1)+e;
end;

initval;
k = 6.366837;
c = 1.310525;
lnz = 0;
end;

shocks;
var e; stderr sig;
end;

stoch_simul(order=2,nocorr,nomoments,IRF=0) k lnz c;