% simul.m
% Wouter den Haan (UvA); this program was written quickly and there is no
% guarantee that it is free of errors
%
% this program solves the standard growth model in four different ways:
% in levels (1st & 2nd order) and in loglevels (1st & 2nd order). 
%
% for each solution it simulates capital and consumption levels and stores
% them in a matrix and finally plots them
%
% !!!! running this program requires the updated version of disp_dr.m
% (which writes the policy functions to the matrix decision, exactly
% the way you see it on the screen). Alternatively, you can upload them
% from the files created by Dynare, but I find this easier especially for
% second-order

%
%=========================================================================
%
%Exercise: play around with the values for nu & sig and check when the
%four numerical solution differ substantially from each other
%
%=========================================================================

nu  = 3; % this parameter is read in the Dynare source files
sig = 0.007; % this parameter is read in the Dynare source files
save nuparam nu;
save sigparam sig;


T=1000;
capstore=zeros(T,4);
constore=zeros(T,4);

%the policy functions generated by Dynare will be stored in a matrix 
%called decision; each column contains the coefficients for a variable
%
%indicate which column of "decision" corresponds with which variable
%note that for each application you have to check that these column
%indications are correct. 
%

iiicap=1;
iiicons=3;

%initialize stuff
%this is the same for each numerical solution

cap    = zeros(T,1);
con    = zeros(T,1);
prod   = zeros(T,1);	
randn('state',20080701);
shocks = sig*randn(T,1); 
prod(1)= 0;

dynare modelblevel noclearall

% the command noclearall means that variables defined earlier (like T) are not
% deleted out of memory

load dynarerocks

% this loads the matrix "decision" with coefficients into memory
% this requires the updated disp_dr.m file (of course you can also use the
% coefficients stored by Dynare but for second-order I find this easier.

capstst = decision(1,iiicap); 	
cap(1)  = capstst; % initial value is steady state level
for t = 2:T	
prod(t)=rho*prod(t-1)+shocks(t);
cap(t) =decision(1,iiicap)+decision(2,iiicap)*(cap(t-1)-capstst) ...	
           +decision(3,iiicap)*prod(t-1) + decision(4,iiicap)*shocks(t);
con(t) =decision(1,iiicons)+decision(2,iiicons)*(cap(t-1)-capstst) ...	
           +decision(3,iiicons)*prod(t-1) + decision(4,iiicons)*shocks(t);
end	

capstore(:,1)=cap;
constore(:,1)=con;

dynare modelcloglinear noclearall
% now we get a policy rule for the LOG of capital and the LOG of consumption
% note that productivity is always in logs
load dynarerocks
% this loads the matrix "decision" with coefficients into memory

capstst = decision(1,iiicap); 	
cap(1)  = capstst; % initial value is steady state level
for t = 2:T	
prod(t)=rho*prod(t-1)+shocks(t);
cap(t) =decision(1,iiicap)+decision(2,iiicap)*(cap(t-1)-capstst) ...	
           +decision(3,iiicap)*prod(t-1) + decision(4,iiicap)*shocks(t);
con(t) =decision(1,iiicons)+decision(2,iiicons)*(cap(t-1)-capstst) ...	
           +decision(3,iiicons)*prod(t-1) + decision(4,iiicons)*shocks(t);
end	

capstore(:,2)=exp(cap);
constore(:,2)=exp(con);
% since this solution is generating logs I have to exp it to get the level

dynare modelblevel2ndorder noclearall
% the command noclearall means that variables defined here (like T) are not
% deleted out of memory
load dynarerocks
% this loads the matrix "decision" with coefficients into memory

capstst = decision(1,iiicap)-decision(2,iiicap); %recall that second coef gives correction from st.state 	
cap(1)  = capstst; % initial value is steady state level
for t = 2:T	
prod(t)=rho*prod(t-1)+shocks(t);
cap(t)=decision(1,iiicap) ...
      +decision(3,iiicap)*(cap(t-1)-capstst) ...
      +decision(4,iiicap)*prod(t-1) ...
      +decision(5,iiicap)*shocks(t) ...
      +decision(6,iiicap)*(cap(t-1)-capstst)^2 ...
      +decision(7,iiicap)*(cap(t-1)-capstst)*prod(t-1) ...
      +decision(8,iiicap)*prod(t-1)^2 ...
      +decision(9,iiicap)*shocks(t)^2 ...
      +decision(10,iiicap)*(cap(t-1)-capstst)*shocks(t) ...
      +decision(11,iiicap)*prod(t-1)*shocks(t);
con(t)=decision( 1,iiicons) ...
      +decision( 3,iiicons)*(cap(t-1)-capstst) ...
      +decision( 4,iiicons)*prod(t-1) ...
      +decision( 5,iiicons)*shocks(t) ...
      +decision( 6,iiicons)*(cap(t-1)-capstst)^2 ...
      +decision( 7,iiicons)*(cap(t-1)-capstst)*prod(t-1) ...
      +decision( 8,iiicons)*prod(t-1)^2 ...
      +decision( 9,iiicons)*shocks(t)^2 ...
      +decision(10,iiicons)*(cap(t-1)-capstst)*shocks(t) ...
      +decision(11,iiicons)*prod(t-1)*shocks(t);
end	

capstore(:,3)=cap;
constore(:,3)=con;

dynare modelclog2ndorder noclearall
% the command noclearall means that variables defined here (like T) are not
% deleted out of memory
load dynarerocks
% this loads the matrix "decision" with coefficients into memory

capstst = decision(1,iiicap)-decision(2,iiicap); %recall that second coef gives correction from st.state 	
cap(1)  = capstst; % initial value is steady state level
for t = 2:T	
prod(t)=rho*prod(t-1)+shocks(t);
cap(t)=decision(1,iiicap) ...
      +decision(3,iiicap)*(cap(t-1)-capstst) ...
      +decision(4,iiicap)*prod(t-1) ...
      +decision(5,iiicap)*shocks(t) ...
      +decision(6,iiicap)*(cap(t-1)-capstst)^2 ...
      +decision(7,iiicap)*(cap(t-1)-capstst)*prod(t-1) ...
      +decision(8,iiicap)*prod(t-1)^2 ...
      +decision(9,iiicap)*shocks(t)^2 ...
      +decision(10,iiicap)*(cap(t-1)-capstst)*shocks(t) ...
      +decision(11,iiicap)*prod(t-1)*shocks(t);
con(t)=decision( 1,iiicons) ...
      +decision( 3,iiicons)*(cap(t-1)-capstst) ...
      +decision( 4,iiicons)*prod(t-1) ...
      +decision( 5,iiicons)*shocks(t) ...
      +decision( 6,iiicons)*(cap(t-1)-capstst)^2 ...
      +decision( 7,iiicons)*(cap(t-1)-capstst)*prod(t-1) ...
      +decision( 8,iiicons)*prod(t-1)^2 ...
      +decision( 9,iiicons)*shocks(t)^2 ...
      +decision(10,iiicons)*(cap(t-1)-capstst)*shocks(t) ...
      +decision(11,iiicons)*prod(t-1)*shocks(t);
end	

capstore(:,4)=exp(cap);
constore(:,4)=exp(con);
% since this solution is generating logs I have to exp it to get the level

plot(capstore)
pause
plot(constore(2:end,:))
pause
plot(capstore(101:200,:))
pause
plot(constore(101:200,:))



