% dynareloop.m
%Wouter den Haan (UvA); this program was written quickly and there is no
% guarantee that it is free of errors
%
% this program shows how to specify within a Matlab program the parameters
% for the Dynare source file, which makes it possible to, for example, loop
% over different parameters
% In particular, it solves the standard growth model sequentially for
% different values of riskaversion and it compares the simulated series and IRFs
% each time a first-order log approximation is used
%
%
% !!!! running this program requires the updated version of disp_dr.m
% (which writes the policy functions to the matrix decision, exactly
% the way you see it on the screen). Alternatively, you can upload them
% from the files created by Dynare, but I find this easier especially for
% second-order
%

simul = 0; % plot time series if 1
IRF = 1;   % plot IRFs if 1

T=200;  % observations used in simulations
T2=100; % number of periods for IRFs

capstore=zeros(T,30);
constore=zeros(T,30);
capirf=zeros(T2,30);
conirf=zeros(T2,30);

%indicate which column of decision corresponds with which variable
%note that for each application you have to check that these column
%indications are correct. Here the labels are the same for each program

iiicap=1;
iiicons=3;

alpha = 0.36;
rho   = 0.95;
beta  = 0.99;
sig   = 0.01;
delta = 0.10;

for i = 1:50
    
nu = (i-1)*0.08;
save parameterfile nu alpha rho beta sig delta
%this saves parameter values into parameterfile.mat
%which is then read by modelcloglinear2

dynare modelcloglinear2 noclearall
% the command noclearall means that variables defined here (like T) are not
% deleted out of memory

load dynarerocks
% this loads the matrix "decision" with coefficients of the policy functions
% into memory

% to simulate series we use random shocks
% set is reset in each iteration to ensure we get the same draw each time
% initialize stuff

cap    = zeros(T,1);
con    = zeros(T,1);
prod   = zeros(T,1);	
randn('state',20080701);
shocks = sig*randn(T,1); 
prod(1)= 0;


capstst = decision(1,iiicap); 	
cap(1)  = capstst; % initial value is steady state level
for t = 2:T	
prod(t)=rho*prod(t-1)+shocks(t);
cap(t) =decision(1,iiicap)+decision(2,iiicap)*(cap(t-1)-capstst) ...	
           +decision(3,iiicap)*prod(t-1) + decision(4,iiicap)*shocks(t);
con(t) =decision(1,iiicons)+decision(2,iiicons)*(cap(t-1)-capstst) ...	
           +decision(3,iiicons)*prod(t-1) + decision(4,iiicons)*shocks(t);
       if t < 5
           [cap(t) con(t)]
           pause
       end
end	

capstore(:,i)=exp(cap);
constore(:,i)=exp(con);

if simul == 1
    if i==1
        plot(constore(2:end,1:i),'linewidth',2.2,'color',[0 0 0])
    else
        plot(constore(2:end,1:i-1))
        hold on
        plot(constore(2:end,i),'linewidth',2.2,'color',[0 0 0])
        hold off
    end
pause
%plot(constore(91:110,1:i))
%pause
end

% to calculate IRFs for linear policy function we set shocks (except for t=2) equal to zero
% set is reset in each iteration to ensure we get the same draw each time
%initialize stuff
cap    = zeros(T2,1);
con    = zeros(T2,1);
prod   = zeros(T2,1);	
randn('state',20080701);
shocks = zeros(T,1);
shocks(2) = sig; % a one standard deviation shock
prod(1)= 0;

capstst = decision(1,iiicap); 	
cap(1)  = capstst; % initial value is steady state level
constst = exp(alpha*capstst)-delta*exp(capstst); %consumption level steady state
constst = log(constst);
con(1)  = constst; % this is only needed for IRFs

for t = 2:T2	
prod(t)=rho*prod(t-1)+shocks(t);
cap(t) =decision(1,iiicap)+decision(2,iiicap)*(cap(t-1)-capstst) ...	
           +decision(3,iiicap)*prod(t-1) + decision(4,iiicap)*shocks(t);
con(t) =decision(1,iiicons)+decision(2,iiicons)*(cap(t-1)-capstst) ...	
           +decision(3,iiicons)*prod(t-1) + decision(4,iiicons)*shocks(t);
end	


% without the shock in period 2 the values would have remained equal 
% to the steady state
% IRF is the percentage difference between series with and without shock
% since series are in logs the difference is the percentage difference

capirf(:,i)=cap-capstst;
conirf(:,i)=con-constst;

if IRF ==1
    if i==1
        plot(conirf(1:20,1:i),'linewidth',2.2,'color',[0 0 0])
    else
        plot(conirf(1:20,1:i-1))
        hold on
        plot(conirf(1:20,i),'linewidth',2.2,'color',[0 0 0])
        hold off
    end
pause
%plot(capirf(1:20,1:i))
%pause
end

end
