% dyneuler.m
% Wouter den Haan (UvA); this program was written quickly and there is no
% guarantee that it is free of errors
%
% this program checks the loglinear solution for accuracy using Dynamic
% Euler errors
%
% !!!! running this program requires the updated version of disp_dr.m
% (which writes the policy functions to the matrix decision, exactly
% the way you see it on the screen). Alternatively, you can upload them
% from the files created by Dynare, but I find this easier especially for
% second-order

%
%=========================================================================
%
%Exercise: 
%  -play around with the values for nu & sig and check for accuracy 
%
%=========================================================================

nu  = 3; % this parameter is read in the Dynare source files
sig = 0.1; % this parameter is read in the Dynare source files
save nuparam nu;
save sigparam sig;

%the policy functions generated by Dynare will be stored in a matrix 
%called decision; each column contains the coefficients for a variable
%
%indicate which column of "decision" corresponds with which variable
%note that for each application you have to check that these column
%indications are correct. 
%

iiicap=1;
iiicons=3;

dynare modelcloglinear noclearall

% now we get a policy rule for the LOG of capital and the LOG of consumption
% note that productivity is always in logs

load dynarerocks

% this loads the matrix "decision" with coefficients into memory

%==========================================================================
%
% PRELIMINARIES - DEFINITION OF POLICY FUNCTION
%
% To make the program more readable I wrote a function polfunction(.) with
% which you can calculate the policy choices as a function of the inputs
% The format is as follows
%
% cap = polfunction(caplag,prodlag,shocks,iiicap)
% con = polfunction(caplag,prodlag,shocks,iiicons)
%
global decision capstst
%
%==========================================================================

T=5000;
numnodes = 10; % number of Hermite nodes used in integration
[Hnodes , Hweights] = hernodes(numnodes);

cap    = zeros(T,1);
con    = zeros(T,1);
capalt = zeros(T,1);
conalt = zeros(T,1);
prod   = zeros(T,1);	
shocks = sig*randn(T,1); 
prod(1)= 0;

capstst = decision(1,iiicap); 	
cap(1)  = capstst; % initial value is steady state level
con(1)  = exp(alpha*capstst) - delta*exp(capstst);
con(1)  = log(con(1));
capalt(1) = cap(1);
conalt(1) = con(1);

for t = 2:T	
prod(t)=rho*prod(t-1)+shocks(t);

%
% I CALCULATE SERIES ACCORDING TO POLICY RULES
%

cap(t) =polfunction(cap(t-1),prod(t-1),shocks(t),iiicap);
con(t) =polfunction(cap(t-1),prod(t-1),shocks(t),iiicons);

%
% II CALCULATE SERIES ACCORDING TO COND. EXPEC.
%
%
%calculate the alternative series
%it is important that these do not depend on cap(t) (or con(t))

captemp  =polfunction(capalt(t-1),prod(t-1),shocks(t),iiicap);

%calculate the conditional expectation

constemp =polfunction(captemp,prod(t),sig*Hnodes,iiicons);

%captemp is choice in current period and constemp is choice next period as
%function of possible outcomes

outcomes=beta*exp(-nu*constemp).* ...
    (alpha*exp(rho*prod(t)+sig*Hnodes).*exp(captemp*(alpha-1))+1-delta)/sqrt(pi);
condexpec=Hweights'*outcomes;
conalt(t)=-log(condexpec)/nu;
capalt(t)=exp(prod(t)+alpha*capalt(t-1))+(1-delta)*exp(capalt(t-1))-exp(conalt(t));
capalt(t)=log(capalt(t));
end

plot([con(1001:1500) conalt(1001:1500)])
pause
plot([cap(1001:1500) capalt(1001:1500)])

