// modelclog2ndorder.mod
// standard growth model
// variables are the log of consumption, the log of capital, and the log of productivity
// Dynare generates a law of motion that is 2nd-order in these variables (since order = 2)
 
var lnc, lnk, lnz;
varexo e;

parameters beta, rho, alpha, nu, delta, sig;

alpha = 0.36;
rho   = 0.95;
beta  = 0.99;
load nuparam;
set_param_value('nu',nu)
load sigparam;
set_param_value('sig',sig)
delta = 0.10;

model;
exp(-nu*lnc)=beta*(exp(-nu*lnc(+1)))*(exp(lnz(+1))*alpha*exp((alpha-1)*lnk)+1-delta);
exp(lnc)+exp(lnk)=exp(lnz+alpha*lnk(-1))+(1-delta)*exp(lnk(-1));
lnz = rho*lnz(-1)+e;
end;

initval;
lnk = log(6.366837);
lnc = log(1.310525);
lnz = 0;
end;

shocks;
var e; stderr sig;
end;

stoch_simul(order=2,nocorr,nomoments,IRF=0) lnk lnz lnc;