% November 9 1998

function y	= gridfun(psi,xgrid);

global po_k po_t alpha delta nu dfactor tmin tmax kmin kmax;


%       3.1 Compute the expected value (Step II)
%       ----------------------------------------  
%       Here we calculate the conditional expectation at each grid point.
%       First, we calculate next period's capital stock as a function of
%       the log of the current capital stock and the log of the technology
%       shock. Second, we numerically integrate the function aexp over the
%       random innovation to the technology shock. psi is an input of the
%       numerical integration since it is used to evaluate the consumption 
%       function at lnk2 and lnt2.


dimgrid	= length(xgrid);
yvec    = zeros(dimgrid,1);
y	= yvec;
for i   = 1:dimgrid
	lnk1      = scalup(xgrid(i,1),kmin,kmax);
	lnt1      = scalup(xgrid(i,2),tmin,tmax);
	lnk2      = savfun(lnk1,lnt1,psi);
	yvec(i)   = numi('aexp',lnk2,lnt1,psi);
	%y(i)	= exp( makepoly([po_k po_t],[lnk1 lnt1]) * psi );
end;
y	= exp( makepoly([po_k po_t],[xgrid(:,1) xgrid(:,2)]) * psi );
y	= y - yvec;

% **********************************************************************

% **********************************************************************
