
% calculating aggregate capital and new individual capital distribution given agg shocks (using nonstochastic distribution)

function [indKe, indKu, aggKu, aggKe, aggK]=aggcapital_RK(Kdiste, Kdistu, aggsh_1);

%OUTPUT:
% indKe: individual capital for employed,
% indKu, individual capital for unemployed,
% aggKu: aggregate cappital for unemployed, 
% aggKe: aggregate capital for employed,  
% aggK: aggregate capital,  note that aggK is the kMEAN (not dkMEAN)

%INPUT
%Kdiste: individual capital distribution of employed (from pdist.xls given)
%Kdistu: individual capital distribution of unemployed (from pdist.xls given)
%aggsh_1: aggregate shocks in two periods (current and next periods)


global NC BETA  ALPHA GAM AADDJJ DEPREC REPLACEMENT LabSS KSS LOGQ ORD
global FD FDD M11 M2 zs zu sig pick C six usix omega AI_SHOCKS
global xss1 xss3 ACC delo  indKe indKu aggK

aggsh=aggsh_1(1,:); %this period's aggsh
aggsh1=aggsh_1(2,:);  %next period's aggsh

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%use uniform distribution and calculate average aggregate K
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

numint=1;  % how much fine grid in a unit interval of 0.1 (uniform distribution)

Kdistex=vec((Kdiste*ones(1,numint))'); Kdistex=Kdistex./numint; %1001*numint by 1
Kdistux=vec((Kdistu*ones(1,numint))'); Kdistux=Kdistux./numint; 
xxx=0:.1/numint:100; xxx=[zeros(1,numint-1) xxx]; %1 by 1001*numint
aggKe=xxx*Kdistex; aggKu=xxx*Kdistux;

%aggKe=kindex*Kdiste; aggKu=kindex*Kdistu;

if aggsh==1.01; aggK=.96*aggKe+.04*aggKu; end;
if aggsh==.99; aggK=.9*aggKe+.1*aggKu; end;


kindex=0:0.1:100; %1 by 1,001

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%disp('calculating end of period capital distribution')
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% calculating policy functions with two grid points for unemployed and employed agents, with given aggsh, aggK calculated from above
% this process assumes linear policy function (only valid under linear approximation), in quadratic approximation, we need to calculate policy function for every points

% for employed
wLE=xss1+jedcB1_POLF_pos([1-LabSS;40-KSS;aggK-KSS;aggsh-1],delo); wLE1=wLE(3);  % one point assuming ki=40
wLE=xss1+jedcB1_POLF_pos([1-LabSS;40.1-KSS;aggK-KSS;aggsh-1],delo); wLE2=wLE(3); % another point assuming ki=40.1
bE=(wLE2-wLE1)/.1; aE=wLE1-bE*40;  %calculating calpital for other points

if aE<0; error('LLL1'); end;
if bE>1; error('LLL2'); end;

resE=(kindex'-aE)./bE; %resE=resE.*(resE>0);.....................................................

% for unemployed
wLU=xss1+jedcB1_POLF_pos([0-LabSS;40-KSS;aggK-KSS;aggsh-1],delo);wLU1=wLU(3); 
wLU=xss1+jedcB1_POLF_pos([0-LabSS;40.1-KSS;aggK-KSS;aggsh-1],delo);wLU2=wLU(3); 
bU=(wLU2-wLU1)/.1; aU=wLU1-bU*40;

if bU>1; error('LLL3'); end;
if maxaa(bU-bE)>1e-7; error('LLL4'); end;

resU=(kindex'-aU)./bU; %resU=resU.*(resU>0).....................................................

%  for alternate adjustment (not used any more)
%if delo*delo'~=0  %with nonzero delo: in case of alternative adjustment
%    zz=resU(1,:);  % point where the new slope will be estimated
%wLU=xss1+jedcB1_POLF_pos([0-LabSS;zz-KSS;aggK-KSS;aggsh-1],delo);wLU1=wLU(3); 
%wLU=xss1+jedcB1_POLF_pos([0-LabSS;zz+.1-KSS;aggK-KSS;aggsh-1],delo);wLU2=wLU(3); 
%bU=(wLU2-wLU1)/.1; aU=wLU1-bU*zz;
%resU1=(kindex'-aU)./bU; 
%resU=min([resU resU1],[],2);
%end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calculating cumulative distributions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fxui=[];
fxei=[];

j=1; while j<=cols(kindex);
xuij=resU(j);
xeij=resE(j);

if xuij<=0;    xuiii=0;  % for the case when k(t) become negative
elseif xuij>100;     % for the case when k(t) goes over 100. 
xuiii=sum(Kdistu(kindex<xuij));
else    
xuiii=sum(Kdistu(kindex<xuij))+Kdistu(sum(kindex<xuij)+1,:)*(xuij-kindex(sum(kindex<xuij)))/(.1);
%xuiii=sum(Kdistu(kindex<xuij));
end;

if xeij<=0;    xeiii=0;  % for the case when k(t) become negative
elseif xeij>100;   % for the case when k(t) goes over 100. 
xeiii=sum(Kdiste(kindex<xeij));
else;
    xeiii=sum(Kdiste(kindex<xeij))+Kdiste(sum(kindex<xeij)+1,:)*(xeij-kindex(sum(kindex<xeij)))/(.1);
%xeiii=sum(Kdiste(kindex<xeij));
end;

fxui=[fxui;xuiii];
fxei=[fxei;xeiii];

j=j+1; end;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%next period's capital distribution
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

S=[ ...
0.525 0.35 0.03125 0.09375; ...
0.038889 0.836111 0.002083 0.122917; ...
0.09375 0.03125 0.291667 0.583333; ...
0.009115 0.115885 0.024306 0.850694];


% .............................................
if aggsh==.99 & aggsh1==.99; 
    V=S(1:2,1:2);
    guu=.1*V(1,1)/(V(1,1)+V(1,2));
    gue=.1*V(1,2)/(V(1,1)+V(1,2));
    geu=.9*V(2,1)/(V(2,1)+V(2,2));
    gee=.9*V(2,2)/(V(2,1)+V(2,2));
    if maxaa(guu+geu-.1)>1e-5; error('QQ1'); end;
end;

if aggsh==.99 & aggsh1==1.01; 
    V=S(1:2,3:4);
    guu=.1*V(1,1)/(V(1,1)+V(1,2));
    gue=.1*V(1,2)/(V(1,1)+V(1,2));
    geu=.9*V(2,1)/(V(2,1)+V(2,2));
    gee=.9*V(2,2)/(V(2,1)+V(2,2));
    if maxaa(guu+geu-.04)>1e-5; error('QQ2'); end;
end;

if aggsh==1.01 & aggsh1==.99; 
    V=S(3:4,1:2);
    guu=.04*V(1,1)/(V(1,1)+V(1,2));
    gue=.04*V(1,2)/(V(1,1)+V(1,2));
    geu=.96*V(2,1)/(V(2,1)+V(2,2));
    gee=.96*V(2,2)/(V(2,1)+V(2,2));
    if maxaa(guu+geu-.1)>1e-5; error('QQ3'); end;   
end;

if aggsh==1.01 & aggsh1==1.01; 
    V=S(3:4,3:4);
    guu=.04*V(1,1)/(V(1,1)+V(1,2));
    gue=.04*V(1,2)/(V(1,1)+V(1,2));
    geu=.96*V(2,1)/(V(2,1)+V(2,2));
    gee=.96*V(2,2)/(V(2,1)+V(2,2));
    if maxaa(guu+geu-.04)>1e-5; error('QQ3'); end;       
end;


if maxaa(guu+gue+geu+gee-1)>1e-7; error('PPP1'); end;

% ...................................................

uperu=guu/(guu+geu); upere=1-uperu;
xxui=uperu*fxui+upere*fxei;

eperu=gue/(gue+gee); epere=1-eperu;
xxei=eperu*fxui+epere*fxei;

indKu=[xxui(1); xxui(2:end)-xxui(1:end-1)];
indKe=[xxei(1); xxei(2:end)-xxei(1:end-1)];

%correcting repeated max value of 100 by using uniform distribution

qq=sum(indKu==0);qqq=(indKu(end-qq)-indKu(end))/qq;
for jj=1:qq-1
    indKu(end-qq+jj)=indKu(end-qq)-jj*qqq;
end

qq=sum(indKe==0);qqq=(indKe(end-qq)-indKe(end))/qq;
for jj=1:qq-1
   indKe(end-qq+jj)=indKe(end-qq)-jj*qqq;
end

indKe=indKe/sum(indKe);indKu=indKu/sum(indKu);


