% Calculating cross-sectional statistics from given capital distributions and aggregate shocks


function stats=cross_RK(indKe, indKu, aggsh);


%stats is 1 by 9 output vector that contains:
%1: aggregtae shock
%2: percentage of constrained agents for unemployed
%3: percentage of constrained agents for employed
%4,5: 5th and 10th percentile of unemployed capital
%6,7: 5th and 10th percentile of employed capital
%8,9: mean capital for unemployed and employed 


stats=zeros(1,9);
stats(:,1)=aggsh;
stats(:,2)=indKu(1);  %percentage of constrained agents for unemployed
stats(:,3)=indKe(1);  %percentage of constrained agents for employed


x=0:.1:100;
zz1=cumsum(indKu);qq1=sum(zz1>(1-1e-5));x1=x(1:end-qq1);zz1=zz1(1:cols(x1));
zz2=cumsum(indKe);qq2=sum(zz2>(1-1e-5));x2=x(1:end-qq2);zz2=zz2(1:cols(x2));


stats(:,4:5)=interp1(zz1,x1',[0.05 0.1]);  %5th and 10th percentile of unemployed capital
stats(:,6:7)=interp1(zz2,x2',[0.05 0.1]);  %5th and 10th percentile of employed capital


numint=1;  % how much fine grid in a unit interval of 0.1 (uniform distribution)


Kdistex=vec((indKe*ones(1,numint))'); Kdistex=Kdistex./numint; %1001*numint by 1
Kdistux=vec((indKu*ones(1,numint))'); Kdistux=Kdistux./numint; 
xxx=0:.1/numint:100; xxx=[zeros(1,numint-1) xxx]; %1 by 1001*numint
aggKe=xxx*Kdistex; aggKu=xxx*Kdistux;


stats(:,8)=mean(aggKu);  %mean capital for unemployed
stats(:,9)=mean(aggKe);  % mean capital for employed