% This proc generates POLICY function 
% For given predetermined and exogenous state
% z(t)=[dLabi(t);dki(t);dkMEAN(t); dtheta(t)], this proc determines 
%  res=[dci*(t); dLabi*(t); dk*(t+1); dC*(t); dL*(t); dK*(t+1); dtheta*(t)];
%         (1)       (2)       (3)       (4)     (5)     (6)        (7)

% IF k*(t+1)<0, then the proc sets k(t+1)=0, c(t)=c*(t)+K*(t+1), and it 
% then returns 
% res=[dci(t); dLabi*(t); 0; dC*(t); dL*(t); dK*(t+1); dtheta*(t)];

% HENCE, this proc never returns a negative value for k(t+1) ! 
% THIS DISTINGUISHES THE PROC FROM jedcB1_POLF.m (which may return 
% negative k(t+1))

function res=jedcB1_POLF_pos(z,delo_1);
global ORD LabSS KSS  AI_SHOCKS  LOGQ ALPHA REPLACEMENT DEPREC
global FD FDD M11 M2 zs zu sig pick C six usix xss1 delo

delo_1=[0 0]; % with delo_1=[0 0] all the time (no convex combination for nonnegativity constraint)

if rows(z)~=4; error('LL'); end;
if cols(z)~=1; error('QQ'); end;
% z(t)=[Lab(t)-LabSS; k(t)-KSS; kMEAN(t)-KSS; theta(t)-1];

if rows(delo_1)~=1; error('delos dim'); end;

delo1=delo_1(:,1);
delo2=delo_1(:,2);

if isempty(ORD); error('ORD: []'); end;

F1=(FD{1});  %output matrix from gensys2
F2=(FD{2});
F3=(FD{3});
F11=(FDD{1,1});
F12=(FDD{1,2});
F22=(FDD{2,2});

F1=real(F1);F2=real(F2);F3=real(F3);

y=[0;z(2:3,:);0];  %initial starting values

% -----------------------------------------------------------------------------------
% converting to continuous time shocks
% -----------------------------------------------------------------------------------

if AI_SHOCKS==2;   % both aggregate and invidual shocks
LmTH=z(1,:)-3*z(4,:);
%exoQ=[LmTH/.208 + (2.408/.208^2)*LmTH.*z(4,:); z(4,:)/.00661437];
%exoL=[LmTH/.208; z(4,:)/.00661437];
exoQ=[LmTH/.2083 + (2.4029/.2083^2)*LmTH.*z(4,:); z(4,:)/.00661437];
exoL=[LmTH/.2083; z(4,:)/.00661437];

% exoQ=exoL;
end;

if AI_SHOCKS==1;  % only individual shocks
exoQ=[z(1,:)/.23446; 0];
exoL=exoQ;
end;

% -----------------------------------------------------------------------------------
% simulation
% -----------------------------------------------------------------------------------

yt=y; 
ytART=y;  % implementing pruning arguments in gensys2 (refer to Kim,Kim, Schaumberg and Sims (JEDC, forthcoming)


xc=prodt(F1,yt,2,1)+prodt(F2,exoQ,2,1)+F3*sig^2;   
xc=xc+0.5*prodt(prodt(F11,ytART,2,1),yt,2,1);
xc=xc+prodt(prodt(F12,ytART,2,1),exoL,2,1);
xc=xc+0.5*prodt(prodt(F22,exoL,2,1),exoL,2,1);
yt=xc + 0*C(six);

ytART=prodt(F1,ytART,2,1)+prodt(F2,exoL,2,1);   
xt=0.5*prodt(prodt(M11,ytART,2,1),ytART,2,1) + M2*sig^2 + 0*C(usix); 

resL=[ytART;zeros(3,1)];
resQ=[yt;xt];

if ORD==1;
res=inv([pick;zu])*resL;
end;

if ORD==2;
res=inv([pick;zu])*resQ;
end;

% -----------------------------------------------------------------------------------
%implementing nonnegativity constraint for k
% -----------------------------------------------------------------------------------


if LOGQ==0;
h=xss1+res; hh=h;

%if h(3,:)<0;% if k<0, then set k=0
    
if delo1+delo2==0;  % no alternative adjustment
h(3,:)=max([0;h(3,:)]);
end;  %end of delos

if delo1+delo2~=0;
h(3,:)=max([0;h(3,:);delo1*(1-delo2)+delo2*h(3,:)]);
end

h(1,:)=hh(1,:)+hh(3,:)-h(3,:); 
res=h-xss1;

%end;  % end if k<0
end; % end if LOGQ==0


