% calculating moments from STAT.mat

clear all
load STAT;

state=STAT(:,1);   %aggregate state

%-----------------------------------------------------
%  5th percentile moments
%---------------------------------------------------

dat1=STAT(:,4);  %unempl  5% for 4,6,  10% for 5,7,
dat2=STAT(:,6);  %empl

dat1g=dat1(state>1,:); %unempl, good
dat1b=dat1(state<1,:); %unempl, bad
dat2g=dat2(state>1,:); %empl, good
dat2b=dat2(state<1,:); %empl, bad

if size(dat1g,1)+size(dat1b,1)~=size(dat1,1); disp('error'); end;

zz=[mean(mean([dat1 dat2])'); mean(mean([dat1g dat2g])'); mean(mean([dat1b dat2b])'); mean(dat1); mean(dat2); mean(dat1g); mean(dat2g); mean(dat1b); mean(dat2b)]

momunemp=STAT(:,8:12);
momemp=STAT(:,13:17);
mom=[momunemp;momemp];

disp('5th percentile moments (mean(u), std(u), mean (e), std(e), mean (all), std(all)')
[mean(momunemp)' std(momunemp)' mean(momemp)' std(momemp)' mean(mom)' std(mom)']


%-----------------------------------------------------
%  10th percentile moments
%---------------------------------------------------
dat1=STAT(:,5);  %unempl  5% for 4,6,  10% for 5,7,
dat2=STAT(:,7);  %empl

dat1g=dat1(state>1,:); %unempl, good
dat1b=dat1(state<1,:); %unempl, bad
dat2g=dat2(state>1,:); %empl, good
dat2b=dat2(state<1,:); %empl, bad

if size(dat1g,1)+size(dat1b,1)~=size(dat1,1); disp('error'); end;

zz=[mean(mean([dat1 dat2])'); mean(mean([dat1g dat2g])'); mean(mean([dat1b dat2b])'); mean(dat1); mean(dat2); mean(dat1g); mean(dat2g); mean(dat1b); mean(dat2b)]

momunemp=STAT(:,8:12);
momemp=STAT(:,13:17);
mom=[momunemp;momemp];

disp('5th percentile moments (mean(u), std(u), mean (e), std(e), mean (all), std(all)')
[mean(momunemp)' std(momunemp)' mean(momemp)' std(momemp)' mean(mom)' std(mom)']