% produce table 8-1-1  using the saved file hlL.mat generated by KKK_simul.m

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% note that capital is now time t value
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
load hL; %generated from KKK_simul.m
z=hL;

% followings are all row vectors

c=(z(1:end-1,1))';       % individual CONSUMPTION 
Lab=(z(1:end-1,2))';        % indiv employment (=EPSILON(t)). HOURS worked = Lab/.9
k=(z(2:end,3))';  % indiv k(t+1)  (individual capital stock)
kL=(z(1:end-1,3))';  % indiv k(t)  (individual capital stock)
CA=(z(1:end-1,4))';       % AGGGREGATE consumption (or repr agent economy)
LabMEAN=z(1:end-1,5)';  %agg labor
kMEAN=(z(2:end,6))';  %agg capital at t
kMEANL=(z(1:end-1,6))';  %agg K at t-1
theta=z(1:end-1,7)';  % agg shock

gdp=theta.*(kMEANL.^ALPHA).*((LabMEAN/.9).^(1-ALPHA));   % per capita GDP
wage=(1-ALPHA)*theta.*(kMEANL./(LabMEAN/.9)).^ALPHA;    
rental=ALPHA*theta.*(kMEANL./(LabMEAN/.9)).^(ALPHA-1); 

u=1-LabMEAN;  % unemployment rate
tax=REPLACEMENT*u./((LabMEAN/.9));

GDPSS=(KSS^ALPHA)*(LabSS/.9)^(1-ALPHA);  %Steady state GDP

INVEST=kMEAN-(1-DEPREC)*kMEANL;  % investment

TotINCi=rental.*kL+(1-tax).*wage.*(Lab/.9) + REPLACEMENT*wage.*(1-Lab) + (1-DEPREC)*kL;  %total income
LabINCi=(1-tax).*wage.*(Lab/.9) + REPLACEMENT*wage.*(1-Lab); % labor income
KapINCi=rental.*kL+ (1-DEPREC)*kL;  % capital income
SPENDi=c+k;  %spending

EULERerr=-1 + BETA*(c.^-GAM).*(rental+1-DEPREC)./(c.^-GAM);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%calculating statistics in section 8.1.1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%     (1)     (2)       (3)      (4)      (5)    (6) (7)   (8) (9)  (10)
aux=[ SPENDi; TotINCi; LabINCi; KapINCi; EULERerr; c; gdp; CA; kL; kMEANL];

%        (11)   (12)   (13)    
aux=[aux; rental; wage; INVEST];
aux=aux';    %  now it is by the column

%              (1)                (2)                    (3)
%          corr(c,CA)         corr(c,gdp)         corr(c,kMEANL)
rSTAT= [correl(aux(:,[6 8])) correl(aux(:,6:7))  correl(aux(:,[6 10]))];

%                    (4)                   (5)              (6)        (7)
%               corr(c,TotINCi)         corr(c,kL)               std(c)     std(kL)  note that corr (c,kL), not corr(c,k)
rSTAT=[rSTAT correl(aux(:,[6 2])) correl(aux(:,[6 9])) std(aux(:,6)) std(aux(:,9))]; 

%              (8),(9),(10)      
%            autcor(c,[1 2 3])   
rSTAT=[rSTAT correl([aux(4:end,6) aux(3:end-1,6)]) correl([aux(4:end,6) aux(2:end-2,6)]) correl([aux(4:end,6) aux(1:end-3,6)])]; 

%           (11),(12),(13)
%           autcor(kL,[1 2 3])
    
rSTAT=[rSTAT correl([aux(4:end,9) aux(3:end-1,9)]) correl([aux(4:end,9) aux(2:end-2,9)]) correl([aux(4:end,9) aux(1:end-3,9)])];

%           (14)
%           autocor (cgrowth)
rSTAT=[rSTAT correl([(log(aux(3:end,6))-log(aux(2:end-1,6))) (log(aux(2:end-1,6))-log(aux(1:end-2,6)))])];
%rSTAT=[rSTAT correl([(aux(3:end,6)-aux(2:end-1,6))./aux(2:end-1,6) (aux(2:end-1,6)-aux(1:end-2,6))./aux(1:end-2,6)])];

capt_STAT=[ ...
' corr(c,CA)      '; ...    
' corr(c,gdp)     '; ...
' corr(c,kMEAN)   '; ...
' corr(c,TotINCi) '; ...
' corr(c,kL)      '; ...
' std(c)          '; ...
' std(kL)         '; ...
' autocorr(c,1)   '; ...
' autocorr(c,2)   '; ...
' autocorr(c,3)   '; ...
' autocorr(kL,1)  '; ...
' autocorr(kL,2)  '; ...
' autocorr(kL,3)  '; ...
' autocorr(cg,1)  '];

display(' 8.1.1 Risk sharing ');
rSTAT'

