% derive cross-sectional distributions of capital (8-1-2) from STAT.m calculated by KKK_simul.m

clear all

load STAT;  
%load STAT_AG; STAT=STAT_AG;

disp('data loaded')

%     1         2              3            4            5              6         7          
%[ aggsh, k=0 for unempl, k=0 for empl, 5th% unempl, 10th% unempl, 5th% empl, 10th% empl]

resTH=STAT(:,1);  %aggregate shock
SG=STAT(resTH>1,:);  %good state
SB=STAT(resTH<1,:);   % bad state

a4=mean(STAT(:,4));
a5=mean(STAT(:,6)); 
a6=mean(SG(:,4)); 
a7=mean(SG(:,6)); 
a8=mean(SB(:,4)); 
a9=mean(SB(:,6)); 
a10=mean([a6;a7]); 
a11=mean([a8;a9]); 
a12=mean([a10;a11]);

a13=mean(STAT(:,5));
a14=mean(STAT(:,7)); 
a15=mean(SG(:,5)); 
a16=mean(SG(:,7)); 
a17=mean(SB(:,5)); 
a18=mean(SB(:,7)); 
a19=mean([a15;a16]); 
a20=mean([a17;a18]); 
a21=mean([a19;a20]);

%k=0all, k=0 good, k=d bad 
CC1=[100*mean([STAT(:,2);STAT(:,3)]); 100*mean([SG(:,2);SG(:,3)]); 100*mean([SB(:,2);SB(:,3)])];

%              all   good    bad %         
%employed 5%  
%employed 10% 
%uemployed 5%
%uemployed 10%
CC2=[a5 a7 a9; a14 a16 a18; a4 a6 a8; a13 a15 a17];

display(' 8.1.2 Wealth distribution ');
CC1
CC2
%wealthSTAT
