

function [res]=corrCROSS(x1,x2,k);
% Dec. 25, 2007. Let x1 and x2 be column VECTORS;
% This computes auto and cross correlation between x1, and x2
% at leads and lags up to k

% res: correl(x1(t+j,:),x2(t,:)) for j=-k, -k+1, ...-1, 0, 1, ...k


if cols(x1)~=1;         error('Q1'); end;
if cols(x2)~=1;         error('Q2'); end;
if rows(x1)~=rows(x2);  error('Q3'); end; 
if size(k)~=[1 1];      error('Q4'); end;
if k-ceil(k)~=0;        error('Q5'); end;
if k<0;                 error('Q6'); end;
T=rows(x1);

res=[];
i=-k; while i<=k;
if i<=0;    h1=x1(1:T+i,:);  h2=x2(1-i:T,:); end;
if i>0;     h1=x1(1+i:T,:);  h2=x2(1:T-i,:); end;
res=[res correl([h1 h2])'];
i=i+1; end;
size(res);

%res=[(-k:1:k); res];
