

function [dfNORM]=grad1(f,x,varargin);
% MARCH 2, 2001. This proc computes gradient of the (vector-valued) function f: df/dx
% Use as follows: df=grad1('f',x)

%nargin
if nargin~=2; error('incorrect number of arguments'); end;


if cols(x) ~=1; return; end;
yss=feval(f,x);
if cols(yss) ~=1; return; end;

df=zeros(rows(yss),rows(x));

di=1e-7;
di=1e-8;
di=1e-8;
di=1e-8;
di=1e-7;
di=1e-8;




% SCALE FACTOR
SC=eye(rows(x));
i=1; while i<=rows(x);
if abs(x(i,:))>=1e-8; SC(i,i)=abs(x(i,:)); end;
i=i+1; end;


% SEPTEMBER 27, 2003. Two-point evaluation for computation of derivatives 
% See Miranada & Fackler, 2002, p.98
resx1=x*ones(1,rows(x))+SC*di;
resx2=x*ones(1,rows(x))-SC*di;

resf1=feval(f,resx1);
resf2=feval(f,resx2);
df=(resf1-resf2)/(2*di);


% save klm;

dfNORM=df*inv(SC);


