


function [d2fNORM]=hessTWO(f,x);
% MARCH 2, 2001. This proc computes hessian of the (vector-valued) function f: d2f/dx2
% Use as follows: d2f=hess1('f',x)
% dimensions of d2f: (rows(f),rows(x),rows(x))
% element i,j,k: d2fi/(dxj dxk)  (2nd derivative of element i of f wrt xj and kx)  

% SEPTEMBER 27, 2003. Two-point evaluation for computation of derivatives 
% See Miranda & Fackler, 2002, p.102


if nargin~=2; error('incorrect number of arguments'); end;
if cols(x) ~=1; return; end;

di=1e-4;
di=1e-5;
di=1e-4;
di=1e-5;


% . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
%SCALE FACTOR
SC=eye(rows(x));
i=1; while i<=rows(x);
if abs(x(i,:))>=1e-8; SC(i,i)=abs(x(i,:)); end;
i=i+1; end;

% . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 

yss=feval(f,x);
if cols(yss) ~=1; return; end;

WSL=eye(rows(x))*di;


d2f=zeros(rows(yss),rows(x),rows(x));
T2fPP=zeros(rows(x),rows(x),rows(x));
T2fMM=zeros(rows(x),rows(x),rows(x));
T2fPM=zeros(rows(x),rows(x),rows(x));
T2fMP=zeros(rows(x),rows(x),rows(x));

U2f=zeros(rows(yss),rows(x),rows(x));


resx=x*ones(1,rows(x))+SC*di;
resf=feval(f,resx);


% ===================================================================
WSL=SC*di;

j=1; while j<=rows(x);   
k=1; while k<=rows(x);   
   
if k >=j;      
T2fPP(:,j,k)=x+WSL(:,j)+WSL(:,k);  
T2fMM(:,j,k)=x-WSL(:,j)-WSL(:,k);  
T2fMP(:,j,k)=x-WSL(:,j)+WSL(:,k);  
T2fPM(:,j,k)=x+WSL(:,j)-WSL(:,k);  

T2fPP(:,k,j)=T2fPP(:,j,k);
T2fMM(:,k,j)=T2fMM(:,j,k);
T2fMP(:,k,j)=T2fMP(:,j,k);
T2fPM(:,k,j)=T2fPM(:,j,k);
end;

k=k+1; end;
j=j+1; end;


cPP=feval(f,T2fPP);
cMM=feval(f,T2fMM);
cMP=feval(f,T2fMP);
cPM=feval(f,T2fPM);

dPP=reshape(cPP,rows(cPP),rows(T2fPP),rows(T2fPP));
dMM=reshape(cMM,rows(cMM),rows(T2fMM),rows(T2fMM));
dMP=reshape(cMP,rows(cMP),rows(T2fMP),rows(T2fMP));
dPM=reshape(cPM,rows(cPM),rows(T2fPM),rows(T2fPM));


d2f=(dPP+dMM-dMP-dPM)/(4*(di^2));

d2fNORM=prodt(prodt(d2f,inv(SC),2,1),inv(SC),2,1);


