function [xq]=jedcB1f(z1,SC);  

% 25.8.2007 JEDC problem B: 1 country taking as given 
% Factor prices generates by representative agent model
% only asset: capital


global NC BETA  ALPHA GAM AADDJJ DEPREC REPLACEMENT LabSS KSS GDPSS AI_SHOCKS LOGQ
global ACC

if nargin==1; z=z1; end;
if nargin==2; z=prodt(SC,z1,2,1); end;
if nargin>2; error('too many inputs'); end;
if rows(z)~=16; error(';;;'); end;

% NC: number of agents, when using approximate aggregate property, NC=1 always
% ACC:  1 if taking absolute values of Euler equation for calculating approximation errors, 0 otherwise
% AI_SHOCLS:  1 for individual shocks only and 2 for aggregate AND individual shocks  
% LOGQ: 0 for level and 1 for logs


% ...................................................................
% define variables
% ...................................................................


% ...................................................................
if LOGQ==0; %using level approximation
    
c=(z(1,:));       % individual CONSUMPTION 
Lab=(z(2,:));        % indiv employment (=EPSILON(t)). HOURS worked = Lab/.9
k=(z(3,:));       % indiv k(t+1)  (individual capital stock)
CA=(z(4,:));       % AGGGREGATE consumption (or repr agent economy)
LabMEAN=z(5,:);
kMEAN=(z(6,:));
theta=z(7,:);

kpk=7;
cL=(z(kpk+1,:));     % LAGGED individual CONSUMPTION 
LabL=(z(kpk+2,:));      % indiv employment (=EPSILON(t)). HOURS worked = Lab/.9
kL=(z(kpk+3,:));     % indiv k(t+1)  (individual capital stock)
CAL=(z(kpk+4,:));    % AGGGREGATE consumption (or repr agent economy)
LabMEANL=z(kpk+5,:);
kMEANL=z(kpk+6,:);
thetaL=z(kpk+7,:);

ELab=z(2*kpk+1,:);
Etheta=z(2*kpk+2,:);
end; 
% =====================================================================


% ...................................................................
if LOGQ==1;   % Taylor expansion in terms of log(c),log(k)  
c=exp(z(1,:));       % individual CONSUMPTION 
Lab=(z(2,:));        % indiv employment (=EPSILON(t)). HOURS worked = Lab/.9
k=exp(z(3,:));       % indiv k(t+1)  (individual capital stock)
CA=exp(z(4,:));       % AGGGREGATE consumption (or repr agent economy)
LabMEAN=z(5,:);
kMEAN=exp(z(6,:));
theta=z(7,:);

kpk=7;
cL=exp(z(kpk+1,:));     % LAGGED individual CONSUMPTION 
LabL=(z(kpk+2,:));      % indiv employment (=EPSILON(t)). HOURS worked = Lab/.9
kL=exp(z(kpk+3,:));     % indiv k(t+1)  (individual capital stock)
CAL=exp(z(kpk+4,:));    % AGGGREGATE consumption (or repr agent economy)
LabMEANL=z(kpk+5,:);
kMEANL=exp(z(kpk+6,:));
thetaL=z(kpk+7,:);

ELab=z(2*kpk+1,:);
Etheta=z(2*kpk+2,:);
end;  % end if LOGQ==1
% =====================================================================

gdp=theta.*(kMEANL.^ALPHA).*((LabMEAN/.9).^(1-ALPHA));   % per capita GDP
wage=(1-ALPHA)*theta.*(kMEANL./(LabMEAN/.9)).^ALPHA;    
rental=ALPHA*theta.*(kMEANL./(LabMEAN/.9)).^(ALPHA-1); 

u=1-LabMEAN;  % unemployment rate
tax=REPLACEMENT*u./((LabMEAN/.9));


% ...................................................................
% Define first order conditions
% ...................................................................

% x1: individual Euler equation; 
% x2: aggregate Euler eqn
% x3: individual budget constraint; 
% x4: aggregate resource constraint
% x5: individual shock process;
% x6: aggregate shock processes
% x7: Aggregate labor euqation

if ACC==0;
    x1=-(cL.^-GAM)+BETA*(c.^-GAM).*(rental+1-DEPREC)+ AADDJJ*(1./kL-1/KSS); 
end
if ACC==1; 
x1=(-(cL.^-GAM)+BETA*(c.^-GAM).*(rental+1-DEPREC))./(cL); 
x1=abs(x1);   % take absolute values to calculate approximation errors
end

x2=-(CAL.^-GAM)+BETA*(CA.^-GAM).*( rental + 1-DEPREC); 

if ACC==0;
x3=-(c+k)+rental.*kL+(1-tax).*wage.*(Lab/.9) + REPLACEMENT*wage.*(1-Lab) + (1-DEPREC)*kL;
end
if ACC==1; 
x3=-(c+k)+rental.*kL+(1-tax).*wage.*(Lab/.9) + REPLACEMENT*wage.*(1-Lab) + (1-DEPREC)*kL;
x3=x3./(rental.*kL+(1-tax).*wage.*(Lab/.9)+REPLACEMENT*wage.*(1-Lab)+(1-DEPREC)*kL);  % as a percentage of money at hand
x3=abs(x3);   % take absolute values to calculate approximation errors
end

x4=-(CA+kMEAN)+gdp+(1-DEPREC)*kMEANL;

% MODEL WITHOUT AGGREGATE UNCERTAINTY
if AI_SHOCKS==1;   % just shocks to individual employment
x5=-(Lab-ones(NC,1)*LabSS) + .55555*(LabL-ones(NC,1)*LabSS)+ ...
    (.23446-.28381*(LabL-ones(NC,1)*LabSS)).*ELab;
x6= - theta + 1;
end;

% MODEL WITH AGGREGATE UNCERTAINTY
if AI_SHOCKS==2;    % aggregate productivity shock AND indiv employment shocks
%x5=-(Lab-ones(NC,1)*LabMEAN)+ ...
%(.442- 17.416*(ones(NC,1)*theta-1) + ...
%        4.838*(ones(NC,1)*thetaL-1)).*(LabL-ones(NC,1)*LabMEANL)+ ...
%(.208 - 2.408*(ones(NC,1)*theta-1) + .101*(ones(NC,1)*thetaL-1) - ...
%       .267*(LabL-ones(NC,1)*LabMEANL)).*ELab;    
  
x5=-(Lab-ones(NC,1)*LabMEAN)+ ...
(.4428- 17.4167*(ones(NC,1)*theta-1) + ...
       4.8387*(ones(NC,1)*thetaL-1)).*(LabL-ones(NC,1)*LabMEANL)+ ...
(.2083 - 2.4029*(ones(NC,1)*theta-1) + 0.09531*(ones(NC,1)*thetaL-1) - ...
       .2672*(LabL-ones(NC,1)*LabMEANL)).*ELab;    


x6= - (theta-1) + .75*(thetaL-1) + .00661437*Etheta;
end;

x7=-(LabMEANL-LabSS)+3*(thetaL-1);


xqZ=[x1;x2;x3;x4;x5;x6;x7];

if rows(xqZ)~=7; error('-----'); end;

% save klm;

sdi=size(z);
if cols(sdi)<=2;
xq=xqZ;
end;
    
if cols(sdi)==3;
xq=reshape(xqZ,rows(xqZ),sdi(2),sdi(3));
end;

if cols(sdi)==4;
xq=reshape(xqZ,rows(xqZ),sdi(2),sdi(3),sdi(4));
end;


if cols(sdi)==5;
xq=reshape(xqZ,rows(xqZ),sdi(2),sdi(3),sdi(4),sdi(5));
end;

