


function [M11,M2,FDD,F3,rc]=order2guts(BD,BDD,F1,F2,omega);


% order2guts.m: CORRECTED CODE (APRIL 12, 2001)
% see order2test.m: tests of the code

%  function [M11,M2,FDD,F3,rc]=order2guts(BD,BDD,F1,F2,omega)     
%  System originally in the form Ka(z(t),z(t-1),eps(t),eta(t))=0, t=0,...,\infty, 
%  where Et[eta(t+1)]=0 for t\ge 0. Its second order expansion is K1 dz(t)= K2 
%  dz(t-1) + K3\eps(t) + K4\eta(t) + .5*(K11*dz(t)\otimes dz(t) + K12*dz(t)\otimes 
%  dz(t-1) ... It is assumed that the \eta terms enter linearly and thus generate no 
%  second-order terms. gensys transformations convert this form  to an equation 
%  where the K's are replaced by B's and z is are replaced by w=[y,x], with the 
%  following special characteristics:  the xy block of BD{1} is zero; the yy block of 
%  BD{1} is the identity; the y row of BD{4} is zero (and hence BD{4} is unused); the 
%  xx block of BD{2} is 
%  non-singular, and BD{2}{uindex,uindex}\BD{1}{uindex,uindex} (uindex indexes the xx block of BD{2}) has 
%  all its eigenvalues 
%  less than (1/div)<1 in absolute value; the yy block of BD{1} has all its eigenvalues 
%  less than div>1 in absolute value. F1 and F2 are the coefficients in the first order
%  solution y(t)=F1*y(t-1)+F2*eps(t).  omega is the covariance matrix of eps.
%  Note that BD and BDD are cell arrays, whose elements are matrices.  BDD{j,k} for k<j
%  are not used, so should be left null to save space.


[nstate,nstate2]=size(F1); if nstate~=nstate2, error('F1 matrix not square'), end; 
[n,n2]=size(BD{1}); if n~=n2, error('BD{1} matrix not square'),end;   
uindex=nstate+1:n; 
sindex=1:nstate;
nu=n-nstate;
nerr=size(F2,2);
L=BD{2}(uindex,uindex)\BD{1}(uindex,uindex); 
M11 = -prodt(BDD{1,2}(uindex,sindex,sindex),F1,2,1); 

M11=M11+permute(M11,[1 3 2])-prodt(prodt(BDD{1,1}(uindex,sindex,sindex),F1,2,1),F1,2,1)...
   -BDD{2,2}(uindex,sindex,sindex);

% JANUARY 12, 2002
%M11=2*M11-prodt(prodt(BDD{1,1}(uindex,sindex,sindex),F1,2,1),F1,2,1)...
%   -BDD{2,2}(uindex,sindex,sindex);

% If do not use permute(M11,[1 3 2]): tHIS yields the quadratic form y'M11*y
% M11=2*M11-prodt(prodt(BDD{1,1}(uindex,sindex,sindex),F1,2,1),F1,2,1)...
%   -BDD{2,2}(uindex,sindex,sindex);

M11(:)=BD{2}(uindex,uindex)\M11(:,:);
%------------------Doubling algorithm-------------------------
R=F1; 
eest=1; 
Minc=zeros(size(M11)); 
crit= 10*sqrt((n-nstate)*nstate*nstate)*eps; 
dblinc=0;
while eest>crit & dblinc<200
   Minc(:)=L*M11(:,:);
   M11=M11+prodt(prodt(Minc,R,2,1),R,2,1);
   L=L*L;
   R=R*R;
   eest=sqrt(sum(sum(sum(Minc.*Minc))));
   dblinc=dblinc+1;
end
%fprintf(1,'dblinc=%d, eest=%g\n',dblinc,eest);
if dblinc>200
   fprintf(1,'Inaccuracy %g+%gi in order2guts.m\n ', [real(eest) imag(eest)])
   rc=1;
else
   rc=0;
end

% ==========================================================

worka=prodt(prodt(M11,F1,2,1),F1,2,1); 
	S1=worka;
worka=reshape(-BD{1}(sindex,uindex)*worka(:,:),[nstate,nstate,nstate]);
	S2=worka;   
workb=prodt(BDD{1,2}(sindex,sindex,sindex),F1,2,1);
workb=workb+permute(workb,[1 3 2]);
% ORIGINAL CODE
%FDD{1,1}=prodt(prodt(BDD{1,1}(sindex,sindex,sindex),F1,2,1),F1,2,1)+worka+workb...
%   +BDD{2,2}(sindex,sindex,sindex);

% CORRECTION, APRIL 12, 2001 
workc=prodt(BD{2}(sindex,uindex),M11,2,1);
FDD{1,1}=prodt(prodt(BDD{1,1}(sindex,sindex,sindex),F1,2,1),F1,2,1)+worka+workb...
   +workc + BDD{2,2}(sindex,sindex,sindex);


%----------------
worka=prodt(prodt(M11,F2,2,1,3),F2,2,1,3);
worka(:)=BD{1}(uindex,uindex)*worka(:,:);
workb=prodt(prodt(BDD{1,1}(uindex,sindex,sindex),F2,2,1,3),F2,2,1,3);
workc=prodt(BDD{1,3}(uindex,sindex,:),F2,2,1,3);
workc=workc+permute(workc,[1 3 2]);
worka=worka-workb-workc-BDD{3,3}(uindex,:,:);
M2=.5*((BD{2}(uindex,uindex)-BD{1}(uindex,uindex))\(worka(:,:)*omega(:)));  

% TM2=.5*inv(BD{2}(uindex,uindex)-BD{1}(uindex,uindex))*(worka(:,:)*omega(:));  

CONDWSL=abs(cond(BD{2}(uindex,uindex)-BD{1}(uindex,uindex)));   
save CONDWSL CONDWSL;

DEH=0;  % NOVEMBER 4, 2001
if DEH==1; 
% JULY 12, 2001
if CONDWSL>1e5; save order;
   disp('ORDER2GUTS: BD{2}(uindex,uindex)-BD{2}(..) IS ILL CONDITIONED');
   disp('CONDWSL  is  ');  CONDWSL
   M11=[]; M2=[]; FDD{1,1}=[]; FDD{1,2}=[]; FDD{2,2}=[]; F3=[]; rc=[]; 
return;   end;
end;  %end DEH...

%----------------
worka=prodt(prodt(M11,F1,2,1),F2,2,1,3);
worka=reshape(-BD{1}(sindex,uindex)*worka(:,:),[nstate,nstate,nerr]);
  HK1=worka;
  
% THIS IS ORIGINAL CODE  
% workb=prodt(BDD{1,2}(sindex,sindex,sindex),F2,3 [!],1)...
% +permute(prodt(BDD{1,3}(sindex,sindex,:),F1,2,1,3),[1 3 2])+BDD{2,3}(sindex,sindex,:);

% APRIL 12, 2001: changed code: prodt(BDD{1,2}(sindex,sindex,sindex),F2, 2[!] ,1)...
%workb=prodt(BDD{1,2}(sindex,sindex,sindex),F2,2,1)...
%   +permute(prodt(BDD{1,3}(sindex,sindex,:),F1,2,1,3),[1 3 2])+BDD{2,3}(sindex,sindex,:);

% APRIL 12, 2001: changed code: prodt(BDD{1,2}(sindex,sindex,sindex),F2, 2[!] ,1, 3[!])...
% CHANGED DECEMBER 17, 2001 (message from CSims). In 1st line: ,F2,2,1, 3[!]) ...
workb=prodt(BDD{1,2}(sindex,sindex,sindex),F2,2,1,3)...
   +permute(prodt(BDD{1,3}(sindex,sindex,:),F1,2,1,3),[1 3 2])+BDD{2,3}(sindex,sindex,:);



HK2=prodt(prodt(BDD{1,1}(sindex,sindex,sindex),F1,2,1),F2,2,1,3);
HK3=prodt(BDD{1,2}(sindex,sindex,sindex),F2,2,1);
HK4=permute(prodt(BDD{1,3}(sindex,sindex,:),F1,2,1,3),[1 3 2]);
HK5=BDD{2,3}(sindex,sindex,:);

FDD{1,2}=prodt(prodt(BDD{1,1}(sindex,sindex,sindex),F1,2,1),F2,2,1,3)+worka+workb;


%--------------
worka=prodt(prodt(M11,F2,2,1,3),F2,2,1,3);
worka=reshape(-BD{1}(sindex,uindex)*worka(:,:),[nstate,nerr,nerr]);
worka=worka+prodt(prodt(BDD{1,1}(sindex,sindex,sindex),F2,2,1,3),F2,2,1,3);
workb=prodt(BDD{1,3}(sindex,sindex,:),F2,2,1,3);
workb=workb+permute(workb,[1 3 2]);
FDD{2,2}=worka+workb+BDD{3,3}(sindex,:,:);
%---------------------


% ORIGINAL CODE
% F3=-BD{1}(sindex,uindex)*M2;

% CORRECTION, APRIL 12, 2001
F3=(-BD{1}(sindex,uindex)+BD{2}(sindex,uindex))*M2; 



% =============================================================================
% ====================== TESTS (see order2test.m) =============================

TESTWSL=0;
% ------------------------------------------------------------

TESTJAN=0;
if TESTJAN==1;

% !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% FOR ADDITIONAL TESTS: SEE c:\sims\soe\tests.m 
% !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

%----------------------------------------------------------------------
% A. CHECK whether (16) holds
% A.1. Check whether terms in dy dy  match across LHS and RHS of (16)


yL=randn(cols(sindex),1)+sqrt(-1)*randn(cols(sindex),1);
y=F1*yL;

A=prodt(prodt(M11,y,2,1),y,2,1);
A1=.5*prodt(BD{1}(uindex,uindex),A,2,1);

B=prodt(prodt(M11,yL,2,1),yL,2,1);
B1=.5*prodt(BD{2}(uindex,uindex),B,2,1);

C=.5*prodt(prodt(BDD{1,1}(uindex,sindex,sindex),y,2,1),y,2,1);

D=prodt(prodt(BDD{1,2}(uindex,sindex,sindex),y,2,1),yL,2,1);

E=.5*prodt(prodt(BDD{2,2}(uindex,sindex,sindex),yL,2,1),yL,2,1);

test16y=-A1+B1+C+D+E;
% save test16y test16y;

if maxaa(test16y)>1e-8; disp('order2guts: terms in dy*dy in(16) do not match'); 
   TESTWSL=1; save order;
  end;


% ................................................................................
% A.2.  Check whether terms in omega and in M2 match across LHS and RHS of (16)

YHS0=0.5*prodt(prodt(prodt(BD{1,1}(uindex,uindex),M11,2,1,2),F2,2,1,3),F2,2,1,3);

YHS1=zeros(rows(YHS0),1);
eqe=ones(rows(omega),1);
i=1; while i<=rows(YHS0);
   YHS1(i,:)=eqe'*(squeeze(YHS0(i,:,:)).*omega)*eqe;
i=i+1; end;

YHS2=prodt(BD{1,1}(uindex,uindex),M2,2,1,2);

YHS3=prodt(BD{1,2}(uindex,uindex),M2,2,1,2);

YHS40=.5*prodt(prodt(BDD{1,1}(uindex,sindex,sindex),F2,2,1,3),F2,2,1,3);
YHS4=zeros(rows(YHS40),1);
i=1; while i<=rows(YHS4);
   YHS4(i,:)=eqe'*(squeeze(YHS40(i,:,:)).*omega)*eqe;
   i=i+1; end;

YHS50=prodt(BDD{1,3}(uindex,sindex,:),F2,2,1,3);
YHS5=zeros(rows(YHS50),1);
i=1; while i<=rows(YHS5);
   YHS5(i,:)=eqe'*(squeeze(YHS50(i,:,:)).*omega)*eqe;
   i=i+1; end;

YHS6=zeros(rows(BDD{3,3}(uindex,:,:)),1);
i=1; while i<=rows(YHS6);
  YHS6(i,:)=.5*eqe'*(squeeze(BDD{3,3}(i+rows(sindex),:,:)).*omega)*eqe;     
   i=i+1; end;      
      
test16om=YHS1+YHS2-YHS3-YHS4-YHS5-YHS6;
% save test16om test16om;

if maxaa(test16om)>1e-10; disp('order2guts: terms in OMEGA in(16) do not match'); 
   TESTWSL=1; save order;
  end;
   
   
% -----------------------------------------------------------------------------------   
% B. Check whether M11 solves (17)

LHS=prodt(prodt(prodt(BD{1,1}(uindex,uindex),M11,2,1,2),F1,2,1,3),F1,2,1,3);
RHS1=prodt(BD{1,2}(uindex,uindex),M11,2,1,2);
RHS2=prodt(prodt(BDD{1,1}(uindex,sindex,sindex),F1,2,1,3),F1,2,1,3);

% JANUARY 12, 2002
% RHS3=2*prodt(BDD{1,2}(uindex,sindex,sindex),F1,2,1,3);

RHS3=prodt(BDD{1,2}(uindex,sindex,sindex),F1,2,1,3);
RHS3=RHS3+permute(RHS3,[1,3,2]);

% RHS3=2*prodt(BDD{1,2}(uindex,sindex,sindex),F1,2,1,3);

RHS4=BDD{2,2}(uindex,sindex,sindex);
testM11=-LHS+RHS1+RHS2+RHS3+RHS4;
% save testM11 testM11;
if maxaa(testM11)>1e-8; disp('order2guts: computation of M11 inaccurate'); TESTWSL=1;
   save order;
  end;
% if maxaa(M11-imapermute(M11,[1 3 2])) > 1e-10; disp('M11 not symmetric'); TESTWSL=1; end;  


% ====================================================================================
% =============== Checking correspondence between (11) and (16) ======================
% Redo steps that lead from (11) to (16). Shift (11) forward by 1 period. 

y=randn(cols(sindex),1)+sqrt(-1)*randn(cols(sindex),1);
yP=F1*y;

% ..........................CHECKING TERMS IN dy*dy ....................................
% terms in (11) 
xP=.5*prodt(prodt(M11,yP,2,1),yP,2,1);
x=.5*prodt(prodt(M11,y,2,1),y,2,1);

vP=[yP;zeros(10,1)];
v=[y;zeros(10,1)];

RE1=BD{1,1}(uindex,uindex)*xP;

RE2=BD{1,2}(uindex,uindex)*x;
RE3=.5*prodt(prodt(BDD{1,1}(uindex,:,:),vP,2,1),vP,2,1);
RE4=prodt(prodt(BDD{1,2}(uindex,:,:),vP,2,1),v,2,1);
RE5=.5*prodt(prodt(BDD{2,2}(uindex,:,:),v,2,1),v,2,1);


% //////////////////////////////////////////////////7
% terms in (16) 
A=prodt(prodt(M11,yP,2,1),yP,2,1);
TE1=.5*prodt(BD{1}(uindex,uindex),A,2,1);
A11=prodt(prodt(prodt(prodt(M11,F1,2,1,3),y,3,1),F1,2,1),y,2,1);  

TE11=.5*prodt(prodt(prodt(prodt(prodt(BD{1}(uindex,uindex),M11,2,1),F1,2,1,3),y,3,1),F1,2,1),y,2,1);
TE12=.5*prodt(BD{1}(uindex,uindex),A11,2,1);


B=prodt(prodt(M11,y,2,1),y,2,1); 
TE2=.5*prodt(BD{2}(uindex,uindex),B,2,1);

TE3=.5*prodt(prodt(BDD{1,1}(uindex,sindex,sindex),yP,2,1),yP,2,1);
TE31=.5*prodt(prodt(prodt(prodt(BDD{1,1}(uindex,sindex,sindex),F1,2,1),F1,2,1),y,2,1),y,2,1);



TE4=prodt(prodt(BDD{1,2}(uindex,sindex,sindex),yP,2,1),y,2,1);
TE41=prodt(prodt(prodt(BDD{1,2}(uindex,sindex,sindex),F1,2,1),y,3,1),y,2,1);


TE5=.5*prodt(prodt(BDD{2,2}(uindex,sindex,sindex),y,2,1),y,2,1);


test161=maxaa(RE1-TE1);
test162=maxaa(RE2-TE2);
test163=maxaa(RE3-TE3);
test164=maxaa(RE4-TE4);
test165=maxaa(RE5-TE5);

test16=[test161;test162;test163;test164;test165];

% .......................................................................................

% Checking terms in omega, using stochastic simulations

STO=0; %set STO to use stochastic simulations
if STO==1; 

% ............. First term in omega.............................
C0=zeros(10,1);

trials=100000;
i=1; while i<=trials;
   if ceil(i/5000)==(i/5000); [i trials]
   end;
eP=randn(rows(omega),1).*sqrt(diag(omega));
FeP=F2*eP;
C=prodt(prodt(M11,FeP,2,1),FeP,2,1);
C0=C0+C;
i=i+1; end;

C11=C0/trials;

D1=prodt(prodt(M11,F2,2,1),F2,2,1);
D11=zeros(rows(D1),1);
eqe=ones(rows(omega),1);
i=1; while i<=rows(D1);
   D11(i,:)=eqe'*(squeeze(D1(i,:,:)).*omega)*eqe;
i=i+1; end;

[C11 D11];

%..................Second term in omega.............................
F0=zeros(10,1);

trials=100000;
i=1; while i<=trials;
   if ceil(i/5000)==(i/5000); [i trials]
   end;
eP=randn(rows(omega),1).*sqrt(diag(omega));
FeP=F2*eP;
F=prodt(prodt(BDD{1,1}(uindex,sindex,sindex),FeP,2,1),FeP,2,1);
F0=F0+F;
i=i+1; end;

F11=.5*F0/trials;


YHS40=.5*prodt(prodt(BDD{1,1}(uindex,sindex,sindex),F2,2,1,3),F2,2,1,3);
YHS4=zeros(rows(YHS40),1);
i=1; while i<=rows(YHS4);
   YHS4(i,:)=eqe'*(squeeze(YHS40(i,:,:)).*omega)*eqe;
   i=i+1; end;

[F11 YHS4];

%..................Third term in omega.............................
% NB: the third term is zero !! 

G0=zeros(10,1);

trials=10000;
i=1; while i<=trials;
   if ceil(i/5000)==(i/5000); [i trials]
   end;
eP=randn(rows(omega),1).*sqrt(diag(omega));
FeP=F2*eP;
G=prodt(prodt(BDD{1,3}(uindex,sindex,:),FeP,2,1),eP,2,1);
G0=G0+G;
i=i+1; end;

G11=G0/trials;



YHS50=prodt(BDD{1,3}(uindex,sindex,:),F2,2,1,3);
YHS5=zeros(rows(YHS50),1);
i=1; while i<=rows(YHS5);
   YHS5(i,:)=eqe'*(squeeze(YHS50(i,:,:)).*omega)*eqe;
   i=i+1; end;

[G11 YHS5];

%..................Fourth term in omega.............................
% 4th term is also zero!!


end;  % end STO



% =============================================================================
% C.  USE SIMULATION TO TEST WHETHER EQUATIONS (10) and (12) are met
G1=-BD{1}(sindex,uindex);   G2=BD{2}(sindex,:);       G3=BD{3}(sindex,:);
G11=BDD{1,1}(sindex,:,:);   G12=BDD{1,2}(sindex,:,:); G13=BDD{1,3}(sindex,:,:); 
                            G22=BDD{2,2}(sindex,:,:); G23=BDD{2,3}(sindex,:,:); 
  	  								              				   G33=BDD{3,3}(sindex,:,:);
G21=permute(G12,[1 3 2]);                                                            
G31=permute(G13,[1 3 2]);                                                            
G32=permute(G23,[1 3 2]);                                                            
                                                            
yL=randn(cols(sindex),1)+sqrt(-1)*randn(cols(sindex),1);
eH=randn(cols(F2),1);

% yL=ones(cols(sindex),1)*100+sqrt(-1)*ones(cols(sindex),1)*100;
% eH=ones(cols(F2),1)*10;


yH=F1*yL+F2*eH;       
x=zeros(cols(uindex),1);

sig=1; % value of 'sig' set here is irrelevant (provided sig>0)

R1=G1*(.5*prodt(prodt(M11,yH,2,1),yH,2,1)+M2*sig^2);  

xL=.5*prodt(prodt(M11,yL,2,1),yL,2,1)+M2*sig^2;
R2=G2*[yL;xL];
R3=G3*eH;

R4=.5*prodt(prodt(G11,[yH;x],2,1),[yH;x],2,1);  
R5=prodt(prodt(G12,[yH;x],2,1),[yL;x],2,1);

%R51=prodt(prodt(G12,[yH;x],2,1),[yL;x],2,1);
%R52=prodt(prodt(G21,[yL;x],2,1),[yH;x],2,1);
%R5=.5*(R51+R52);

R6=prodt(prodt(G13,[yH;x],2,1),eH,2,1);

%R61=prodt(prodt(G13,[yH;x],2,1),eH,2,1);
%R62=prodt(prodt(G31,eH,2,1),[yH;x],2,1);
%R6=.5*(R61+R62);


R7=.5*prodt(prodt(G22,[yL;x],2,1),[yL;x],2,1);

R8=prodt(prodt(G23,[yL;x],2,1),eH,2,1);

%R81=prodt(prodt(G23,[yL;x],2,1),eH,2,1);
%R82=prodt(prodt(G32,eH,2,1),[yL;x],2,1);
%R8=.5*(R81+R82);


R9=.5*prodt(prodt(G33,eH,2,1),eH,2,1);
TY1=R1+R2+R3+R4+R5+R6+R7+R8+R9;  %value of dy(t) determined by eqn (10)

% save order;

% &&&&&&&&&&&&&
% NEXT LOOK AT EQUATION (12)

S1=F1*yL+F2*eH+F3*sig^2;  
S2=.5*prodt(prodt(FDD{1,1},yL,2,1),yL,2,1);

S3=prodt(prodt(FDD{1,2},yL,2,1),eH,2,1);

%S31=prodt(prodt(FDD{1,2},yL,2,1),eH,2,1);
%S32=prodt(prodt(permute(FDD{1,2},[1 3 2]),eH,2,1),yL,2,1);
%S3=.5*(S31+S32);

S4=.5*prodt(prodt(FDD{2,2},eH,2,1),eH,2,1);
   
TY2=S1+S2+S3+S4;  % value of dy(t) determined by eqn (12)
y12=TY2;



test=TY1-TY2;                                                                                                                                                                             
test=(TY1-TY2)./(.001+TY1+TY2);

test1012=test; 
% test1012 test1012 TY1 TY2;


%if maxa(test) > 1e-1; disp('order2guts: (10) & (12) inaccurate'); save order; 
%    TESTWSL=1; end;

%if maxa(test) > 1e-5; disp('order2guts: (10) & (12) inaccurate'); save order; 
%    TESTWSL=1; end;


if TESTWSL==1; 
   disp('ORDER2GUTS: NUMERICAL PROBLEM(S)!!'); save order;
   M11=[]; M2=[]; FDD{1,1}=[]; FDD{1,2}=[]; FDD{2,2}=[]; F3=[]; rc=[]; 
return;   end;

% save order33;







end;  % end TESTJAN
% ------------------------------------------------------------

return;

