function [KD,KDD,KDDALL]=pregen(f,xss1,xss3);

% MARCH 2, 2001. This takes as input the function 'f'  (the non-linear model) 
% and xss1 [xss3]  (steady state values of endogenous [exogenous] variables) 
% It returns KD and KDD; KD: matrices of first order approximation; 
%  KDD: matrices of second order approx.
%  K1 dw(t)= - K2 dw(t-1) - K3 dexo(t) .. - .5K11 dw(t)dw(t) .....
%  KD{1} dw(t) = KD{2} dw(t-1) + KD{3} dexo(t) .. + .5 KDD{1,1} dw(t)dw(t) .......


xss=[xss1;xss1;xss3];
grad=grad1(f,xss);
% hess=hess3(f,xss);  %hess3 is MUCH quicker than hess1
% hess=hessTWO(f,xss,1);  %hessTWO is MUCH quicker than hess1

% hess=hessTWOacc4_DET(f,xss,1); hess=vecmat(hess,2,rows(xss));
% hess=hessTWOacc3_DET(f,xss,1); hess=vecmat(hess,2,rows(xss));

hess=hessTWO(f,xss);


at=rows(xss1); bt=rows(xss3);

K1=grad(:,[1:at]);
K2=grad(:,[at+1:2*at]);
K3=grad(:,[2*at+1:2*at+bt]);


K11=hess(:,[1:at],[1:at]);
K12=hess(:,[1:at],[at+1:2*at]);
K13=hess(:,[1:at],[2*at+1:2*at+bt]);

K21=hess(:,[at+1:2*at],[1:at]);
K22=hess(:,[at+1:2*at],[at+1:2*at]);
K23=hess(:,[at+1:2*at],[2*at+1:2*at+bt]);

K31=hess(:,[2*at+1:2*at+bt],[1:at]);
K32=hess(:,[2*at+1:2*at+bt],[at+1:2*at]);
K33=hess(:,[2*at+1:2*at+bt],[2*at+1:2*at+bt]);

KD=cell(1,3);

KD{1,1}=K1;
KD{1,2}=-K2;
KD{1,3}=-K3;

KDD=cell(3,3);
KDD{1,1}=-K11;
KDD{1,2}=-K12;
KDD{1,3}=-K13;

KDD{2,1}=-K21;
KDD{2,2}=-K22;
KDD{2,3}=-K23;

KDD{3,1}=-K31;
KDD{3,2}=-K32;
KDD{3,3}=-K33;

KDDALL=-hess;
