% produce table 8-2  using the saved file hL.mat generated by KKK_simul.m

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%calculating statistics in section 8.2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 1. without ALM
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
load hL; %generated from KKK_simul.m
z=hL;

% followings are all row vectors

c=(z(1:end-1,1))';       % individual CONSUMPTION 
Lab=(z(1:end-1,2))';        % indiv employment (=EPSILON(t)). HOURS worked = Lab/.9
k=(z(2:end,3))';  % indiv k(t+1)  (individual capital stock)
kL=(z(1:end-1,3))';  % indiv k(t)  (individual capital stock)
CA=(z(1:end-1,4))';       % AGGGREGATE consumption (or repr agent economy)
LabMEAN=z(1:end-1,5)';  %agg labor
kMEAN=(z(2:end,6))';  %agg capital at t
kMEANL=(z(1:end-1,6))';  %agg K at t-1
theta=z(1:end-1,7)';  % agg shock

gdp=theta.*(kMEANL.^ALPHA).*((LabMEAN/.9).^(1-ALPHA));   % per capita GDP
wage=(1-ALPHA)*theta.*(kMEANL./(LabMEAN/.9)).^ALPHA;    
rental=ALPHA*theta.*(kMEANL./(LabMEAN/.9)).^(ALPHA-1); 

u=1-LabMEAN;  % unemployment rate
tax=REPLACEMENT*u./((LabMEAN/.9));
GDPSS=(KSS^ALPHA)*(LabSS/.9)^(1-ALPHA);  %Steady state GDP
INVEST=kMEAN-(1-DEPREC)*kMEANL;  % investment

%       (1)     (2)  (3) (4)   (5)
auxx=[rental; wage; gdp; CA; INVEST;];
auxx=auxx';    %  now it is by the column

rSTAT2=[];
j=1; while j<6;
    rSTAT11=[mean(auxx(:,j)) std(auxx(:,j)) corrCROSS(auxx(:,j),auxx(:,j),3)];
    rSTAT2=[rSTAT2; rSTAT11];
    j=j+1;
end;

rSTAT3=[];
j=4; while j<=5;
    rSTAT11=corrCROSS(auxx(:,j),auxx(:,3),3);
    rSTAT3=[rSTAT3; rSTAT11];
    j=j+1;
end;

display(' 8.2 Statistics without ALM ');

rSTAT2
rSTAT3
    
%----------------------------------------------------------------------------------------------------------------------------
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 2. With ALM
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
load hL_AG;   %load this data for the statistics with ALM
z=hL_AG;

% followings are all row vectors

c=(z(1:end-1,1))';       % individual CONSUMPTION 
Lab=(z(1:end-1,2))';        % indiv employment (=EPSILON(t)). HOURS worked = Lab/.9
k=(z(2:end,3))';  % indiv k(t+1)  (individual capital stock)
kL=(z(1:end-1,3))';  % indiv k(t)  (individual capital stock)
CA=(z(1:end-1,4))';       % AGGGREGATE consumption (or repr agent economy)
LabMEAN=z(1:end-1,5)';  %agg labor
kMEAN=(z(2:end,6))';  %agg capital at t
kMEANL=(z(1:end-1,6))';  %agg K at t-1
theta=z(1:end-1,7)';  % agg shock

gdp=theta.*(kMEANL.^ALPHA).*((LabMEAN/.9).^(1-ALPHA));   % per capita GDP
wage=(1-ALPHA)*theta.*(kMEANL./(LabMEAN/.9)).^ALPHA;    
rental=ALPHA*theta.*(kMEANL./(LabMEAN/.9)).^(ALPHA-1); 

u=1-LabMEAN;  % unemployment rate
tax=REPLACEMENT*u./((LabMEAN/.9));
GDPSS=(KSS^ALPHA)*(LabSS/.9)^(1-ALPHA);  %Steady state GDP
INVEST=kMEAN-(1-DEPREC)*kMEANL;  % investment

%       (1)     (2)  (3) (4)   (5)
auxx=[rental; wage; gdp; CA; INVEST;];
auxx=auxx';    %  now it is by the column

rSTAT2=[];
j=1; while j<6;
    rSTAT11=[mean(auxx(:,j)) std(auxx(:,j)) corrCROSS(auxx(:,j),auxx(:,j),3)];
    rSTAT2=[rSTAT2; rSTAT11];
    j=j+1;
end;

rSTAT3=[];
j=4; while j<=5;
    rSTAT11=corrCROSS(auxx(:,j),auxx(:,3),3);
    rSTAT3=[rSTAT3; rSTAT11];
    j=j+1;
end;

display(' 8.2 Statistics with ALM ');

rSTAT2
rSTAT3

